/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AgreementFile;
import com.microsoft.graph.models.AgreementFileData;
import com.microsoft.graph.models.AgreementFileLocalization;
import com.microsoft.graph.models.AgreementFileVersion;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AgreementFileProperties
extends Entity
implements Parsable {
    @Nonnull
    public static AgreementFileProperties createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.agreementFile": {
                    return new AgreementFile();
                }
                case "#microsoft.graph.agreementFileLocalization": {
                    return new AgreementFileLocalization();
                }
                case "#microsoft.graph.agreementFileVersion": {
                    return new AgreementFileVersion();
                }
            }
        }
        return new AgreementFileProperties();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("fileData", n -> this.setFileData((AgreementFileData)n.getObjectValue(AgreementFileData::createFromDiscriminatorValue)));
        deserializerMap.put("fileName", n -> this.setFileName(n.getStringValue()));
        deserializerMap.put("isDefault", n -> this.setIsDefault(n.getBooleanValue()));
        deserializerMap.put("isMajorVersion", n -> this.setIsMajorVersion(n.getBooleanValue()));
        deserializerMap.put("language", n -> this.setLanguage(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public AgreementFileData getFileData() {
        return (AgreementFileData)this.backingStore.get("fileData");
    }

    @Nullable
    public String getFileName() {
        return (String)this.backingStore.get("fileName");
    }

    @Nullable
    public Boolean getIsDefault() {
        return (Boolean)this.backingStore.get("isDefault");
    }

    @Nullable
    public Boolean getIsMajorVersion() {
        return (Boolean)this.backingStore.get("isMajorVersion");
    }

    @Nullable
    public String getLanguage() {
        return (String)this.backingStore.get("language");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("fileData", (Parsable)this.getFileData(), new Parsable[0]);
        writer.writeStringValue("fileName", this.getFileName());
        writer.writeBooleanValue("isDefault", this.getIsDefault());
        writer.writeBooleanValue("isMajorVersion", this.getIsMajorVersion());
        writer.writeStringValue("language", this.getLanguage());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setFileData(@Nullable AgreementFileData value) {
        this.backingStore.set("fileData", (Object)value);
    }

    public void setFileName(@Nullable String value) {
        this.backingStore.set("fileName", (Object)value);
    }

    public void setIsDefault(@Nullable Boolean value) {
        this.backingStore.set("isDefault", (Object)value);
    }

    public void setIsMajorVersion(@Nullable Boolean value) {
        this.backingStore.set("isMajorVersion", (Object)value);
    }

    public void setLanguage(@Nullable String value) {
        this.backingStore.set("language", (Object)value);
    }
}

