/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingCustomerBase;
import com.microsoft.graph.models.Phone;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingCustomer
extends BookingCustomerBase
implements Parsable {
    public BookingCustomer() {
        this.setOdataType("#microsoft.graph.bookingCustomer");
    }

    @Nonnull
    public static BookingCustomer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingCustomer();
    }

    @Nullable
    public List<PhysicalAddress> getAddresses() {
        return (List)this.backingStore.get("addresses");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getEmailAddress() {
        return (String)this.backingStore.get("emailAddress");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("addresses", n -> this.setAddresses(n.getCollectionOfObjectValues(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("emailAddress", n -> this.setEmailAddress(n.getStringValue()));
        deserializerMap.put("phones", n -> this.setPhones(n.getCollectionOfObjectValues(Phone::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<Phone> getPhones() {
        return (List)this.backingStore.get("phones");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("addresses", this.getAddresses());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("emailAddress", this.getEmailAddress());
        writer.writeCollectionOfObjectValues("phones", this.getPhones());
    }

    public void setAddresses(@Nullable List<PhysicalAddress> value) {
        this.backingStore.set("addresses", value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEmailAddress(@Nullable String value) {
        this.backingStore.set("emailAddress", (Object)value);
    }

    public void setPhones(@Nullable List<Phone> value) {
        this.backingStore.set("phones", value);
    }
}

