/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.OfferShiftRequest;
import com.microsoft.graph.models.OpenShift;
import com.microsoft.graph.models.OpenShiftChangeRequest;
import com.microsoft.graph.models.ScheduleChangeRequest;
import com.microsoft.graph.models.SchedulingGroup;
import com.microsoft.graph.models.Shift;
import com.microsoft.graph.models.ShiftPreferences;
import com.microsoft.graph.models.SwapShiftsChangeRequest;
import com.microsoft.graph.models.TimeOff;
import com.microsoft.graph.models.TimeOffReason;
import com.microsoft.graph.models.TimeOffRequest;
import com.microsoft.graph.models.WorkforceIntegration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ChangeTrackedEntity
extends Entity
implements Parsable {
    @Nonnull
    public static ChangeTrackedEntity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.offerShiftRequest": {
                    return new OfferShiftRequest();
                }
                case "#microsoft.graph.openShift": {
                    return new OpenShift();
                }
                case "#microsoft.graph.openShiftChangeRequest": {
                    return new OpenShiftChangeRequest();
                }
                case "#microsoft.graph.scheduleChangeRequest": {
                    return new ScheduleChangeRequest();
                }
                case "#microsoft.graph.schedulingGroup": {
                    return new SchedulingGroup();
                }
                case "#microsoft.graph.shift": {
                    return new Shift();
                }
                case "#microsoft.graph.shiftPreferences": {
                    return new ShiftPreferences();
                }
                case "#microsoft.graph.swapShiftsChangeRequest": {
                    return new SwapShiftsChangeRequest();
                }
                case "#microsoft.graph.timeOff": {
                    return new TimeOff();
                }
                case "#microsoft.graph.timeOffReason": {
                    return new TimeOffReason();
                }
                case "#microsoft.graph.timeOffRequest": {
                    return new TimeOffRequest();
                }
                case "#microsoft.graph.workforceIntegration": {
                    return new WorkforceIntegration();
                }
            }
        }
        return new ChangeTrackedEntity();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }
}

