/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BaseItemVersion;
import com.microsoft.graph.models.DocumentSetVersion;
import com.microsoft.graph.models.FieldValueSet;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ListItemVersion
extends BaseItemVersion
implements Parsable {
    public ListItemVersion() {
        this.setOdataType("#microsoft.graph.listItemVersion");
    }

    @Nonnull
    public static ListItemVersion createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.documentSetVersion": {
                    return new DocumentSetVersion();
                }
            }
        }
        return new ListItemVersion();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("fields", n -> this.setFields((FieldValueSet)n.getObjectValue(FieldValueSet::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public FieldValueSet getFields() {
        return (FieldValueSet)this.backingStore.get("fields");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("fields", (Parsable)this.getFields(), new Parsable[0]);
    }

    public void setFields(@Nullable FieldValueSet value) {
        this.backingStore.set("fields", (Object)value);
    }
}

