/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.OnenoteEntityBaseModel;
import com.microsoft.graph.models.OnenoteEntityHierarchyModel;
import com.microsoft.graph.models.OnenotePage;
import com.microsoft.graph.models.OnenoteSection;
import com.microsoft.graph.models.SectionGroup;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OnenoteEntitySchemaObjectModel
extends OnenoteEntityBaseModel
implements Parsable {
    public OnenoteEntitySchemaObjectModel() {
        this.setOdataType("#microsoft.graph.onenoteEntitySchemaObjectModel");
    }

    @Nonnull
    public static OnenoteEntitySchemaObjectModel createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.notebook": {
                    return new Notebook();
                }
                case "#microsoft.graph.onenoteEntityHierarchyModel": {
                    return new OnenoteEntityHierarchyModel();
                }
                case "#microsoft.graph.onenotePage": {
                    return new OnenotePage();
                }
                case "#microsoft.graph.onenoteSection": {
                    return new OnenoteSection();
                }
                case "#microsoft.graph.sectionGroup": {
                    return new SectionGroup();
                }
            }
        }
        return new OnenoteEntitySchemaObjectModel();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }
}

