/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AssignedPlan;
import com.microsoft.graph.models.CertificateBasedAuthConfiguration;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.MdmAuthority;
import com.microsoft.graph.models.OrganizationalBranding;
import com.microsoft.graph.models.PartnerTenantType;
import com.microsoft.graph.models.PrivacyProfile;
import com.microsoft.graph.models.ProvisionedPlan;
import com.microsoft.graph.models.VerifiedDomain;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Organization
extends DirectoryObject
implements Parsable {
    public Organization() {
        this.setOdataType("#microsoft.graph.organization");
    }

    @Nonnull
    public static Organization createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Organization();
    }

    @Nullable
    public List<AssignedPlan> getAssignedPlans() {
        return (List)this.backingStore.get("assignedPlans");
    }

    @Nullable
    public OrganizationalBranding getBranding() {
        return (OrganizationalBranding)this.backingStore.get("branding");
    }

    @Nullable
    public List<String> getBusinessPhones() {
        return (List)this.backingStore.get("businessPhones");
    }

    @Nullable
    public List<CertificateBasedAuthConfiguration> getCertificateBasedAuthConfiguration() {
        return (List)this.backingStore.get("certificateBasedAuthConfiguration");
    }

    @Nullable
    public String getCity() {
        return (String)this.backingStore.get("city");
    }

    @Nullable
    public String getCountry() {
        return (String)this.backingStore.get("country");
    }

    @Nullable
    public String getCountryLetterCode() {
        return (String)this.backingStore.get("countryLetterCode");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDefaultUsageLocation() {
        return (String)this.backingStore.get("defaultUsageLocation");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignedPlans", n -> this.setAssignedPlans(n.getCollectionOfObjectValues(AssignedPlan::createFromDiscriminatorValue)));
        deserializerMap.put("branding", n -> this.setBranding((OrganizationalBranding)n.getObjectValue(OrganizationalBranding::createFromDiscriminatorValue)));
        deserializerMap.put("businessPhones", n -> this.setBusinessPhones(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("certificateBasedAuthConfiguration", n -> this.setCertificateBasedAuthConfiguration(n.getCollectionOfObjectValues(CertificateBasedAuthConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("city", n -> this.setCity(n.getStringValue()));
        deserializerMap.put("country", n -> this.setCountry(n.getStringValue()));
        deserializerMap.put("countryLetterCode", n -> this.setCountryLetterCode(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("defaultUsageLocation", n -> this.setDefaultUsageLocation(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("marketingNotificationEmails", n -> this.setMarketingNotificationEmails(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("mobileDeviceManagementAuthority", n -> this.setMobileDeviceManagementAuthority((MdmAuthority)n.getEnumValue(MdmAuthority::forValue)));
        deserializerMap.put("onPremisesLastSyncDateTime", n -> this.setOnPremisesLastSyncDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("onPremisesSyncEnabled", n -> this.setOnPremisesSyncEnabled(n.getBooleanValue()));
        deserializerMap.put("partnerTenantType", n -> this.setPartnerTenantType((PartnerTenantType)n.getEnumValue(PartnerTenantType::forValue)));
        deserializerMap.put("postalCode", n -> this.setPostalCode(n.getStringValue()));
        deserializerMap.put("preferredLanguage", n -> this.setPreferredLanguage(n.getStringValue()));
        deserializerMap.put("privacyProfile", n -> this.setPrivacyProfile((PrivacyProfile)n.getObjectValue(PrivacyProfile::createFromDiscriminatorValue)));
        deserializerMap.put("provisionedPlans", n -> this.setProvisionedPlans(n.getCollectionOfObjectValues(ProvisionedPlan::createFromDiscriminatorValue)));
        deserializerMap.put("securityComplianceNotificationMails", n -> this.setSecurityComplianceNotificationMails(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("securityComplianceNotificationPhones", n -> this.setSecurityComplianceNotificationPhones(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("state", n -> this.setState(n.getStringValue()));
        deserializerMap.put("street", n -> this.setStreet(n.getStringValue()));
        deserializerMap.put("technicalNotificationMails", n -> this.setTechnicalNotificationMails(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("tenantType", n -> this.setTenantType(n.getStringValue()));
        deserializerMap.put("verifiedDomains", n -> this.setVerifiedDomains(n.getCollectionOfObjectValues(VerifiedDomain::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getMarketingNotificationEmails() {
        return (List)this.backingStore.get("marketingNotificationEmails");
    }

    @Nullable
    public MdmAuthority getMobileDeviceManagementAuthority() {
        return (MdmAuthority)((Object)this.backingStore.get("mobileDeviceManagementAuthority"));
    }

    @Nullable
    public OffsetDateTime getOnPremisesLastSyncDateTime() {
        return (OffsetDateTime)this.backingStore.get("onPremisesLastSyncDateTime");
    }

    @Nullable
    public Boolean getOnPremisesSyncEnabled() {
        return (Boolean)this.backingStore.get("onPremisesSyncEnabled");
    }

    @Nullable
    public PartnerTenantType getPartnerTenantType() {
        return (PartnerTenantType)((Object)this.backingStore.get("partnerTenantType"));
    }

    @Nullable
    public String getPostalCode() {
        return (String)this.backingStore.get("postalCode");
    }

    @Nullable
    public String getPreferredLanguage() {
        return (String)this.backingStore.get("preferredLanguage");
    }

    @Nullable
    public PrivacyProfile getPrivacyProfile() {
        return (PrivacyProfile)this.backingStore.get("privacyProfile");
    }

    @Nullable
    public List<ProvisionedPlan> getProvisionedPlans() {
        return (List)this.backingStore.get("provisionedPlans");
    }

    @Nullable
    public List<String> getSecurityComplianceNotificationMails() {
        return (List)this.backingStore.get("securityComplianceNotificationMails");
    }

    @Nullable
    public List<String> getSecurityComplianceNotificationPhones() {
        return (List)this.backingStore.get("securityComplianceNotificationPhones");
    }

    @Nullable
    public String getState() {
        return (String)this.backingStore.get("state");
    }

    @Nullable
    public String getStreet() {
        return (String)this.backingStore.get("street");
    }

    @Nullable
    public List<String> getTechnicalNotificationMails() {
        return (List)this.backingStore.get("technicalNotificationMails");
    }

    @Nullable
    public String getTenantType() {
        return (String)this.backingStore.get("tenantType");
    }

    @Nullable
    public List<VerifiedDomain> getVerifiedDomains() {
        return (List)this.backingStore.get("verifiedDomains");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignedPlans", this.getAssignedPlans());
        writer.writeObjectValue("branding", (Parsable)this.getBranding(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("businessPhones", this.getBusinessPhones());
        writer.writeCollectionOfObjectValues("certificateBasedAuthConfiguration", this.getCertificateBasedAuthConfiguration());
        writer.writeStringValue("city", this.getCity());
        writer.writeStringValue("country", this.getCountry());
        writer.writeStringValue("countryLetterCode", this.getCountryLetterCode());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("defaultUsageLocation", this.getDefaultUsageLocation());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeCollectionOfPrimitiveValues("marketingNotificationEmails", this.getMarketingNotificationEmails());
        writer.writeEnumValue("mobileDeviceManagementAuthority", (Enum)this.getMobileDeviceManagementAuthority());
        writer.writeOffsetDateTimeValue("onPremisesLastSyncDateTime", this.getOnPremisesLastSyncDateTime());
        writer.writeBooleanValue("onPremisesSyncEnabled", this.getOnPremisesSyncEnabled());
        writer.writeEnumValue("partnerTenantType", (Enum)this.getPartnerTenantType());
        writer.writeStringValue("postalCode", this.getPostalCode());
        writer.writeStringValue("preferredLanguage", this.getPreferredLanguage());
        writer.writeObjectValue("privacyProfile", (Parsable)this.getPrivacyProfile(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("provisionedPlans", this.getProvisionedPlans());
        writer.writeCollectionOfPrimitiveValues("securityComplianceNotificationMails", this.getSecurityComplianceNotificationMails());
        writer.writeCollectionOfPrimitiveValues("securityComplianceNotificationPhones", this.getSecurityComplianceNotificationPhones());
        writer.writeStringValue("state", this.getState());
        writer.writeStringValue("street", this.getStreet());
        writer.writeCollectionOfPrimitiveValues("technicalNotificationMails", this.getTechnicalNotificationMails());
        writer.writeStringValue("tenantType", this.getTenantType());
        writer.writeCollectionOfObjectValues("verifiedDomains", this.getVerifiedDomains());
    }

    public void setAssignedPlans(@Nullable List<AssignedPlan> value) {
        this.backingStore.set("assignedPlans", value);
    }

    public void setBranding(@Nullable OrganizationalBranding value) {
        this.backingStore.set("branding", (Object)value);
    }

    public void setBusinessPhones(@Nullable List<String> value) {
        this.backingStore.set("businessPhones", value);
    }

    public void setCertificateBasedAuthConfiguration(@Nullable List<CertificateBasedAuthConfiguration> value) {
        this.backingStore.set("certificateBasedAuthConfiguration", value);
    }

    public void setCity(@Nullable String value) {
        this.backingStore.set("city", (Object)value);
    }

    public void setCountry(@Nullable String value) {
        this.backingStore.set("country", (Object)value);
    }

    public void setCountryLetterCode(@Nullable String value) {
        this.backingStore.set("countryLetterCode", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDefaultUsageLocation(@Nullable String value) {
        this.backingStore.set("defaultUsageLocation", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setMarketingNotificationEmails(@Nullable List<String> value) {
        this.backingStore.set("marketingNotificationEmails", value);
    }

    public void setMobileDeviceManagementAuthority(@Nullable MdmAuthority value) {
        this.backingStore.set("mobileDeviceManagementAuthority", (Object)value);
    }

    public void setOnPremisesLastSyncDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("onPremisesLastSyncDateTime", (Object)value);
    }

    public void setOnPremisesSyncEnabled(@Nullable Boolean value) {
        this.backingStore.set("onPremisesSyncEnabled", (Object)value);
    }

    public void setPartnerTenantType(@Nullable PartnerTenantType value) {
        this.backingStore.set("partnerTenantType", (Object)value);
    }

    public void setPostalCode(@Nullable String value) {
        this.backingStore.set("postalCode", (Object)value);
    }

    public void setPreferredLanguage(@Nullable String value) {
        this.backingStore.set("preferredLanguage", (Object)value);
    }

    public void setPrivacyProfile(@Nullable PrivacyProfile value) {
        this.backingStore.set("privacyProfile", (Object)value);
    }

    public void setProvisionedPlans(@Nullable List<ProvisionedPlan> value) {
        this.backingStore.set("provisionedPlans", value);
    }

    public void setSecurityComplianceNotificationMails(@Nullable List<String> value) {
        this.backingStore.set("securityComplianceNotificationMails", value);
    }

    public void setSecurityComplianceNotificationPhones(@Nullable List<String> value) {
        this.backingStore.set("securityComplianceNotificationPhones", value);
    }

    public void setState(@Nullable String value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setStreet(@Nullable String value) {
        this.backingStore.set("street", (Object)value);
    }

    public void setTechnicalNotificationMails(@Nullable List<String> value) {
        this.backingStore.set("technicalNotificationMails", value);
    }

    public void setTenantType(@Nullable String value) {
        this.backingStore.set("tenantType", (Object)value);
    }

    public void setVerifiedDomains(@Nullable List<VerifiedDomain> value) {
        this.backingStore.set("verifiedDomains", value);
    }
}

