/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.models.SharePointIdentitySet;
import com.microsoft.graph.models.SharingInvitation;
import com.microsoft.graph.models.SharingLink;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Permission
extends Entity
implements Parsable {
    @Nonnull
    public static Permission createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Permission();
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("grantedTo", n -> this.setGrantedTo((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("grantedToIdentities", n -> this.setGrantedToIdentities(n.getCollectionOfObjectValues(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("grantedToIdentitiesV2", n -> this.setGrantedToIdentitiesV2(n.getCollectionOfObjectValues(SharePointIdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("grantedToV2", n -> this.setGrantedToV2((SharePointIdentitySet)n.getObjectValue(SharePointIdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("hasPassword", n -> this.setHasPassword(n.getBooleanValue()));
        deserializerMap.put("inheritedFrom", n -> this.setInheritedFrom((ItemReference)n.getObjectValue(ItemReference::createFromDiscriminatorValue)));
        deserializerMap.put("invitation", n -> this.setInvitation((SharingInvitation)n.getObjectValue(SharingInvitation::createFromDiscriminatorValue)));
        deserializerMap.put("link", n -> this.setLink((SharingLink)n.getObjectValue(SharingLink::createFromDiscriminatorValue)));
        deserializerMap.put("roles", n -> this.setRoles(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("shareId", n -> this.setShareId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getGrantedTo() {
        return (IdentitySet)this.backingStore.get("grantedTo");
    }

    @Nullable
    public List<IdentitySet> getGrantedToIdentities() {
        return (List)this.backingStore.get("grantedToIdentities");
    }

    @Nullable
    public List<SharePointIdentitySet> getGrantedToIdentitiesV2() {
        return (List)this.backingStore.get("grantedToIdentitiesV2");
    }

    @Nullable
    public SharePointIdentitySet getGrantedToV2() {
        return (SharePointIdentitySet)this.backingStore.get("grantedToV2");
    }

    @Nullable
    public Boolean getHasPassword() {
        return (Boolean)this.backingStore.get("hasPassword");
    }

    @Nullable
    public ItemReference getInheritedFrom() {
        return (ItemReference)this.backingStore.get("inheritedFrom");
    }

    @Nullable
    public SharingInvitation getInvitation() {
        return (SharingInvitation)this.backingStore.get("invitation");
    }

    @Nullable
    public SharingLink getLink() {
        return (SharingLink)this.backingStore.get("link");
    }

    @Nullable
    public List<String> getRoles() {
        return (List)this.backingStore.get("roles");
    }

    @Nullable
    public String getShareId() {
        return (String)this.backingStore.get("shareId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeObjectValue("grantedTo", (Parsable)this.getGrantedTo(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("grantedToIdentities", this.getGrantedToIdentities());
        writer.writeCollectionOfObjectValues("grantedToIdentitiesV2", this.getGrantedToIdentitiesV2());
        writer.writeObjectValue("grantedToV2", (Parsable)this.getGrantedToV2(), new Parsable[0]);
        writer.writeBooleanValue("hasPassword", this.getHasPassword());
        writer.writeObjectValue("inheritedFrom", (Parsable)this.getInheritedFrom(), new Parsable[0]);
        writer.writeObjectValue("invitation", (Parsable)this.getInvitation(), new Parsable[0]);
        writer.writeObjectValue("link", (Parsable)this.getLink(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("roles", this.getRoles());
        writer.writeStringValue("shareId", this.getShareId());
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setGrantedTo(@Nullable IdentitySet value) {
        this.backingStore.set("grantedTo", (Object)value);
    }

    public void setGrantedToIdentities(@Nullable List<IdentitySet> value) {
        this.backingStore.set("grantedToIdentities", value);
    }

    public void setGrantedToIdentitiesV2(@Nullable List<SharePointIdentitySet> value) {
        this.backingStore.set("grantedToIdentitiesV2", value);
    }

    public void setGrantedToV2(@Nullable SharePointIdentitySet value) {
        this.backingStore.set("grantedToV2", (Object)value);
    }

    public void setHasPassword(@Nullable Boolean value) {
        this.backingStore.set("hasPassword", (Object)value);
    }

    public void setInheritedFrom(@Nullable ItemReference value) {
        this.backingStore.set("inheritedFrom", (Object)value);
    }

    public void setInvitation(@Nullable SharingInvitation value) {
        this.backingStore.set("invitation", (Object)value);
    }

    public void setLink(@Nullable SharingLink value) {
        this.backingStore.set("link", (Object)value);
    }

    public void setRoles(@Nullable List<String> value) {
        this.backingStore.set("roles", value);
    }

    public void setShareId(@Nullable String value) {
        this.backingStore.set("shareId", (Object)value);
    }
}

