/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.DataSourceContainer;
import com.microsoft.graph.models.security.EdiscoveryIndexOperation;
import com.microsoft.graph.models.security.SiteSource;
import com.microsoft.graph.models.security.UnifiedGroupSource;
import com.microsoft.graph.models.security.UserSource;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EdiscoveryCustodian
extends DataSourceContainer
implements Parsable {
    public EdiscoveryCustodian() {
        this.setOdataType("#microsoft.graph.security.ediscoveryCustodian");
    }

    @Nonnull
    public static EdiscoveryCustodian createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EdiscoveryCustodian();
    }

    @Nullable
    public OffsetDateTime getAcknowledgedDateTime() {
        return (OffsetDateTime)this.backingStore.get("acknowledgedDateTime");
    }

    @Nullable
    public String getEmail() {
        return (String)this.backingStore.get("email");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("acknowledgedDateTime", n -> this.setAcknowledgedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("email", n -> this.setEmail(n.getStringValue()));
        deserializerMap.put("lastIndexOperation", n -> this.setLastIndexOperation((EdiscoveryIndexOperation)n.getObjectValue(EdiscoveryIndexOperation::createFromDiscriminatorValue)));
        deserializerMap.put("siteSources", n -> this.setSiteSources(n.getCollectionOfObjectValues(SiteSource::createFromDiscriminatorValue)));
        deserializerMap.put("unifiedGroupSources", n -> this.setUnifiedGroupSources(n.getCollectionOfObjectValues(UnifiedGroupSource::createFromDiscriminatorValue)));
        deserializerMap.put("userSources", n -> this.setUserSources(n.getCollectionOfObjectValues(UserSource::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public EdiscoveryIndexOperation getLastIndexOperation() {
        return (EdiscoveryIndexOperation)this.backingStore.get("lastIndexOperation");
    }

    @Nullable
    public List<SiteSource> getSiteSources() {
        return (List)this.backingStore.get("siteSources");
    }

    @Nullable
    public List<UnifiedGroupSource> getUnifiedGroupSources() {
        return (List)this.backingStore.get("unifiedGroupSources");
    }

    @Nullable
    public List<UserSource> getUserSources() {
        return (List)this.backingStore.get("userSources");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("acknowledgedDateTime", this.getAcknowledgedDateTime());
        writer.writeStringValue("email", this.getEmail());
        writer.writeObjectValue("lastIndexOperation", (Parsable)this.getLastIndexOperation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("siteSources", this.getSiteSources());
        writer.writeCollectionOfObjectValues("unifiedGroupSources", this.getUnifiedGroupSources());
        writer.writeCollectionOfObjectValues("userSources", this.getUserSources());
    }

    public void setAcknowledgedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("acknowledgedDateTime", (Object)value);
    }

    public void setEmail(@Nullable String value) {
        this.backingStore.set("email", (Object)value);
    }

    public void setLastIndexOperation(@Nullable EdiscoveryIndexOperation value) {
        this.backingStore.set("lastIndexOperation", (Object)value);
    }

    public void setSiteSources(@Nullable List<SiteSource> value) {
        this.backingStore.set("siteSources", value);
    }

    public void setUnifiedGroupSources(@Nullable List<UnifiedGroupSource> value) {
        this.backingStore.set("unifiedGroupSources", value);
    }

    public void setUserSources(@Nullable List<UserSource> value) {
        this.backingStore.set("userSources", value);
    }
}

