/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.users.item.mailfolders;

import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.models.MailFolderCollectionResponse;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.users.item.mailfolders.count.CountRequestBuilder;
import com.microsoft.graph.users.item.mailfolders.delta.DeltaRequestBuilder;
import com.microsoft.graph.users.item.mailfolders.item.MailFolderItemRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MailFoldersRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public CountRequestBuilder count() {
        return new CountRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DeltaRequestBuilder delta() {
        return new DeltaRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MailFolderItemRequestBuilder byMailFolderId(@Nonnull String mailFolderId) {
        Objects.requireNonNull(mailFolderId);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("mailFolder%2Did", mailFolderId);
        return new MailFolderItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public MailFoldersRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/users/{user%2Did}/mailFolders{?%24count,%24expand,%24filter,%24orderby,%24select,%24skip,%24top,includeHiddenFolders*}", pathParameters);
    }

    public MailFoldersRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/users/{user%2Did}/mailFolders{?%24count,%24expand,%24filter,%24orderby,%24select,%24skip,%24top,includeHiddenFolders*}", rawUrl);
    }

    @Nullable
    public MailFolderCollectionResponse get() {
        return this.get(null);
    }

    @Nullable
    public MailFolderCollectionResponse get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (MailFolderCollectionResponse)this.requestAdapter.send(requestInfo, errorMapping, MailFolderCollectionResponse::createFromDiscriminatorValue);
    }

    @Nullable
    public MailFolder post(@Nonnull MailFolder body) {
        return this.post(body, null);
    }

    @Nullable
    public MailFolder post(@Nonnull MailFolder body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (MailFolder)this.requestAdapter.send(requestInfo, errorMapping, MailFolder::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull MailFolder body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull MailFolder body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public MailFoldersRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new MailFoldersRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Boolean count;
        @Nullable
        public String[] expand;
        @Nullable
        public String filter;
        @Nullable
        public String includeHiddenFolders;
        @Nullable
        public String[] orderby;
        @Nullable
        public String[] select;
        @Nullable
        public Integer skip;
        @Nullable
        public Integer top;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24count", this.count);
            allQueryParams.put("%24filter", this.filter);
            allQueryParams.put("includeHiddenFolders", this.includeHiddenFolders);
            allQueryParams.put("%24skip", this.skip);
            allQueryParams.put("%24top", this.top);
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24orderby", this.orderby);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

