/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.middleware.options.TelemetryHandlerOption;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TelemetryHandler
implements Interceptor {
    @Nonnull
    private final TelemetryHandlerOption _telemetryHandlerOption;

    public TelemetryHandler() {
        this(null);
    }

    public TelemetryHandler(@Nullable TelemetryHandlerOption telemetryHandlerOption) {
        this._telemetryHandlerOption = telemetryHandlerOption == null ? new TelemetryHandlerOption() : telemetryHandlerOption;
    }

    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Function<Request, Request> telemetryConfigurator;
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = chain.request();
        TelemetryHandlerOption telemetryHandlerOption = (TelemetryHandlerOption)request.tag(TelemetryHandlerOption.class);
        if (telemetryHandlerOption == null) {
            telemetryHandlerOption = this._telemetryHandlerOption;
        }
        if ((telemetryConfigurator = telemetryHandlerOption.telemetryConfigurator) == null) {
            return chain.proceed(request);
        }
        Request enrichedRequest = telemetryConfigurator.apply(request);
        return chain.proceed(enrichedRequest);
    }
}

