/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware.options;

import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.http.middleware.options.IShouldRedirect;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class RedirectHandlerOption
implements RequestOption {
    private int maxRedirects;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final int MAX_REDIRECTS = 20;
    @Nonnull
    private final IShouldRedirect shouldRedirect;
    @Nonnull
    public static final IShouldRedirect DEFAULT_SHOULD_REDIRECT = response -> true;

    public RedirectHandlerOption() {
        this(5, DEFAULT_SHOULD_REDIRECT);
    }

    public RedirectHandlerOption(int maxRedirects, @Nullable IShouldRedirect shouldRedirect) {
        if (maxRedirects < 0) {
            throw new IllegalArgumentException("Max redirects cannot be negative");
        }
        if (maxRedirects > 20) {
            throw new IllegalArgumentException("Max redirect cannot exceed 20");
        }
        this.maxRedirects = maxRedirects;
        this.shouldRedirect = shouldRedirect != null ? shouldRedirect : DEFAULT_SHOULD_REDIRECT;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    @Nonnull
    public IShouldRedirect shouldRedirect() {
        return this.shouldRedirect;
    }

    @Nonnull
    public <T extends RequestOption> Class<T> getType() {
        return RedirectHandlerOption.class;
    }
}

