/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;

final class Parameter {
    private static final String NULL = "null";
    private boolean isOutput;
    private int jdbcType = 999;
    private int outScale = 4;
    String name;
    private DTV outDTV;
    private DTV inDTV;
    private DTV dtv;
    private TypeInfo typeInfo = new TypeInfo();

    Parameter() {
    }

    boolean isOutput() {
        return this.isOutput;
    }

    int getJdbcType() {
        return this.jdbcType;
    }

    void registerForOutput(int n) {
        this.isOutput = true;
        if (null == this.inDTV) {
            this.jdbcType = n;
        }
    }

    void setOutScale(int n) {
        this.outScale = n;
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    void clearInputValue() {
        this.typeInfo = null;
        this.dtv = this.outDTV;
        this.inDTV = null;
    }

    int setFromTDS(int n, byte[] byArray) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        n = this.outDTV.setFromTDS(this.typeInfo, n, byArray, true);
        this.dtv = this.outDTV;
        return n;
    }

    int setFromReturnStatus(int n, byte[] byArray) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.outDTV.setValue(4, new Integer(Util.readInt(byArray, n)), null);
        this.dtv = this.outDTV;
        return n += 4;
    }

    void setValue(int n, Object object) throws SQLServerException {
        this.setValue(n, object, null);
    }

    void setValue(int n, Object object, Object object2) throws SQLServerException {
        if (null == this.inDTV) {
            this.inDTV = new DTV();
        }
        this.inDTV.setValue(n, object, object2);
        this.jdbcType = this.inDTV.getJdbcType();
        this.dtv = this.inDTV;
    }

    boolean isSet() {
        return null != this.inDTV;
    }

    boolean isNull() {
        return this.outDTV.isNull();
    }

    Object getValue(int n) throws SQLServerException {
        return this.outDTV.getValue(n);
    }

    Object getValue(int n, Object object) throws SQLServerException {
        return this.outDTV.getValue(n, object);
    }

    byte getByte() throws SQLServerException {
        return this.outDTV.getByte();
    }

    int getInt() throws SQLServerException {
        return this.outDTV.getInt();
    }

    short getShort() throws SQLServerException {
        return this.outDTV.getShort();
    }

    String getTypeDefinition(boolean bl) throws SQLServerException {
        DTV dTV = this.dtv;
        if (null == this.dtv) {
            if (!this.isOutput) {
                return null;
            }
            dTV = new DTV();
            dTV.setValue(this.jdbcType, null, null);
        }
        GetTypeDefinitionOp getTypeDefinitionOp = new GetTypeDefinitionOp(this.outScale, bl);
        DTV.executeOp(dTV, getTypeDefinitionOp, dTV.getValue(this.jdbcType), this.jdbcType);
        return getTypeDefinitionOp.getTypeDefinition();
    }

    void sendByRPC(IOBuffer iOBuffer, int n) throws SQLServerException {
        DTV dTV = this.inDTV;
        if (null == dTV) {
            if (!this.isOutput) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(n + 1)};
                SQLServerException.makeFromDriverError(iOBuffer.getSQLServerConnection(), null, messageFormat.format(objectArray), null, false);
            }
            dTV = new DTV();
            dTV.setValue(this.jdbcType, null, null);
        }
        dTV.sendByRPC(this.name, this.jdbcType, 0, this.outScale, this.isOutput, iOBuffer, n);
    }

    final class GetTypeDefinitionOp
    extends DTVExecuteOp {
        private final int outScale;
        private final boolean sendStringParametersAsUnicode;
        private String typeDefinition;

        String getTypeDefinition() {
            return this.typeDefinition;
        }

        GetTypeDefinitionOp(int n, boolean bl) {
            this.outScale = n;
            this.sendStringParametersAsUnicode = bl;
        }

        void setTypeDefinition(int n, long l, int n2) {
            switch (n) {
                case -6: {
                    this.typeDefinition = "tinyint";
                    break;
                }
                case 5: {
                    this.typeDefinition = "smallint";
                    break;
                }
                case 4: {
                    this.typeDefinition = "int";
                    break;
                }
                case -5: {
                    this.typeDefinition = "decimal(38,0)";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.typeDefinition = "float";
                    break;
                }
                case 2: 
                case 3: {
                    if (n2 > 38) {
                        n2 = 38;
                    }
                    this.typeDefinition = "decimal(38," + n2 + ")";
                    break;
                }
                case -7: 
                case 16: {
                    this.typeDefinition = "bit";
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    this.typeDefinition = l < 8000L ? "varbinary(8000)" : "image";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.typeDefinition = "datetime";
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    int n3 = 4000;
                    if (!this.sendStringParametersAsUnicode) {
                        n3 *= 2;
                    }
                    if (l > (long)n3) {
                        this.typeDefinition = this.sendStringParametersAsUnicode ? "ntext" : "text";
                        break;
                    }
                    this.typeDefinition = this.sendStringParametersAsUnicode ? "nvarchar(4000)" : "varchar(8000)";
                    break;
                }
                case 999: {
                    this.typeDefinition = null;
                    break;
                }
                default: {
                    this.typeDefinition = "nvarchar(4000)";
                }
            }
        }

        void execute(String string, int n) throws SQLServerException {
            this.setTypeDefinition(n, null == string ? 0L : (long)string.length(), this.outScale);
        }

        void execute(Clob clob, int n) throws SQLServerException {
            long l = 0L;
            if (null != clob) {
                try {
                    l = clob.length();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(null, null, sQLException.toString(), null, false);
                }
            }
            this.setTypeDefinition(n, l, 0);
        }

        void execute(Byte by, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(Integer n, int n2) throws SQLServerException {
            this.setTypeDefinition(n2, 0L, 0);
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(Float f, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, this.outScale);
        }

        void execute(Double d, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, this.outScale);
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            int n2 = null != bigDecimal && bigDecimal.scale() > this.outScale ? bigDecimal.scale() : this.outScale;
            this.setTypeDefinition(n, 0L, n2);
        }

        void execute(Long l, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(Short s, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, 0);
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            this.setTypeDefinition(n, null == byArray ? 0L : (long)byArray.length, this.outScale);
        }

        void execute(Blob blob, int n) throws SQLServerException {
            long l = 0L;
            if (null != blob) {
                try {
                    l = blob.length();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(null, null, sQLException.toString(), null, false);
                }
            }
            this.setTypeDefinition(n, l, 0);
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            InputStreamArgs inputStreamArgs = (InputStreamArgs)dTV.getSetterArgs();
            this.setTypeDefinition(n, null == inputStream ? 0L : (long)inputStreamArgs.length, this.outScale);
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n, null == reader ? 0L : (long)((Integer)dTV.getSetterArgs()).intValue(), this.outScale);
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            this.setTypeDefinition(n, 0L, this.outScale);
        }
    }
}

