/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ClientSideCursor;
import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.ForwardOnlyDynamicServerCursor;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.KeysetServerCursor;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.ResultSetCursor;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSetMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ScrollableDynamicServerCursor;
import com.microsoft.sqlserver.jdbc.StaticServerCursor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;

public final class SQLServerResultSet
implements ResultSet {
    public static final int TYPE_SS_DIRECT_FORWARD_ONLY = 2003;
    public static final int TYPE_SS_SERVER_CURSOR_FORWARD_ONLY = 2004;
    public static final int TYPE_SS_SCROLL_STATIC = 1004;
    public static final int TYPE_SS_SCROLL_KEYSET = 1005;
    public static final int TYPE_SS_SCROLL_DYNAMIC = 1006;
    static final int TYPE_SS_SCROLL_INTERNAL = -1;
    public static final int CONCUR_SS_OPTIMISTIC_CC = 1008;
    public static final int CONCUR_SS_SCROLL_LOCKS = 1009;
    public static final int CONCUR_SS_OPTIMISTIC_CCVAL = 1010;
    SQLServerStatement stmt;
    private ResultSetMetaData metaData;
    private boolean isClosed;
    private ResultSetCursor cursor;
    private int fetchDirection;
    private int fetchSize;
    private boolean isOnInsertRow = false;
    boolean bWasNull = false;
    int accessCounter = 0;

    final int getFetchSizeInternal() {
        return this.fetchSize;
    }

    SQLServerResultSet(SQLServerStatement sQLServerStatement) {
        this.stmt = sQLServerStatement;
        this.fetchSize = sQLServerStatement.nFetchSize;
        this.fetchDirection = sQLServerStatement.nFetchDirection;
        this.cursor = !sQLServerStatement.isServerSideCursor ? new ClientSideCursor(sQLServerStatement) : (sQLServerStatement.isDynamicCursor ? (2004 == sQLServerStatement.getSQLResultSetType() ? new ForwardOnlyDynamicServerCursor(this) : new ScrollableDynamicServerCursor(this)) : (1005 == sQLServerStatement.getSQLResultSetType() ? new KeysetServerCursor(this) : new StaticServerCursor(this)));
        this.isClosed = false;
    }

    void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_resultsetClosed"), null, false);
        }
        this.stmt.checkClosed();
    }

    static void throwNotScrollable(SQLServerStatement sQLServerStatement) throws SQLServerException {
        SQLServerException.makeFromDriverError(sQLServerStatement.connection, sQLServerStatement, SQLServerException.getErrString("R_requestedOpNotSupportedOnForward"), null, true);
    }

    private void verifyScrollable() throws SQLServerException {
        if (2003 == this.stmt.getSQLResultSetType() || 2004 == this.stmt.getSQLResultSetType()) {
            SQLServerResultSet.throwNotScrollable(this.stmt);
        }
    }

    static void throwNotUpdatable(SQLServerStatement sQLServerStatement) throws SQLServerException {
        SQLServerException.makeFromDriverError(sQLServerStatement.connection, sQLServerStatement, SQLServerException.getErrString("R_resultsetNotUpdatable"), null, true);
    }

    private void verifyUpdatable() throws SQLServerException {
        if (1007 == this.stmt.resultSetConcurrency) {
            SQLServerResultSet.throwNotUpdatable(this.stmt);
        }
    }

    private void verifyOnValidRow() throws SQLServerException {
        if (!this.isOnInsertRow && !this.cursor.isOnValidRow()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
        }
    }

    private void verifyRowUpdatable() throws SQLServerException {
        if (!this.isOnInsertRow && this.cursor.rowDeleted()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_cantUpdateDeletedRow"), null, true);
        }
    }

    private void verifyNotOnDeletedRow() throws SQLServerException {
        if (1007 != this.stmt.resultSetConcurrency && this.cursor.rowDeleted()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
        }
    }

    private void verifyValidColumnIndex(int n) throws SQLServerException {
        int n2 = this.stmt.columns.length;
        if (this.stmt.isServerSideCursor) {
            --n2;
        }
        if (n < 1 || n > n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        }
    }

    private void verifyNotOnInsertRow() throws SQLServerException {
        if (this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustNotBeOnInsertRow"), null, true);
        }
    }

    public void close() throws SQLServerException {
        if (!this.isClosed) {
            if (this.stmt != null) {
                this.stmt.closeServerCursor();
            }
            this.cursor.close();
            this.isClosed = true;
            this.metaData = null;
        }
    }

    public int findColumn(String string) throws SQLServerException {
        int n;
        this.checkClosed();
        Column[] columnArray = this.stmt.columns;
        for (n = 0; n < columnArray.length; ++n) {
            if (!columnArray[n].name.equals(string)) continue;
            return n + 1;
        }
        for (n = 0; n < columnArray.length; ++n) {
            if (!columnArray[n].name.equalsIgnoreCase(string)) continue;
            return n + 1;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumnName"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        return 0;
    }

    final int getColumnCount() {
        return null != this.stmt ? this.stmt.getColumnCount() : 0;
    }

    final Column getColumn(int n) {
        return this.stmt.getColumn(n);
    }

    private void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    public void clearWarnings() throws SQLServerException {
    }

    public boolean relative(int n) throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.verifyOnValidRow();
        this.trackAccess();
        this.cancelInsert();
        this.cancelUpdates();
        return this.cursor.relative(n);
    }

    public boolean next() throws SQLServerException {
        this.checkClosed();
        this.trackAccess();
        this.cancelInsert();
        this.cancelUpdates();
        return this.cursor.next();
    }

    public boolean wasNull() throws SQLServerException {
        this.checkClosed();
        return this.bWasNull;
    }

    public boolean isBeforeFirst() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.cursor.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.cursor.isAfterLast();
    }

    public boolean isFirst() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.cursor.isFirst();
    }

    public boolean isLast() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.cursor.isLast();
    }

    public void beforeFirst() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.trackAccess();
        this.cancelInsert();
        this.cancelUpdates();
        this.cursor.beforeFirst();
    }

    public void afterLast() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.trackAccess();
        this.cancelInsert();
        this.cancelUpdates();
        this.cursor.afterLast();
    }

    public boolean first() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.cancelInsert();
        this.cancelUpdates();
        return this.cursor.first();
    }

    public boolean last() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.trackAccess();
        this.cancelInsert();
        this.cancelUpdates();
        return this.cursor.last();
    }

    public int getRow() throws SQLServerException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return 0;
        }
        return this.cursor.getRow();
    }

    public boolean absolute(int n) throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.trackAccess();
        return this.cursor.absolute(n);
    }

    public boolean previous() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.cancelInsert();
        this.cancelUpdates();
        return this.cursor.previous();
    }

    private final void cancelInsert() {
        if (this.isOnInsertRow) {
            this.isOnInsertRow = false;
            this.stmt.clearColumnsValues();
        }
    }

    public SQLWarning getWarnings() throws SQLServerException {
        return null;
    }

    public void setFetchDirection(int n) throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        if (1000 != n && 1001 != n && 1002 != n || 1000 != n && (2003 == this.stmt.resultSetType || 2004 == this.stmt.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), null, false);
        }
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLServerException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.fetchSize = 0 == n ? this.stmt.defaultFetchSize : n;
    }

    public int getFetchSize() throws SQLServerException {
        this.checkClosed();
        return this.fetchSize;
    }

    public int getType() throws SQLServerException {
        this.checkClosed();
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLServerException {
        this.checkClosed();
        return this.stmt.getResultSetConcurrency();
    }

    private Column getterGetColumn(int n) throws SQLServerException {
        this.checkClosed();
        this.verifyOnValidRow();
        this.verifyNotOnDeletedRow();
        this.verifyValidColumnIndex(n);
        this.trackAccess();
        this.cursor.getterRefreshCurrentRow();
        Column column = this.getColumn(n);
        this.bWasNull = column.isNull();
        return column;
    }

    public InputStream getAsciiStream(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        column.checkGetAsciiStream();
        return (InputStream)column.getValue(1, new Integer(3));
    }

    public InputStream getAsciiStream(String string) throws SQLServerException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLServerException {
        return (BigDecimal)this.getterGetColumn(n).getValue(3);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLServerException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        column.checkGetBinaryStream();
        InputStream inputStream = (InputStream)column.getValue(-4, new Integer(1));
        if (inputStream instanceof PLPInputStream) {
            ((PLPInputStream)inputStream).setParentResultSet(this);
        }
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLServerException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(-7);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(String string) throws SQLServerException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLServerException {
        return this.getterGetColumn(n).getByte();
    }

    public byte getByte(String string) throws SQLServerException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLServerException {
        return (byte[])this.getterGetColumn(n).getValue(-2);
    }

    public byte[] getBytes(String string) throws SQLServerException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLServerException {
        return this.getDate(n, null);
    }

    public Date getDate(String string) throws SQLServerException {
        return this.getDate(this.findColumn(string), null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLServerException {
        return (Date)this.getterGetColumn(n).getValue(91, calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(8);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public double getDouble(String string) throws SQLServerException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(6);
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float getFloat(String string) throws SQLServerException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLServerException {
        return this.getterGetColumn(n).getInt();
    }

    public int getInt(String string) throws SQLServerException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(-5);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public long getLong(String string) throws SQLServerException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new SQLServerResultSetMetaData(this.stmt.connection, this);
        }
        return this.metaData;
    }

    public Object getObject(int n) throws SQLServerException {
        int n2;
        Column column = this.getterGetColumn(n);
        Object object = column.getValue(n2 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength()));
        if (object == null) {
            return null;
        }
        if (object instanceof PLPInputStream) {
            ((PLPInputStream)object).setParentResultSet(this);
        }
        return object;
    }

    public Object getObject(String string) throws SQLServerException {
        return this.getObject(this.findColumn(string));
    }

    public short getShort(int n) throws SQLServerException {
        return this.getterGetColumn(n).getShort();
    }

    public short getShort(String string) throws SQLServerException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(1);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public String getString(String string) throws SQLServerException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLServerException {
        return this.getTime(n, null);
    }

    public Time getTime(String string) throws SQLServerException {
        return this.getTime(this.findColumn(string), null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLServerException {
        return (Time)this.getterGetColumn(n).getValue(92, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLServerException {
        return this.getTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLServerException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLServerException {
        return (Timestamp)this.getterGetColumn(n).getValue(93, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public InputStream getUnicodeStream(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(int n, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(int n) throws SQLServerException {
        return (Blob)this.getterGetColumn(n).getValue(2004);
    }

    public Clob getClob(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        SQLServerClob sQLServerClob = (SQLServerClob)column.getValue(2005);
        if (null != sQLServerClob) {
            sQLServerClob.setSQLCollation(column.getTypeInfo().getSQLCollation());
        }
        return sQLServerClob;
    }

    public Array getArray(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(String string) throws SQLServerException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLServerException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public String getCursorName() throws SQLServerException {
        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_positionedUpdatesNotSupported"), null, false);
        return null;
    }

    public Reader getCharacterStream(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        column.checkGetCharacterStream();
        return (Reader)column.getValue(-1, new Integer(2));
    }

    public Reader getCharacterStream(String string) throws SQLServerException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLServerException {
        return (BigDecimal)this.getterGetColumn(n).getValue(3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean rowUpdated() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        return false;
    }

    public boolean rowInserted() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        return false;
    }

    public boolean rowDeleted() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        if (this.isOnInsertRow || !this.cursor.isOnValidRow()) {
            return false;
        }
        return this.cursor.rowDeleted();
    }

    private final Column updaterGetColumn(int n) throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        this.verifyOnValidRow();
        this.verifyValidColumnIndex(n);
        this.verifyRowUpdatable();
        this.trackAccess();
        return this.getColumn(n);
    }

    public void updateNull(int n) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        int n2 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        column.updateValue(n2, null);
    }

    public void updateBoolean(int n, boolean bl) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(-7, new Boolean(bl));
    }

    public void updateByte(int n, byte by) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(5, new Byte(by));
    }

    public void updateShort(int n, short s) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(5, new Short(s));
    }

    public void updateInt(int n, int n2) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(4, new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(-5, new Long(l));
    }

    public void updateFloat(int n, float f) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(7, new Float(f));
    }

    public void updateDouble(int n, double d) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(8, new Double(d));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(3, bigDecimal);
    }

    public void updateString(int n, String string) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(1, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(-2, byArray);
    }

    public void updateDate(int n, Date date) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.updateValue(91, date);
    }

    public void updateTime(int n, Time time) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.updateValue(92, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.updateValue(93, timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.checkUpdateAsciiStream();
        column.updateValue(-1, inputStream, new InputStreamArgs(3, n2, column.getTypeInfo().getNativeType()));
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.checkUpdateBinaryStream();
        column.updateValue(-4, inputStream, new InputStreamArgs(1, n2, column.getTypeInfo().getNativeType()));
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.checkUpdateCharacterStream();
        column.updateValue(-1, reader, new Integer(n2));
    }

    public void updateObject(int n, Object object) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        int n2 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        column.updateValue(n2, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        int n3 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        column.updateValue(n3, object, new Integer(n2));
    }

    public void updateNull(String string) throws SQLServerException {
        this.checkClosed();
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLServerException {
        this.checkClosed();
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLServerException {
        this.checkClosed();
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLServerException {
        this.checkClosed();
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLServerException {
        this.checkClosed();
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLServerException {
        this.checkClosed();
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLServerException {
        this.checkClosed();
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        this.checkClosed();
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLServerException {
        this.checkClosed();
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLServerException {
        this.checkClosed();
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLServerException {
        this.checkClosed();
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLServerException {
        this.checkClosed();
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        this.checkClosed();
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLServerException {
        this.checkClosed();
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLServerException {
        this.checkClosed();
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLServerException {
        this.checkClosed();
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        if (!this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustBeOnInsertRow"), null, true);
        }
        this.trackAccess();
        this.cursor.insertRow();
    }

    public void updateRow() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        this.verifyOnValidRow();
        this.verifyNotOnInsertRow();
        this.verifyRowUpdatable();
        if (!this.stmt.hasUpdatedColumns()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
        }
        this.trackAccess();
        this.cursor.updateRow();
        this.cancelUpdates();
    }

    public void deleteRow() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        this.verifyOnValidRow();
        this.verifyNotOnInsertRow();
        this.verifyRowUpdatable();
        this.trackAccess();
        this.cursor.deleteRow();
        this.cancelUpdates();
    }

    public void refreshRow() throws SQLServerException {
        this.checkClosed();
        this.verifyScrollable();
        this.verifyUpdatable();
        this.verifyOnValidRow();
        this.verifyNotOnDeletedRow();
        this.verifyNotOnInsertRow();
        this.trackAccess();
        this.cursor.refreshRow();
        this.cancelUpdates();
    }

    private final void cancelUpdates() {
        if (!this.isOnInsertRow) {
            this.stmt.clearColumnsValues();
        }
    }

    public void cancelRowUpdates() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        this.verifyNotOnInsertRow();
        this.cancelUpdates();
    }

    public void moveToInsertRow() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        this.cancelUpdates();
        this.isOnInsertRow = true;
    }

    public void moveToCurrentRow() throws SQLServerException {
        this.checkClosed();
        this.verifyUpdatable();
        this.cancelInsert();
    }

    public Statement getStatement() throws SQLServerException {
        this.checkClosed();
        return this.stmt;
    }

    public void updateClob(int n, Clob clob) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(2005, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLServerException {
        this.checkClosed();
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateBlob(int n, Blob blob) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(2004, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLServerException {
        this.checkClosed();
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateArray(int n, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateArray(String string, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateRef(int n, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateRef(String string, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public URL getURL(int n) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    public URL getURL(String string) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    private void trackAccess() {
        ++this.accessCounter;
    }

    int getAccessCounter() {
        return this.accessCounter;
    }
}

