/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.connector.InteractionHandler;
import com.mockrunner.mock.connector.cci.ConnectorMockObjectFactory;
import com.mockrunner.mock.connector.cci.MockInteraction;
import com.mockrunner.mock.connector.cci.MockLocalTransaction;
import com.mockrunner.mock.connector.cci.MockRecordFactory;
import java.util.List;
import javax.resource.cci.RecordFactory;

public class ConnectorTestModule {
    private ConnectorMockObjectFactory mockFactory;

    public ConnectorTestModule(ConnectorMockObjectFactory mockFactory) {
        this.mockFactory = mockFactory;
    }

    public InteractionHandler getInteractionHandler() {
        return this.mockFactory.getInteractionHandler();
    }

    private MockRecordFactory getMockRecordFactory() {
        try {
            RecordFactory factory = this.mockFactory.getMockConnectionFactory().getRecordFactory();
            if (factory instanceof MockRecordFactory) {
                return (MockRecordFactory)factory;
            }
            return null;
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public List getInteractionList() {
        return this.mockFactory.getMockConnection().getInteractionList();
    }

    public List getCreatedIndexedRecords() {
        return this.getMockRecordFactory().getCreatedIndexedRecords();
    }

    public List getCreatedIndexedRecords(String recordName) {
        return this.getMockRecordFactory().getCreatedIndexedRecords(recordName);
    }

    public List getCreatedMappedRecords() {
        return this.getMockRecordFactory().getCreatedMappedRecords();
    }

    public List getCreatedMappedRecords(String recordName) {
        return this.getMockRecordFactory().getCreatedMappedRecords(recordName);
    }

    public void verifyConnectionClosed() {
        if (!this.mockFactory.getMockConnection().isClosed()) {
            throw new VerifyFailedException("Connection is not closed.");
        }
    }

    public void verifyAllInteractionsClosed() {
        List interactions = this.getInteractionList();
        for (int ii = 0; ii < interactions.size(); ++ii) {
            MockInteraction interaction = (MockInteraction)interactions.get(ii);
            if (interaction.isClosed()) continue;
            throw new VerifyFailedException("Interaction with index " + ii + " is not closed.");
        }
    }

    public void verifyInteractionClosed(int index) {
        List interactions = this.getInteractionList();
        if (index >= interactions.size()) {
            throw new VerifyFailedException("Interaction with index " + index + " does not exist, only " + interactions.size() + " interactions.");
        }
        MockInteraction interaction = (MockInteraction)interactions.get(index);
        if (!interaction.isClosed()) {
            throw new VerifyFailedException("Interaction with index " + index + " is not closed.");
        }
    }

    public void verifyNumberCreatedIndexedRecords(int expected) {
        int actual = this.getMockRecordFactory().getNumberCreatedIndexedRecords();
        if (actual != expected) {
            throw new VerifyFailedException("Expected " + expected + " indexed records, actual " + actual + " indexed records");
        }
    }

    public void verifyNumberCreatedIndexedRecords(String recordName, int expected) {
        List list = this.getCreatedIndexedRecords(recordName);
        if (list.size() != expected) {
            throw new VerifyFailedException("Expected " + expected + " indexed records with the name " + recordName + ", actual " + list.size() + " indexed records");
        }
    }

    public void verifyNumberCreatedMappedRecords(int expected) {
        int actual = this.getMockRecordFactory().getNumberCreatedMappedRecords();
        if (actual != expected) {
            throw new VerifyFailedException("Expected " + expected + " mapped records, actual " + actual + " mapped records");
        }
    }

    public void verifyNumberCreatedMappedRecords(String recordName, int expected) {
        List list = this.getCreatedMappedRecords(recordName);
        if (list.size() != expected) {
            throw new VerifyFailedException("Expected " + expected + " mapped records with the name " + recordName + ", actual " + list.size() + " mapped records");
        }
    }

    public void verifyLocalTransactionCommitted() {
        MockLocalTransaction transaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (!transaction.wasCommitCalled()) {
            throw new VerifyFailedException("Local transaction not committed");
        }
    }

    public void verifyLocalTransactionNotCommitted() {
        MockLocalTransaction transaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (transaction.wasCommitCalled()) {
            throw new VerifyFailedException("Local transaction was committed");
        }
    }

    public void verifyLocalTransactionRolledBack() {
        MockLocalTransaction transaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (!transaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Local transaction not rolled back");
        }
    }

    public void verifyLocalTransactionNotRolledBack() {
        MockLocalTransaction transaction = this.mockFactory.getMockConnection().getMockLocalTransaction();
        if (transaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Local transaction was rolled back");
        }
    }
}

