/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.connector.InteractionImplementor;
import com.mockrunner.mock.connector.cci.MockIndexedRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

public class IndexedRecordInteraction
implements InteractionImplementor {
    private boolean enabled;
    private List expectedRequest;
    private List responseData;
    private Class responseClass;
    private Record responseRecord;

    public IndexedRecordInteraction() {
        this(null, null, MockIndexedRecord.class);
    }

    public IndexedRecordInteraction(List responseList) {
        this(null, responseList, MockIndexedRecord.class);
    }

    public IndexedRecordInteraction(List expectedRequest, List responseList) {
        this(expectedRequest, responseList, MockIndexedRecord.class);
    }

    public IndexedRecordInteraction(List responseList, Class responseClass) {
        this(null, responseList, responseClass);
    }

    public IndexedRecordInteraction(List expectedRequest, List responseList, Class responseClass) {
        this.setExpectedRequest(expectedRequest);
        this.setResponse(responseList, responseClass);
        this.enabled = true;
    }

    public IndexedRecordInteraction(List expectedRequest, Record responseRecord) {
        this.setExpectedRequest(expectedRequest);
        this.setResponse(responseRecord);
        this.enabled = true;
    }

    public IndexedRecordInteraction(Record responseRecord) {
        this(null, responseRecord);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void setExpectedRequest(List expectedRequest) {
        this.expectedRequest = null == expectedRequest ? null : new ArrayList(expectedRequest);
    }

    public void setResponse(List responseList) {
        this.setResponse(responseList, MockIndexedRecord.class);
    }

    public void setResponse(List responseList, Class responseClass) {
        if (!this.isResponseClassAcceptable(responseClass)) {
            throw new IllegalArgumentException("responseClass must implement " + IndexedRecord.class.getName());
        }
        this.responseData = null == responseList ? null : new ArrayList(responseList);
        this.responseClass = responseClass;
    }

    public void setResponse(Record responseRecord) {
        this.responseRecord = responseRecord;
    }

    public boolean canHandle(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isResponseAcceptable(actualResponse)) {
            return false;
        }
        return this.doesRequestMatch(actualRequest);
    }

    private boolean doesRequestMatch(Record request) {
        if (null == this.expectedRequest) {
            return true;
        }
        if (null == request) {
            return false;
        }
        if (request instanceof IndexedRecord) {
            try {
                IndexedRecord indexedRequest = (IndexedRecord)request;
                if (indexedRequest.size() != this.expectedRequest.size()) {
                    return false;
                }
                for (int ii = 0; ii < indexedRequest.size(); ++ii) {
                    Object expectedValue;
                    Object actualValue = indexedRequest.get(ii);
                    if (this.areObjectsEquals(actualValue, expectedValue = this.expectedRequest.get(ii))) continue;
                    return false;
                }
                return true;
            }
            catch (Exception exc) {
                throw new NestedApplicationException(exc);
            }
        }
        return false;
    }

    private boolean areObjectsEquals(Object object1, Object object2) {
        if (null == object1 && null == object2) {
            return true;
        }
        if (null == object1) {
            return false;
        }
        return object1.equals(object2);
    }

    private boolean isResponseAcceptable(Record response) {
        return null == response || response instanceof IndexedRecord;
    }

    private boolean isResponseClassAcceptable(Class responseClass) {
        return null == responseClass || IndexedRecord.class.isAssignableFrom(responseClass);
    }

    public Record execute(InteractionSpec interactionSpec, Record actualRequest) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, null)) {
            return null;
        }
        if (null != this.responseRecord) {
            return this.responseRecord;
        }
        MockIndexedRecord response = null;
        try {
            response = null == this.responseClass ? new MockIndexedRecord() : (IndexedRecord)this.responseClass.newInstance();
            if (null != this.responseData) {
                response.addAll(this.responseData);
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return response;
    }

    public boolean execute(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, actualResponse)) {
            return false;
        }
        try {
            if (null != this.responseData && null != actualResponse) {
                ((IndexedRecord)actualResponse).clear();
                ((IndexedRecord)actualResponse).addAll((Collection)this.responseData);
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return true;
    }
}

