/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.mock.connector.cci.MockIndexedRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;

public class MockIndexedRecordTest
extends TestCase {
    private MockIndexedRecord indexedRecord;

    protected void setUp() throws Exception {
        this.indexedRecord = new MockIndexedRecord();
    }

    protected void tearDown() throws Exception {
        this.indexedRecord = null;
    }

    public void testListOperations() {
        MockIndexedRecordTest.assertTrue((boolean)this.indexedRecord.isEmpty());
        MockIndexedRecordTest.assertEquals((int)0, (int)this.indexedRecord.size());
        this.indexedRecord.add("1");
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.isEmpty());
        MockIndexedRecordTest.assertEquals((int)1, (int)this.indexedRecord.size());
        this.indexedRecord.add("2");
        Iterator iterator = this.indexedRecord.iterator();
        MockIndexedRecordTest.assertEquals((Object)"1", iterator.next());
        MockIndexedRecordTest.assertEquals((Object)"2", iterator.next());
        MockIndexedRecordTest.assertFalse((boolean)iterator.hasNext());
        MockIndexedRecordTest.assertEquals((int)1, (int)this.indexedRecord.indexOf("2"));
        this.indexedRecord.set(0, "5");
        Object[] array = (String[])this.indexedRecord.toArray(new String[this.indexedRecord.size()]);
        MockIndexedRecordTest.assertTrue((boolean)Arrays.equals(array, new String[]{"5", "2"}));
        try {
            this.indexedRecord.add(5, "5");
            MockIndexedRecordTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.indexedRecord.remove(1);
        MockIndexedRecordTest.assertEquals((int)1, (int)this.indexedRecord.size());
        MockIndexedRecordTest.assertEquals((Object)"5", (Object)this.indexedRecord.get(0));
        this.indexedRecord.remove("7");
        MockIndexedRecordTest.assertEquals((int)1, (int)this.indexedRecord.size());
        this.indexedRecord.clear();
        MockIndexedRecordTest.assertTrue((boolean)this.indexedRecord.isEmpty());
        MockIndexedRecordTest.assertEquals((int)0, (int)this.indexedRecord.size());
    }

    public void testEquals() {
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.equals(null));
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.equals("abc"));
        MockIndexedRecordTest.assertTrue((boolean)this.indexedRecord.equals(this.indexedRecord));
        this.indexedRecord.setRecordName("1");
        this.indexedRecord.setRecordShortDescription("2");
        this.indexedRecord.add("3");
        MockIndexedRecord other = new MockIndexedRecord();
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.equals(other));
        other.add("3");
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.equals(other));
        other.setRecordName("1");
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.equals(other));
        other.setRecordShortDescription("2");
        MockIndexedRecordTest.assertTrue((boolean)this.indexedRecord.equals(other));
        MockIndexedRecordTest.assertTrue((boolean)other.equals(this.indexedRecord));
        MockIndexedRecordTest.assertEquals((int)other.hashCode(), (int)this.indexedRecord.hashCode());
        other.add(null);
        MockIndexedRecordTest.assertFalse((boolean)this.indexedRecord.equals(other));
        MockIndexedRecordTest.assertFalse((boolean)other.equals(this.indexedRecord));
        this.indexedRecord.add(null);
        MockIndexedRecordTest.assertTrue((boolean)this.indexedRecord.equals(other));
        MockIndexedRecordTest.assertTrue((boolean)other.equals(this.indexedRecord));
        MockIndexedRecordTest.assertEquals((int)other.hashCode(), (int)this.indexedRecord.hashCode());
    }

    public void testToString() {
        this.indexedRecord.setRecordName("recordName");
        this.indexedRecord.setRecordShortDescription("shortDescription");
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        this.indexedRecord.addAll(list);
        String string = this.indexedRecord.toString();
        MockIndexedRecordTest.assertTrue((-1 != string.indexOf(MockIndexedRecord.class.getName()) ? 1 : 0) != 0);
        MockIndexedRecordTest.assertTrue((-1 != string.indexOf("recordName") ? 1 : 0) != 0);
        MockIndexedRecordTest.assertTrue((-1 != string.indexOf("shortDescription") ? 1 : 0) != 0);
        MockIndexedRecordTest.assertTrue((-1 != string.indexOf(((Object)list).toString()) ? 1 : 0) != 0);
    }

    public void testClone() {
        this.indexedRecord.setRecordName("1");
        this.indexedRecord.setRecordShortDescription("2");
        this.indexedRecord.add("This");
        this.indexedRecord.add("is");
        this.indexedRecord.add("a");
        this.indexedRecord.add("record");
        MockIndexedRecord clone = (MockIndexedRecord)this.indexedRecord.clone();
        MockIndexedRecordTest.assertNotSame((Object)clone, (Object)this.indexedRecord);
        MockIndexedRecordTest.assertEquals((String)"1", (String)clone.getRecordName());
        MockIndexedRecordTest.assertEquals((String)"2", (String)clone.getRecordShortDescription());
        MockIndexedRecordTest.assertEquals((Object)"This", (Object)clone.get(0));
        MockIndexedRecordTest.assertEquals((Object)"is", (Object)clone.get(1));
        MockIndexedRecordTest.assertEquals((Object)"a", (Object)clone.get(2));
        MockIndexedRecordTest.assertEquals((Object)"record", (Object)clone.get(3));
    }
}

