/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.connector.IndexedRecordInteraction;
import com.mockrunner.connector.MappedRecordInteraction;
import com.mockrunner.connector.StreamableRecordByteArrayInteraction;
import com.mockrunner.mock.connector.cci.ConnectorMockObjectFactory;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import com.mockrunner.mock.connector.cci.MockStreamableByteArrayRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.resource.cci.Interaction;
import javax.resource.cci.Record;
import junit.framework.TestCase;

public class MockInteractionTest
extends TestCase {
    private ConnectorMockObjectFactory mockFactory;

    protected void setUp() throws Exception {
        this.mockFactory = new ConnectorMockObjectFactory();
    }

    protected void tearDown() throws Exception {
        this.mockFactory = null;
    }

    public void testExecuteReturnsBoolean() throws Exception {
        StreamableRecordByteArrayInteraction byteArrayInteraction1 = new StreamableRecordByteArrayInteraction();
        byteArrayInteraction1.setExpectedRequest(new byte[]{1, 2, 3});
        byteArrayInteraction1.setResponse(new byte[]{1});
        StreamableRecordByteArrayInteraction byteArrayInteraction2 = new StreamableRecordByteArrayInteraction();
        byteArrayInteraction2.setResponse(new byte[]{2});
        this.mockFactory.getInteractionHandler().addImplementor(byteArrayInteraction1);
        this.mockFactory.getInteractionHandler().addImplementor(byteArrayInteraction2);
        Interaction interaction = this.mockFactory.getMockConnectionFactory().getConnection().createInteraction();
        MockInteractionTest.assertTrue((boolean)interaction.execute(null, null, null));
        MockStreamableByteArrayRecord actualRequest = new MockStreamableByteArrayRecord();
        MockStreamableByteArrayRecord actualResponse = new MockStreamableByteArrayRecord();
        actualRequest.setContent(new byte[]{1, 2, 3});
        MockInteractionTest.assertTrue((boolean)interaction.execute(null, (Record)actualRequest, (Record)actualResponse));
        MockInteractionTest.assertTrue((boolean)Arrays.equals(new byte[]{1}, actualResponse.getContent()));
        actualRequest.setContent(new byte[]{1, 2, 4});
        MockInteractionTest.assertTrue((boolean)interaction.execute(null, (Record)actualRequest, (Record)actualResponse));
        MockInteractionTest.assertTrue((boolean)Arrays.equals(new byte[]{2}, actualResponse.getContent()));
    }

    public void testExecuteReturnsRecord() throws Exception {
        IndexedRecordInteraction indexedInteraction = new IndexedRecordInteraction();
        TestRecord testRecord = new TestRecord();
        indexedInteraction.setResponse(testRecord);
        this.mockFactory.getInteractionHandler().addImplementor(indexedInteraction);
        Interaction interaction = this.mockFactory.getMockConnectionFactory().getConnection().createInteraction();
        MockInteractionTest.assertSame((Object)testRecord, (Object)interaction.execute(null, null));
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add("1");
        indexedInteraction.setExpectedRequest(expectedList);
        MockInteractionTest.assertNull((Object)interaction.execute(null, null));
        MappedRecordInteraction mappedInteraction = new MappedRecordInteraction();
        TestRecord anotherTestRecord = new TestRecord();
        mappedInteraction.setResponse(anotherTestRecord);
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("1", "1");
        mappedInteraction.setExpectedRequest(expectedMap);
        MockMappedRecord actualRequest = new MockMappedRecord();
        actualRequest.put("1", "1");
        this.mockFactory.getInteractionHandler().addImplementor(mappedInteraction);
        MockInteractionTest.assertSame((Object)anotherTestRecord, (Object)interaction.execute(null, (Record)actualRequest));
    }

    private class TestRecord
    implements Record {
        private TestRecord() {
        }

        public String getRecordName() {
            return null;
        }

        public String getRecordShortDescription() {
            return null;
        }

        public void setRecordName(String name) {
        }

        public void setRecordShortDescription(String description) {
        }

        public Object clone() throws CloneNotSupportedException {
            return null;
        }
    }
}

