/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.mock.connector.cci.MockMappedRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class MockMappedRecordTest
extends TestCase {
    private MockMappedRecord mappedRecord;

    protected void setUp() throws Exception {
        this.mappedRecord = new MockMappedRecord();
    }

    protected void tearDown() throws Exception {
        this.mappedRecord = null;
    }

    public void testMapOperations() {
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.isEmpty());
        MockMappedRecordTest.assertEquals((int)0, (int)this.mappedRecord.size());
        this.mappedRecord.put("1", "1");
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.isEmpty());
        MockMappedRecordTest.assertEquals((int)1, (int)this.mappedRecord.size());
        this.mappedRecord.put("2", "2");
        Set keySet = this.mappedRecord.keySet();
        MockMappedRecordTest.assertEquals((int)2, (int)keySet.size());
        MockMappedRecordTest.assertTrue((boolean)keySet.contains("1"));
        MockMappedRecordTest.assertTrue((boolean)keySet.contains("2"));
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.containsKey("1"));
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.containsValue("1"));
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.containsKey("2"));
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.containsValue("2"));
        this.mappedRecord.remove("2");
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.containsKey("1"));
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.containsValue("1"));
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.containsKey("2"));
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.containsValue("2"));
        Iterator values = this.mappedRecord.values().iterator();
        MockMappedRecordTest.assertEquals((Object)"1", values.next());
        MockMappedRecordTest.assertFalse((boolean)values.hasNext());
        this.mappedRecord.putAll((Map)((Object)this.mappedRecord));
        MockMappedRecordTest.assertEquals((int)1, (int)this.mappedRecord.size());
        this.mappedRecord.clear();
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.isEmpty());
        MockMappedRecordTest.assertEquals((int)0, (int)this.mappedRecord.size());
    }

    public void testEquals() {
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.equals(null));
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.equals("abc"));
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.equals(this.mappedRecord));
        this.mappedRecord.setRecordName("1");
        this.mappedRecord.setRecordShortDescription("2");
        this.mappedRecord.put("1", "3");
        MockMappedRecord other = new MockMappedRecord();
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.equals(other));
        other.put("1", "3");
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.equals(other));
        other.setRecordName("1");
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.equals(other));
        other.setRecordShortDescription("2");
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.equals(other));
        MockMappedRecordTest.assertTrue((boolean)other.equals(this.mappedRecord));
        MockMappedRecordTest.assertEquals((int)other.hashCode(), (int)this.mappedRecord.hashCode());
        other.put(null, null);
        MockMappedRecordTest.assertFalse((boolean)this.mappedRecord.equals(other));
        MockMappedRecordTest.assertFalse((boolean)other.equals(this.mappedRecord));
        this.mappedRecord.put(null, null);
        MockMappedRecordTest.assertTrue((boolean)this.mappedRecord.equals(other));
        MockMappedRecordTest.assertTrue((boolean)other.equals(this.mappedRecord));
        MockMappedRecordTest.assertEquals((int)other.hashCode(), (int)this.mappedRecord.hashCode());
    }

    public void testToString() {
        this.mappedRecord.setRecordName("recordName");
        this.mappedRecord.setRecordShortDescription("shortDescription");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        this.mappedRecord.putAll(map);
        String string = this.mappedRecord.toString();
        MockMappedRecordTest.assertTrue((-1 != string.indexOf(MockMappedRecord.class.getName()) ? 1 : 0) != 0);
        MockMappedRecordTest.assertTrue((-1 != string.indexOf("recordName") ? 1 : 0) != 0);
        MockMappedRecordTest.assertTrue((-1 != string.indexOf("shortDescription") ? 1 : 0) != 0);
        MockMappedRecordTest.assertTrue((-1 != string.indexOf(((Object)map).toString()) ? 1 : 0) != 0);
    }

    public void testClone() {
        this.mappedRecord.setRecordName("1");
        this.mappedRecord.setRecordShortDescription("2");
        this.mappedRecord.put("1", "This");
        this.mappedRecord.put("2", "is");
        this.mappedRecord.put("3", "a");
        this.mappedRecord.put("4", "record");
        MockMappedRecord clone = (MockMappedRecord)this.mappedRecord.clone();
        MockMappedRecordTest.assertNotSame((Object)clone, (Object)this.mappedRecord);
        MockMappedRecordTest.assertEquals((String)"1", (String)clone.getRecordName());
        MockMappedRecordTest.assertEquals((String)"2", (String)clone.getRecordShortDescription());
        MockMappedRecordTest.assertEquals((Object)"This", (Object)clone.get("1"));
        MockMappedRecordTest.assertEquals((Object)"is", (Object)clone.get("2"));
        MockMappedRecordTest.assertEquals((Object)"a", (Object)clone.get("3"));
        MockMappedRecordTest.assertEquals((Object)"record", (Object)clone.get("4"));
    }
}

