/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.mock.connector.cci.MockIndexedRecord;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import com.mockrunner.mock.connector.cci.MockRecordFactory;
import java.util.List;
import junit.framework.TestCase;

public class MockRecordFactoryTest
extends TestCase {
    private MockRecordFactory recordFactory;

    protected void setUp() throws Exception {
        this.recordFactory = new MockRecordFactory();
    }

    protected void tearDown() throws Exception {
        this.recordFactory = null;
    }

    public void testCreateIndexedRecord() throws Exception {
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getNumberCreatedIndexedRecords());
        MockIndexedRecord record1 = (MockIndexedRecord)this.recordFactory.createIndexedRecord("recordName1");
        MockRecordFactoryTest.assertEquals((String)"recordName1", (String)record1.getRecordName());
        MockRecordFactoryTest.assertEquals((String)"recordName1", (String)record1.getRecordShortDescription());
        MockIndexedRecord record2 = (MockIndexedRecord)this.recordFactory.createIndexedRecord("recordName2");
        MockRecordFactoryTest.assertEquals((String)"recordName2", (String)record2.getRecordName());
        MockRecordFactoryTest.assertEquals((String)"recordName2", (String)record2.getRecordShortDescription());
        MockRecordFactoryTest.assertEquals((int)2, (int)this.recordFactory.getNumberCreatedIndexedRecords());
        List recordList = this.recordFactory.getCreatedIndexedRecords();
        MockRecordFactoryTest.assertEquals((int)2, (int)recordList.size());
        MockRecordFactoryTest.assertSame((Object)record1, recordList.get(0));
        MockRecordFactoryTest.assertSame((Object)record2, recordList.get(1));
        this.recordFactory.resetIndexedRecords();
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getNumberCreatedIndexedRecords());
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedIndexedRecords().size());
    }

    public void testCreateMappedRecord() throws Exception {
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getNumberCreatedMappedRecords());
        MockMappedRecord record1 = (MockMappedRecord)this.recordFactory.createMappedRecord("recordName1");
        MockRecordFactoryTest.assertEquals((String)"recordName1", (String)record1.getRecordName());
        MockRecordFactoryTest.assertEquals((String)"recordName1", (String)record1.getRecordShortDescription());
        MockMappedRecord record2 = (MockMappedRecord)this.recordFactory.createMappedRecord("recordName2");
        MockRecordFactoryTest.assertEquals((String)"recordName2", (String)record2.getRecordName());
        MockRecordFactoryTest.assertEquals((String)"recordName2", (String)record2.getRecordShortDescription());
        MockRecordFactoryTest.assertEquals((int)2, (int)this.recordFactory.getNumberCreatedMappedRecords());
        List recordList = this.recordFactory.getCreatedMappedRecords();
        MockRecordFactoryTest.assertEquals((int)2, (int)recordList.size());
        MockRecordFactoryTest.assertSame((Object)record1, recordList.get(0));
        MockRecordFactoryTest.assertSame((Object)record2, recordList.get(1));
        this.recordFactory.resetMappedRecords();
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getNumberCreatedMappedRecords());
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedMappedRecords().size());
    }

    public void testGetCreatedIndexedRecords() throws Exception {
        MockIndexedRecord record1 = (MockIndexedRecord)this.recordFactory.createIndexedRecord("recordName");
        MockIndexedRecord record2 = (MockIndexedRecord)this.recordFactory.createIndexedRecord(null);
        MockIndexedRecord record3 = (MockIndexedRecord)this.recordFactory.createIndexedRecord("recordName");
        MockIndexedRecord record4 = (MockIndexedRecord)this.recordFactory.createIndexedRecord("anotherRecordName");
        MockIndexedRecord record5 = (MockIndexedRecord)this.recordFactory.createIndexedRecord("anotherRecordName");
        MockRecordFactoryTest.assertEquals((int)5, (int)this.recordFactory.getCreatedIndexedRecords().size());
        record1.setRecordName("anotherRecordName");
        record4.setRecordName("recordName");
        List list = this.recordFactory.getCreatedIndexedRecords("recordName");
        MockRecordFactoryTest.assertEquals((int)2, (int)list.size());
        MockRecordFactoryTest.assertSame((Object)record1, list.get(0));
        MockRecordFactoryTest.assertSame((Object)record3, list.get(1));
        list = this.recordFactory.getCreatedIndexedRecords("anotherRecordName");
        MockRecordFactoryTest.assertEquals((int)2, (int)list.size());
        MockRecordFactoryTest.assertSame((Object)record4, list.get(0));
        MockRecordFactoryTest.assertSame((Object)record5, list.get(1));
        list = this.recordFactory.getCreatedIndexedRecords(null);
        MockRecordFactoryTest.assertEquals((int)1, (int)list.size());
        MockRecordFactoryTest.assertSame((Object)record2, list.get(0));
        this.recordFactory.resetIndexedRecords();
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedIndexedRecords().size());
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedIndexedRecords("recordName").size());
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedIndexedRecords("anotherRecordName").size());
    }

    public void testGetCreatedMappedRecords() throws Exception {
        MockMappedRecord record1 = (MockMappedRecord)this.recordFactory.createMappedRecord("recordName");
        MockMappedRecord record2 = (MockMappedRecord)this.recordFactory.createMappedRecord(null);
        MockMappedRecord record3 = (MockMappedRecord)this.recordFactory.createMappedRecord("recordName");
        MockMappedRecord record4 = (MockMappedRecord)this.recordFactory.createMappedRecord("anotherRecordName");
        MockMappedRecord record5 = (MockMappedRecord)this.recordFactory.createMappedRecord("anotherRecordName");
        MockRecordFactoryTest.assertEquals((int)5, (int)this.recordFactory.getCreatedMappedRecords().size());
        record1.setRecordName("anotherRecordName");
        record4.setRecordName("recordName");
        List list = this.recordFactory.getCreatedMappedRecords("recordName");
        MockRecordFactoryTest.assertEquals((int)2, (int)list.size());
        MockRecordFactoryTest.assertSame((Object)record1, list.get(0));
        MockRecordFactoryTest.assertSame((Object)record3, list.get(1));
        list = this.recordFactory.getCreatedMappedRecords("anotherRecordName");
        MockRecordFactoryTest.assertEquals((int)2, (int)list.size());
        MockRecordFactoryTest.assertSame((Object)record4, list.get(0));
        MockRecordFactoryTest.assertSame((Object)record5, list.get(1));
        list = this.recordFactory.getCreatedMappedRecords(null);
        MockRecordFactoryTest.assertEquals((int)1, (int)list.size());
        MockRecordFactoryTest.assertSame((Object)record2, list.get(0));
        this.recordFactory.resetMappedRecords();
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedMappedRecords().size());
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedMappedRecords("recordName").size());
        MockRecordFactoryTest.assertEquals((int)0, (int)this.recordFactory.getCreatedMappedRecords("anotherRecordName").size());
    }
}

