/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.mock.connector.cci.MockStreamableByteArrayRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import junit.framework.TestCase;

public class MockStreamableByteArrayRecordTest
extends TestCase {
    private MockStreamableByteArrayRecord record;

    protected void setUp() throws Exception {
        this.record = new MockStreamableByteArrayRecord();
    }

    protected void tearDown() throws Exception {
        this.record = null;
    }

    public void testSetAndGetContent() {
        MockStreamableByteArrayRecordTest.assertNull((Object)this.record.getContent());
        this.record.setContent(null);
        MockStreamableByteArrayRecordTest.assertNull((Object)this.record.getContent());
        this.record.setContent(new byte[0]);
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[0], this.record.getContent()));
        byte[] content = new byte[]{1, 2, 3};
        this.record.setContent(content);
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, this.record.getContent()));
        content[0] = 3;
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, this.record.getContent()));
        content = this.record.getContent();
        content[0] = 3;
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, this.record.getContent()));
        this.record.setContent(null);
        MockStreamableByteArrayRecordTest.assertNull((Object)this.record.getContent());
    }

    public void testRead() throws Exception {
        this.record.read(null);
        MockStreamableByteArrayRecordTest.assertNull((Object)this.record.getContent());
        this.record.read(new ByteArrayInputStream(new byte[0]));
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[0], this.record.getContent()));
        this.record.read(new ByteArrayInputStream(new byte[]{1, 2, 3}));
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, this.record.getContent()));
        this.record.read(null);
        MockStreamableByteArrayRecordTest.assertNull((Object)this.record.getContent());
    }

    public void testWrite() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.record.write(output);
        MockStreamableByteArrayRecordTest.assertEquals((int)0, (int)output.size());
        this.record.setContent(new byte[0]);
        this.record.write(output);
        MockStreamableByteArrayRecordTest.assertEquals((int)0, (int)output.size());
        this.record.setContent(new byte[]{1, 2, 3});
        this.record.write(output);
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, output.toByteArray()));
    }

    public void testEquals() throws Exception {
        MockStreamableByteArrayRecordTest.assertFalse((boolean)this.record.equals(null));
        MockStreamableByteArrayRecordTest.assertFalse((boolean)this.record.equals("abc"));
        MockStreamableByteArrayRecordTest.assertTrue((boolean)this.record.equals(this.record));
        this.record.setRecordName("1");
        this.record.setRecordShortDescription("2");
        MockStreamableByteArrayRecord other = new MockStreamableByteArrayRecord();
        MockStreamableByteArrayRecordTest.assertFalse((boolean)this.record.equals(other));
        other.setRecordName("1");
        MockStreamableByteArrayRecordTest.assertFalse((boolean)this.record.equals(other));
        other.setRecordShortDescription("2");
        MockStreamableByteArrayRecordTest.assertTrue((boolean)this.record.equals(other));
        this.record.setContent(new byte[]{1, 2, 3});
        MockStreamableByteArrayRecordTest.assertFalse((boolean)this.record.equals(other));
        other.read(new ByteArrayInputStream(new byte[]{1, 2, 3}));
        MockStreamableByteArrayRecordTest.assertTrue((boolean)this.record.equals(other));
        MockStreamableByteArrayRecordTest.assertTrue((boolean)other.equals(this.record));
        MockStreamableByteArrayRecordTest.assertEquals((int)other.hashCode(), (int)this.record.hashCode());
        other.setContent(null);
        MockStreamableByteArrayRecordTest.assertFalse((boolean)this.record.equals(other));
        MockStreamableByteArrayRecordTest.assertFalse((boolean)other.equals(this.record));
        this.record.setContent(null);
        MockStreamableByteArrayRecordTest.assertTrue((boolean)this.record.equals(other));
        MockStreamableByteArrayRecordTest.assertTrue((boolean)other.equals(this.record));
        MockStreamableByteArrayRecordTest.assertEquals((int)other.hashCode(), (int)this.record.hashCode());
    }

    public void testClone() {
        this.record.setRecordName("1");
        this.record.setRecordShortDescription("2");
        MockStreamableByteArrayRecord clone = (MockStreamableByteArrayRecord)this.record.clone();
        MockStreamableByteArrayRecordTest.assertEquals((String)"1", (String)clone.getRecordName());
        MockStreamableByteArrayRecordTest.assertEquals((String)"2", (String)clone.getRecordShortDescription());
        MockStreamableByteArrayRecordTest.assertNull((Object)clone.getContent());
        this.record.setContent(new byte[0]);
        clone = (MockStreamableByteArrayRecord)this.record.clone();
        MockStreamableByteArrayRecordTest.assertEquals((String)"1", (String)clone.getRecordName());
        MockStreamableByteArrayRecordTest.assertEquals((String)"2", (String)clone.getRecordShortDescription());
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[0], clone.getContent()));
        this.record.setContent(new byte[]{1, 2, 3});
        clone = (MockStreamableByteArrayRecord)this.record.clone();
        MockStreamableByteArrayRecordTest.assertEquals((String)"1", (String)clone.getRecordName());
        MockStreamableByteArrayRecordTest.assertEquals((String)"2", (String)clone.getRecordShortDescription());
        MockStreamableByteArrayRecordTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, clone.getContent()));
    }
}

