/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.JasperJspFactory;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.WebMockObjectFactory;
import java.util.Arrays;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import junit.framework.TestCase;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;

public class JasperJspFactoryTest
extends TestCase {
    private WebMockObjectFactory mockFactory;
    private JasperJspFactory jasperFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockFactory = new WebMockObjectFactory();
        this.jasperFactory = new JasperJspFactory();
    }

    public void testConfigure() {
        JasperJspFactoryTest.assertSame((Object)((Object)this.jasperFactory), (Object)((Object)this.jasperFactory.configure(this.mockFactory)));
        JasperJspFactoryTest.assertTrue((boolean)(this.jasperFactory.getJspApplicationContext(null) instanceof JspApplicationContextImpl));
        JasperJspFactoryTest.assertSame((Object)this.jasperFactory.getJspApplicationContext(null), (Object)this.mockFactory.getMockServletContext().getAttribute(JspApplicationContextImpl.class.getName()));
        JasperJspFactoryTest.assertSame((Object)this.jasperFactory.getPageContext(null, null, null, null, true, 1, true), (Object)((Object)this.mockFactory.getMockPageContext()));
        JasperJspFactoryTest.assertTrue((boolean)(this.mockFactory.getMockPageContext().getELContext() instanceof ELContextImpl));
    }

    public void testResolveVariable() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        this.mockFactory.getMockSession().setAttribute("test", "value");
        ELResolver resolver = this.mockFactory.getMockPageContext().getELContext().getELResolver();
        JasperJspFactoryTest.assertEquals((Object)"value", (Object)resolver.getValue(this.mockFactory.getMockPageContext().getELContext(), null, (Object)"test"));
    }

    public void testValueExpressionGetAndSet() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        TestObject testObject = new TestObject();
        testObject.setTestProperty("value");
        this.mockFactory.getMockSession().setAttribute("test", testObject);
        JspApplicationContext applicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(this.mockFactory.getMockPageContext().getServletContext());
        ValueExpression valueExpression = applicationContext.getExpressionFactory().createValueExpression(this.mockFactory.getMockPageContext().getELContext(), "${test.testProperty}", String.class);
        JasperJspFactoryTest.assertEquals((Object)"value", (Object)valueExpression.getValue(this.mockFactory.getMockPageContext().getELContext()));
        valueExpression.setValue(this.mockFactory.getMockPageContext().getELContext(), (Object)"anotherValue");
        JasperJspFactoryTest.assertEquals((String)"anotherValue", (String)testObject.getTestProperty());
    }

    public void testValueExpressionAttributes() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        TestObject testObject = new TestObject();
        testObject.setTestProperty("value");
        this.mockFactory.getMockSession().setAttribute("test", testObject);
        JspApplicationContext applicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(this.mockFactory.getMockPageContext().getServletContext());
        ValueExpression valueExpression = applicationContext.getExpressionFactory().createValueExpression(this.mockFactory.getMockPageContext().getELContext(), "${test.testProperty}", String.class);
        JasperJspFactoryTest.assertEquals(String.class, (Object)valueExpression.getExpectedType());
        JasperJspFactoryTest.assertEquals(String.class, (Object)valueExpression.getType(this.mockFactory.getMockPageContext().getELContext()));
        JasperJspFactoryTest.assertFalse((boolean)valueExpression.isReadOnly(this.mockFactory.getMockPageContext().getELContext()));
        JasperJspFactoryTest.assertEquals((String)"${test.testProperty}", (String)valueExpression.getExpressionString());
        valueExpression = applicationContext.getExpressionFactory().createValueExpression(this.mockFactory.getMockPageContext().getELContext(), "${test.testReadOnlyProperty}", Integer.class);
        JasperJspFactoryTest.assertEquals(Integer.class, (Object)valueExpression.getExpectedType());
        JasperJspFactoryTest.assertEquals(Integer.class, (Object)valueExpression.getType(this.mockFactory.getMockPageContext().getELContext()));
        JasperJspFactoryTest.assertTrue((boolean)valueExpression.isReadOnly(this.mockFactory.getMockPageContext().getELContext()));
        JasperJspFactoryTest.assertEquals((String)"${test.testReadOnlyProperty}", (String)valueExpression.getExpressionString());
    }

    public void testArithmeticValueExpression() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        TestObject testObject = new TestObject();
        this.mockFactory.getMockRequest().setAttribute("test", testObject);
        this.assertExpressionEquals("${(test['testReadOnlyProperty'] + test.testArrayProperty[0]) == 26}", "true");
    }

    public void testDeferredValueExpression() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        TestObject testObject = new TestObject();
        testObject.setTestProperty("value");
        this.mockFactory.getMockRequest().setAttribute("test", testObject);
        this.assertExpressionEquals("#{test.testProperty}", "value");
        this.mockFactory.getMockSession().setAttribute("test", "xyz");
        this.assertExpressionEquals("#{sessionScope.test}", "xyz");
    }

    public void testDeferredMethodExpression() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        TestObject testObject = new TestObject();
        this.mockFactory.getMockServletContext().setAttribute("test", testObject);
        JspApplicationContext applicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(this.mockFactory.getMockPageContext().getServletContext());
        MethodExpression methodExpression = applicationContext.getExpressionFactory().createMethodExpression(this.mockFactory.getMockPageContext().getELContext(), "#{test.testMethod}", String.class, new Class[]{String.class});
        JasperJspFactoryTest.assertEquals((Object)"Hello World", (Object)methodExpression.invoke(this.mockFactory.getMockPageContext().getELContext(), (Object[])new String[]{"Hello World"}));
        MethodInfo methodInfo = methodExpression.getMethodInfo(this.mockFactory.getMockPageContext().getELContext());
        JasperJspFactoryTest.assertEquals((String)"testMethod", (String)methodInfo.getName());
        JasperJspFactoryTest.assertEquals(String.class, (Object)methodInfo.getReturnType());
        JasperJspFactoryTest.assertTrue((boolean)Arrays.equals(new Class[]{String.class}, methodInfo.getParamTypes()));
        JasperJspFactoryTest.assertEquals((String)"#{test.testMethod}", (String)methodExpression.getExpressionString());
    }

    public void testExpressionScopes() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        this.mockFactory.getMockRequest().setAttribute("requesttest", "requestvalue");
        this.mockFactory.getMockSession().setAttribute("sessiontest", "sessionvalue");
        this.mockFactory.getMockPageContext().setAttribute("pagetest", "pagevalue");
        this.mockFactory.getMockServletContext().setAttribute("applicationtest", "applicationvalue");
        this.assertExpressionEquals("${requestScope.requesttest}", "requestvalue");
        this.assertExpressionEquals("${sessionScope.sessiontest}", "sessionvalue");
        this.assertExpressionEquals("${pageScope.pagetest}", "pagevalue");
        this.assertExpressionEquals("${applicationScope.applicationtest}", "applicationvalue");
        this.assertExpressionEquals("${requestScope.sessiontest}", "");
        this.assertExpressionEquals("${pageScope.sessiontest}", "");
        this.assertExpressionEquals("${applicationScope.requesttest}", "");
        this.assertExpressionEquals("${sessionScope.requesttest}", "");
    }

    public void testImplicitObjects() {
        this.mockFactory.setDefaultJspFactory(this.jasperFactory.configure(this.mockFactory));
        MockHttpServletRequest request = this.mockFactory.getMockRequest();
        request.setRequestURI("myRequestURI");
        this.assertExpressionEquals("${pageContext.request.requestURI}", "myRequestURI");
        request.setupAddParameter("key1", "value1");
        request.setupAddParameter("arraykey", new String[]{"arrayvalue1", "arrayvalue2"});
        this.assertExpressionEquals("${paramValues.key1[0]}", "value1");
        this.assertExpressionEquals("${param['key1']}", "value1");
        this.assertExpressionEquals("${paramValues.arraykey[0]}", "arrayvalue1");
        this.assertExpressionEquals("${paramValues.arraykey[1]}", "arrayvalue2");
        this.assertExpressionEquals("${param.arraykey}", "arrayvalue1");
        request.addHeader("header", "value1");
        request.addHeader("header", "value2");
        this.assertExpressionEquals("${headerValues.header[0]}", "value1");
        this.assertExpressionEquals("${headerValues.header[1]}", "value2");
        this.assertExpressionEquals("${header.header}", "value1");
    }

    private void assertExpressionEquals(String expression, String value) {
        JspApplicationContext applicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(this.mockFactory.getMockPageContext().getServletContext());
        ValueExpression valueExpression = applicationContext.getExpressionFactory().createValueExpression(this.mockFactory.getMockPageContext().getELContext(), expression, String.class);
        JasperJspFactoryTest.assertEquals((Object)value, (Object)valueExpression.getValue(this.mockFactory.getMockPageContext().getELContext()));
    }

    public static class TestObject {
        private String testProperty;

        public String getTestProperty() {
            return this.testProperty;
        }

        public void setTestProperty(String testProperty) {
            this.testProperty = testProperty;
        }

        public String[] getTestArrayProperty() {
            return new String[]{"1"};
        }

        public Integer getTestReadOnlyProperty() {
            return new Integer(25);
        }

        public String testMethod(String test) {
            return test;
        }
    }
}

