/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockServletOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import junit.framework.TestCase;

public class MockHttpServletResponseTest
extends TestCase {
    private MockHttpServletResponse response;

    protected void setUp() throws Exception {
        super.setUp();
        this.response = new MockHttpServletResponse();
    }

    public void testResetAll() throws Exception {
        this.response.addHeader("header", "headervalue");
        this.response.sendError(400);
        this.response.setBufferSize(10);
        this.response.resetAll();
        MockHttpServletResponseTest.assertNull((Object)this.response.getHeader("header"));
        MockHttpServletResponseTest.assertEquals((int)8192, (int)this.response.getBufferSize());
        MockHttpServletResponseTest.assertFalse((boolean)this.response.wasErrorSent());
    }

    public void testHeaders() {
        this.response.addHeader("testHeader", "xyz");
        this.response.addHeader("testHeader", "abc");
        MockHttpServletResponseTest.assertTrue((this.response.getHeaderList("testHeader").size() == 2 ? 1 : 0) != 0);
        MockHttpServletResponseTest.assertTrue((boolean)this.response.getHeaderList("testHeader").contains("xyz"));
        MockHttpServletResponseTest.assertTrue((boolean)this.response.getHeaderList("testHeader").contains("abc"));
        this.response.setHeader("testHeader", "abc");
        MockHttpServletResponseTest.assertTrue((this.response.getHeaderList("testHeader").size() == 1 ? 1 : 0) != 0);
        MockHttpServletResponseTest.assertTrue((boolean)this.response.getHeaderList("testHeader").contains("abc"));
        MockHttpServletResponseTest.assertEquals((String)"abc", (String)this.response.getHeader("testHeader"));
        this.response.addDateHeader("dateHeader", 0L);
        String expectedDateString = "Thu, 1 Jan 1970 00:00:00 GMT";
        MockHttpServletResponseTest.assertEquals((String)expectedDateString, (String)this.response.getHeader("dateHeader"));
        this.response.setDateHeader("dateHeader", 0L);
        MockHttpServletResponseTest.assertEquals((String)expectedDateString, (String)this.response.getHeader("dateHeader"));
        this.response.addIntHeader("intHeader", 0);
        MockHttpServletResponseTest.assertEquals((String)"0", (String)this.response.getHeader("intHeader"));
        this.response.clearHeaders();
        Collection headers = this.response.getHeaderNames();
        MockHttpServletResponseTest.assertTrue((boolean)headers.isEmpty());
    }

    public void testGetHeaderNames() {
        this.response.addHeader("testHeader1", "xyz1");
        this.response.addHeader("testHeader1", "abc");
        this.response.addHeader("testHeader2", "xyz2");
        this.response.addHeader("testHeader3", "xyz3");
        Collection headerNames = this.response.getHeaderNames();
        MockHttpServletResponseTest.assertEquals((int)3, (int)headerNames.size());
        MockHttpServletResponseTest.assertTrue((boolean)headerNames.contains("testHeader1"));
        MockHttpServletResponseTest.assertTrue((boolean)headerNames.contains("testHeader2"));
        MockHttpServletResponseTest.assertTrue((boolean)headerNames.contains("testHeader3"));
    }

    public void testGetHeaders() {
        this.response.addHeader("testHeader1", "xyz1");
        this.response.addHeader("testHeader1", "abc");
        this.response.addHeader("testHeader2", "xyz2");
        Collection headers = this.response.getHeaders("testHeader1");
        MockHttpServletResponseTest.assertEquals((int)2, (int)headers.size());
        MockHttpServletResponseTest.assertTrue((boolean)headers.contains("xyz1"));
        MockHttpServletResponseTest.assertTrue((boolean)headers.contains("abc"));
    }

    public void testHeadersCaseInsensitive() {
        this.response.addHeader("testHeader", "xyz");
        this.response.addHeader("TESTHeader", "abc");
        this.response.addHeader("MYHEADER1", "xyz");
        this.response.addHeader("myHeader2", "abc");
        MockHttpServletResponseTest.assertEquals((String)"xyz", (String)this.response.getHeader("myheader1"));
        MockHttpServletResponseTest.assertEquals((String)"abc", (String)this.response.getHeader("MYHEADER2"));
        Collection headerNames = this.response.getHeaderNames();
        MockHttpServletResponseTest.assertEquals((int)3, (int)headerNames.size());
        MockHttpServletResponseTest.assertTrue((boolean)headerNames.contains("testHeader"));
        MockHttpServletResponseTest.assertTrue((boolean)headerNames.contains("MYHEADER1"));
        MockHttpServletResponseTest.assertTrue((boolean)headerNames.contains("myHeader2"));
    }

    public void testOutputStreams() throws IOException {
        this.response.getOutputStream().print("test");
        this.response.getWriter().print(true);
        this.response.getWriter().print("test");
        this.response.flushBuffer();
        MockHttpServletResponseTest.assertEquals((String)"testtruetest", (String)this.response.getOutputStreamContent());
    }

    public void testGetSetContentType() throws IOException {
        MockHttpServletResponseTest.assertNull((Object)this.response.getContentType());
        this.response.setContentType("myType");
        MockHttpServletResponseTest.assertEquals((String)"myType", (String)this.response.getContentType());
    }

    public void testFlush() throws IOException {
        this.response.getOutputStream().write(97);
        this.response.flushBuffer();
        MockHttpServletResponseTest.assertEquals((String)"a", (String)((MockServletOutputStream)this.response.getOutputStream()).getContent());
    }

    public void testReset() throws IOException {
        this.response.addHeader("testHeader", "xyz");
        MockHttpServletResponseTest.assertTrue((this.response.getHeaderList("testHeader").size() == 1 ? 1 : 0) != 0);
        this.response.getOutputStream().write(97);
        this.response.getWriter().write("xyz");
        this.response.resetBuffer();
        MockHttpServletResponseTest.assertEquals((String)"", (String)((MockServletOutputStream)this.response.getOutputStream()).getContent());
        MockHttpServletResponseTest.assertTrue((this.response.getHeaderList("testHeader").size() == 1 ? 1 : 0) != 0);
        this.response.reset();
        MockHttpServletResponseTest.assertNull((Object)this.response.getHeaderList("testHeader"));
    }

    public void testSetCharacterEncoding() throws IOException {
        this.response.setCharacterEncoding("ISO-8859-1");
        this.response.getWriter().write("?");
        this.response.getWriter().flush();
        this.response.getOutputStream().println("?");
        this.response.setCharacterEncoding("US-ASCII");
        MockHttpServletResponseTest.assertFalse((boolean)this.response.getOutputStreamContent().startsWith("\u00ba\u00ba"));
        this.response.setCharacterEncoding("ISO-8859-1");
        MockHttpServletResponseTest.assertTrue((boolean)this.response.getOutputStreamContent().startsWith("??"));
        this.response.resetAll();
        this.response.setCharacterEncoding("UTF-8");
        String input = "\u00f8";
        PrintWriter writer = this.response.getWriter();
        writer.write(input);
        this.response.flushBuffer();
        String output = this.response.getOutputStreamContent();
        MockHttpServletResponseTest.assertTrue((boolean)output.equals(input));
    }
}

