/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockJspPropertyGroupDescriptor;
import java.util.Iterator;
import junit.framework.TestCase;

public class MockJspPropertyGroupDescriptorTest
extends TestCase {
    private MockJspPropertyGroupDescriptor descriptor;

    protected void setUp() throws Exception {
        this.descriptor = new MockJspPropertyGroupDescriptor();
    }

    protected void tearDown() throws Exception {
        this.descriptor = null;
    }

    public void testReset() {
        this.descriptor.addIncludeCoda("coda");
        this.descriptor.addIncludePrelude("prelude");
        this.descriptor.addUrlPattern("urlPattern");
        this.descriptor.setIsXml("xyz");
        this.descriptor.setBuffer("25");
        this.descriptor.setDefaultContentType("xyz");
        this.descriptor.setDeferredSyntaxAllowedAsLiteral("true");
        this.descriptor.setElIgnored("123");
        this.descriptor.setErrorOnUndeclaredNamespace("true");
        this.descriptor.setPageEncoding("Encoding");
        this.descriptor.setScriptingInvalid("456");
        this.descriptor.setTrimDirectiveWhitespaces("true");
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludeCodas().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludePreludes().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getUrlPatterns().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"xyz", (String)this.descriptor.getIsXml());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"25", (String)this.descriptor.getBuffer());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"xyz", (String)this.descriptor.getDefaultContentType());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"true", (String)this.descriptor.getDeferredSyntaxAllowedAsLiteral());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"123", (String)this.descriptor.getElIgnored());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"true", (String)this.descriptor.getErrorOnUndeclaredNamespace());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"Encoding", (String)this.descriptor.getPageEncoding());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"456", (String)this.descriptor.getScriptingInvalid());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"true", (String)this.descriptor.getTrimDirectiveWhitespaces());
        this.descriptor.reset();
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getIncludeCodas().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getIncludePreludes().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getUrlPatterns().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"false", (String)this.descriptor.getIsXml());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"8kb", (String)this.descriptor.getBuffer());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"text/html", (String)this.descriptor.getDefaultContentType());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"false", (String)this.descriptor.getDeferredSyntaxAllowedAsLiteral());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"false", (String)this.descriptor.getElIgnored());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"false", (String)this.descriptor.getErrorOnUndeclaredNamespace());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"ISO-8859-1", (String)this.descriptor.getPageEncoding());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"false", (String)this.descriptor.getScriptingInvalid());
        MockJspPropertyGroupDescriptorTest.assertEquals((String)"false", (String)this.descriptor.getTrimDirectiveWhitespaces());
    }

    public void testIncludeAndURLPatterns() {
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getIncludeCodas().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getIncludePreludes().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getUrlPatterns().isEmpty());
        this.descriptor.addIncludeCoda("coda1");
        this.descriptor.addIncludeCoda("coda2");
        this.descriptor.addIncludePrelude("prelude1");
        this.descriptor.addUrlPattern("urlPattern1");
        this.descriptor.addUrlPattern("urlPattern2");
        this.descriptor.addUrlPattern("urlPattern3");
        MockJspPropertyGroupDescriptorTest.assertEquals((int)2, (int)this.descriptor.getIncludeCodas().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludePreludes().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)3, (int)this.descriptor.getUrlPatterns().size());
        this.descriptor.clearIncludeCodas();
        this.descriptor.clearIncludePreludes();
        this.descriptor.clearUrlPatterns();
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getIncludeCodas().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getIncludePreludes().isEmpty());
        MockJspPropertyGroupDescriptorTest.assertTrue((boolean)this.descriptor.getUrlPatterns().isEmpty());
    }

    public void testIncludeAndURLPatternsListChange() {
        this.descriptor.addIncludeCoda("coda1");
        this.descriptor.addIncludePrelude("prelude1");
        this.descriptor.addUrlPattern("urlPattern1");
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludeCodas().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludePreludes().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getUrlPatterns().size());
        this.descriptor.getIncludeCodas().add("coda2");
        this.descriptor.getIncludePreludes().add("prelude2");
        this.descriptor.getUrlPatterns().add("urlPattern2");
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludeCodas().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getIncludePreludes().size());
        MockJspPropertyGroupDescriptorTest.assertEquals((int)1, (int)this.descriptor.getUrlPatterns().size());
        Iterator codas = this.descriptor.getIncludeCodas().iterator();
        Iterator preludes = this.descriptor.getIncludePreludes().iterator();
        Iterator urlPatterns = this.descriptor.getUrlPatterns().iterator();
        MockJspPropertyGroupDescriptorTest.assertEquals((Object)"coda1", codas.next());
        MockJspPropertyGroupDescriptorTest.assertEquals((Object)"prelude1", preludes.next());
        MockJspPropertyGroupDescriptorTest.assertEquals((Object)"urlPattern1", urlPatterns.next());
    }
}

