/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.PolyResultSet;
import java.sql.SQLException;
import java.util.List;
import junit.framework.TestCase;

public class MockDatabaseMetaDataTest
extends TestCase {
    private MockDatabaseMetaData metaData;

    protected void setUp() throws Exception {
        super.setUp();
        this.metaData = new MockDatabaseMetaData();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.metaData = null;
    }

    public void testSchemas() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas());
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("abc1", "abc2"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setSchemas(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas(null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("", "test"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("abc1", "test"));
        this.metaData.clearSchemas();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas());
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setSchemas("", "test1", testResult);
        this.metaData.setSchemas("abc", "test", testResult2);
        this.metaData.setSchemas(null, "test", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getSchemas("abc", "test"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSchemas(null, "test");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        polyResult = (PolyResultSet)this.metaData.getSchemas();
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("", "test1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getSchemas("", "test"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getSchemas("abc", "test"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas(null, "test2"));
        this.metaData.setSchemas(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSchemas(null, "test3"));
        polyResult = (PolyResultSet)this.metaData.getSchemas(null, "test");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testSchemasWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setSchemas("abc", "test", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("abc", "test"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas(null, "t__t"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("abc", "tes%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("abc", "%es%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas(null, "_est"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("ab_", "test"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("a%", "te_t"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("abc", "t____"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("abc", "test1%"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setSchemas("abc1", "abc", testResult2);
        this.metaData.setSchemas("abc2", "abc", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSchemas(null, "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSchemas("abc1", "%") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getSchemas(null, "a__");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSchemas(null, "t___") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("%", "%"));
        polyResult = (PolyResultSet)this.metaData.getSchemas(null, "ab%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testSchemasCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setSchemas("abc", "TEST", testResult);
        this.metaData.setSchemas("abc", "test", testResult2);
        this.metaData.setSchemas(null, "test", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSchemas(null, "t_st");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getSchemas(null, "t_st");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSchemas("abc", "TE%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSchemas("ABC", "TEST"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getSchemas("ABC", "TEST");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testExportedKeys() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setExportedKeys(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getExportedKeys(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getExportedKeys("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getExportedKeys("abc1", "test", "xyz"));
        this.metaData.clearExportedKeys();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setExportedKeys("", "test%", "xyz", testResult);
        this.metaData.setExportedKeys("abc", "test", "xyz", testResult2);
        this.metaData.setExportedKeys(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getExportedKeys("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getExportedKeys(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getExportedKeys("", "test%", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getExportedKeys("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getExportedKeys("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys(null, "test_", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys(null, "test", null));
        this.metaData.setExportedKeys(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getExportedKeys(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getExportedKeys(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getExportedKeys(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getExportedKeys(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testExportedKeysCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setExportedKeys("abc", "TEST", "XYz", testResult);
        this.metaData.setExportedKeys("abc", "test", "xyz", testResult2);
        this.metaData.setExportedKeys(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getExportedKeys(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getExportedKeys(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getExportedKeys("abc", "TEST", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getExportedKeys("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getExportedKeys("ABC", "TEST", "XYz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testImportedKeys() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setImportedKeys(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getImportedKeys(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getImportedKeys("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getImportedKeys("abc1", "test", "xyz"));
        this.metaData.clearImportedKeys();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setImportedKeys("", "test%", "xyz", testResult);
        this.metaData.setImportedKeys("abc", "test", "xyz", testResult2);
        this.metaData.setImportedKeys(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getImportedKeys("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getImportedKeys(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getImportedKeys("", "test%", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getImportedKeys("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getImportedKeys("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys(null, "test_", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys(null, "test", null));
        this.metaData.setImportedKeys(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getImportedKeys(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getImportedKeys(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getImportedKeys(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getImportedKeys(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testImportedKeysCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setImportedKeys("abc", "TEST", "XYz", testResult);
        this.metaData.setImportedKeys("abc", "test", "xyz", testResult2);
        this.metaData.setImportedKeys(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getImportedKeys(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getImportedKeys(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getImportedKeys("abc", "TEST", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getImportedKeys("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getImportedKeys("ABC", "TEST", "XYz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testPrimaryKeys() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setPrimaryKeys(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getPrimaryKeys(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getPrimaryKeys("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getPrimaryKeys("abc1", "test", "xyz"));
        this.metaData.clearPrimaryKeys();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setPrimaryKeys("", "test%", "xyz", testResult);
        this.metaData.setPrimaryKeys("abc", "test", "xyz", testResult2);
        this.metaData.setPrimaryKeys(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getPrimaryKeys("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getPrimaryKeys(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getPrimaryKeys("", "test%", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getPrimaryKeys("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getPrimaryKeys("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys(null, "test_", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys(null, "test", null));
        this.metaData.setPrimaryKeys(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getPrimaryKeys(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getPrimaryKeys(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getPrimaryKeys(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getPrimaryKeys(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testPrimaryKeysCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setPrimaryKeys("abc", "TEST", "XYz", testResult);
        this.metaData.setPrimaryKeys("abc", "test", "xyz", testResult2);
        this.metaData.setPrimaryKeys(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getPrimaryKeys(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getPrimaryKeys(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getPrimaryKeys("abc", "TEST", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getPrimaryKeys("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getPrimaryKeys("ABC", "TEST", "XYz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testProcedures() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setProcedures(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc1", "test", "xyz"));
        this.metaData.clearProcedures();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setProcedures("", "test1", "xyz", testResult);
        this.metaData.setProcedures("abc", "test", "xyz", testResult2);
        this.metaData.setProcedures(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getProcedures("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getProcedures(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("", "test1", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getProcedures("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getProcedures("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures(null, "test", null));
        this.metaData.setProcedures(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getProcedures(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getProcedures(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getProcedures(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getProcedures(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testProceduresWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setProcedures("abc", "test", "xyz", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures(null, "t__t", "%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc", "tes%", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc", "%es%", "x_z"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures(null, "_est", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures(null, "test", "_yz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc", "t%", "xy_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc", "test%", "%xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("ab_", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("a%", "te_t", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("abc", "test", "a%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("abc", "t____", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures(null, "test", "%xyz_"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("abc", "test1%", "x_z"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setProcedures("abc1", "abc", "xyz", testResult2);
        this.metaData.setProcedures("abc1", "abc", "xyz1", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getProcedures(null, "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getProcedures("abc", "%", "xyz") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getProcedures("abc1", "%", "xyz") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getProcedures(null, "a__", "xyz%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getProcedures(null, "a__", "xyz_") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getProcedures(null, "ab%", "%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testProceduresCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setProcedures("abc", "TEST", "XYz", testResult);
        this.metaData.setProcedures("abc", "test", "xyz", testResult2);
        this.metaData.setProcedures(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getProcedures(null, "t_st", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getProcedures(null, "t_st", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedures("abc", "TE%", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedures("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getProcedures("ABC", "TEST", "_Yz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testFunctions() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setFunctions(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc1", "test", "xyz"));
        this.metaData.clearFunctions();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setFunctions("", "test1", "xyz", testResult);
        this.metaData.setFunctions("abc", "test", "xyz", testResult2);
        this.metaData.setFunctions(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getFunctions("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getFunctions(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("", "test1", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getFunctions("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getFunctions("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions(null, "test", null));
        this.metaData.setFunctions(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getFunctions(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getFunctions(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getFunctions(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getFunctions(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testFunctionsWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setFunctions("abc", "test", "xyz", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions(null, "t__t", "%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc", "tes%", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc", "%es%", "x_z"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions(null, "_est", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions(null, "test", "_yz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc", "t%", "xy_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc", "test%", "%xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("ab_", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("a%", "te_t", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("abc", "test", "a%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("abc", "t____", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions(null, "test", "%xyz_"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("abc", "test1%", "x_z"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setFunctions("abc1", "abc", "xyz", testResult2);
        this.metaData.setFunctions("abc1", "abc", "xyz1", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getFunctions(null, "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getFunctions("abc", "%", "xyz") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getFunctions("abc1", "%", "xyz") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getFunctions(null, "a__", "xyz%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getFunctions(null, "a__", "xyz_") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getFunctions(null, "ab%", "%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testFunctionsCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setFunctions("abc", "TEST", "XYz", testResult);
        this.metaData.setFunctions("abc", "test", "xyz", testResult2);
        this.metaData.setFunctions(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getFunctions(null, "t_st", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getFunctions(null, "t_st", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctions("abc", "TE%", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctions("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getFunctions("ABC", "TEST", "_Yz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testSuperTables() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setSuperTables(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc1", "test", "xyz"));
        this.metaData.clearSuperTables();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setSuperTables("", "test1", "xyz", testResult);
        this.metaData.setSuperTables("abc", "test", "xyz", testResult2);
        this.metaData.setSuperTables(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getSuperTables("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("", "test1", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getSuperTables("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getSuperTables("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables(null, "test", null));
        this.metaData.setSuperTables(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSuperTables(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSuperTables(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSuperTables(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testSuperTablesWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setSuperTables("abc", "test", "xyz", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables(null, "t__t", "%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc", "tes%", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc", "%es%", "x_z"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables(null, "_est", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables(null, "test", "_yz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc", "t%", "xy_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc", "test%", "%xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("ab_", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("a%", "te_t", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("abc", "test", "a%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("abc", "t____", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables(null, "test", "%xyz_"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("abc", "test1%", "x_z"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setSuperTables("abc1", "abc", "xyz", testResult2);
        this.metaData.setSuperTables("abc1", "abc", "xyz1", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSuperTables("abc", "%", "xyz") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSuperTables("abc1", "%", "xyz") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "a__", "xyz%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSuperTables(null, "a__", "xyz_") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "ab%", "%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testSuperTablesCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setSuperTables("abc", "TEST", "XYz", testResult);
        this.metaData.setSuperTables("abc", "test", "xyz", testResult2);
        this.metaData.setSuperTables(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "t_st", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getSuperTables(null, "t_st", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTables("abc", "TE%", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTables("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getSuperTables("ABC", "TEST", "_Yz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testSuperTypes() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setSuperTypes(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc1", "test", "xyz"));
        this.metaData.clearSuperTypes();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setSuperTypes("", "test1", "xyz", testResult);
        this.metaData.setSuperTypes("abc", "test", "xyz", testResult2);
        this.metaData.setSuperTypes(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getSuperTypes("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("", "test1", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getSuperTypes("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getSuperTypes("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes(null, "test", null));
        this.metaData.setSuperTypes(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSuperTypes(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSuperTypes(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getSuperTypes(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testSuperTypesWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setSuperTypes("abc", "test", "xyz", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes(null, "t__t", "%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc", "tes%", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc", "%es%", "x_z"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes(null, "_est", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes(null, "test", "_yz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc", "t%", "xy_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc", "test%", "%xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("ab_", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("a%", "te_t", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("abc", "test", "a%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("abc", "t____", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes(null, "test", "%xyz_"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("abc", "test1%", "x_z"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setSuperTypes("abc1", "abc", "xyz", testResult2);
        this.metaData.setSuperTypes("abc1", "abc", "xyz1", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSuperTypes("abc", "%", "xyz") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSuperTypes("abc1", "%", "xyz") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "a__", "xyz%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getSuperTypes(null, "a__", "xyz_") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "ab%", "%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testSuperTypesCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setSuperTypes("abc", "TEST", "XYz", testResult);
        this.metaData.setSuperTypes("abc", "test", "xyz", testResult2);
        this.metaData.setSuperTypes(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "t_st", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getSuperTypes(null, "t_st", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getSuperTypes("abc", "TE%", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getSuperTypes("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getSuperTypes("ABC", "TEST", "_Yz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testTablePrivileges() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setTablePrivileges(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc1", "test", "xyz"));
        this.metaData.clearTablePrivileges();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setTablePrivileges("", "test1", "xyz", testResult);
        this.metaData.setTablePrivileges("abc", "test", "xyz", testResult2);
        this.metaData.setTablePrivileges(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getTablePrivileges("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("", "test1", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getTablePrivileges("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getTablePrivileges("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges(null, "test", null));
        this.metaData.setTablePrivileges(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getTablePrivileges(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getTablePrivileges(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getTablePrivileges(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testTablePrivilegesWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setTablePrivileges("abc", "test", "xyz", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges(null, "t__t", "%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc", "tes%", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc", "%es%", "x_z"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges(null, "_est", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges(null, "test", "_yz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc", "t%", "xy_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc", "test%", "%xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("ab_", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("a%", "te_t", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("abc", "test", "a%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("abc", "t____", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges(null, "test", "%xyz_"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("abc", "test1%", "x_z"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setTablePrivileges("abc1", "abc", "xyz", testResult2);
        this.metaData.setTablePrivileges("abc1", "abc", "xyz1", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getTablePrivileges("abc", "%", "xyz") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getTablePrivileges("abc1", "%", "xyz") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "a__", "xyz%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getTablePrivileges(null, "a__", "xyz_") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "ab%", "%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testTablePrivilegesCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setTablePrivileges("abc", "TEST", "XYz", testResult);
        this.metaData.setTablePrivileges("abc", "test", "xyz", testResult2);
        this.metaData.setTablePrivileges(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "t_st", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getTablePrivileges(null, "t_st", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTablePrivileges("abc", "TE%", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTablePrivileges("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getTablePrivileges("ABC", "TEST", "_Yz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testVersionColumns() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns(null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns("abc1", "abc2", "abc3"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setVersionColumns(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getVersionColumns(null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getVersionColumns("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getVersionColumns("abc1", "test", "xyz"));
        this.metaData.clearVersionColumns();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns("", "test", "xyz"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setVersionColumns("", "test%", "xyz", testResult);
        this.metaData.setVersionColumns("abc", "test", "xyz", testResult2);
        this.metaData.setVersionColumns(null, "test", "xyz", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getVersionColumns("abc", "test", "xyz"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getVersionColumns(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getVersionColumns("", "test%", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getVersionColumns("", "test", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getVersionColumns("abc", "test", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns(null, "test_", "xyz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns(null, "test", null));
        this.metaData.setVersionColumns(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getVersionColumns(null, "test3", "xyz"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getVersionColumns(null, "test", "xyz1"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getVersionColumns(null, "test", null));
        polyResult = (PolyResultSet)this.metaData.getVersionColumns(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testVersionColumnsCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setVersionColumns("abc", "TEST", "XYz", testResult);
        this.metaData.setVersionColumns("abc", "test", "xyz", testResult2);
        this.metaData.setVersionColumns(null, "test", "xyz", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getVersionColumns(null, "test", "xyz");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getVersionColumns(null, "test", "xyz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getVersionColumns("abc", "TEST", "XYz"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getVersionColumns("ABC", "TEST", "XYz"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getVersionColumns("ABC", "TEST", "XYz");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testBestRowIdentifier() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier(null, null, null, 1, false));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier("abc1", "abc2", "abc3", 2, true));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setBestRowIdentifier(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getBestRowIdentifier(null, null, null, 1, false));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getBestRowIdentifier("", "test", "xyz", 2, true));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getBestRowIdentifier("abc1", "test", "xyz", 3, false));
        this.metaData.clearBestRowIdentifier();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier("", "test", "xyz", 1, false));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setBestRowIdentifier("", "test%", "xyz", 1, false, testResult);
        this.metaData.setBestRowIdentifier("abc", "test", "xyz", 2, true, testResult2);
        this.metaData.setBestRowIdentifier(null, "test", "xyz", 2, true, testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getBestRowIdentifier("abc", "test", "xyz", 2, true));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getBestRowIdentifier(null, "test", "xyz", 2, true);
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getBestRowIdentifier("", "test%", "xyz", 1, false));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getBestRowIdentifier("", "test", "xyz", 2, true));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getBestRowIdentifier("abc", "test", "xyz", 2, true));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier(null, "test_", "xyz", 1, false));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier(null, "test", "xyz1", 2, true));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier(null, "test", null, 2, true));
        this.metaData.setBestRowIdentifier(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getBestRowIdentifier(null, "test3", "xyz", 5, false));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getBestRowIdentifier(null, "test", "xyz1", 2, true));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getBestRowIdentifier(null, "test", null, 1, false));
        polyResult = (PolyResultSet)this.metaData.getBestRowIdentifier(null, "test", "xyz", 2, true);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testBestRowIdentifierCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setBestRowIdentifier("abc", "TEST", "XYz", 1, false, testResult);
        this.metaData.setBestRowIdentifier("abc", "test", "xyz", 1, false, testResult2);
        this.metaData.setBestRowIdentifier(null, "test", "xyz", 1, false, testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getBestRowIdentifier(null, "test", "xyz", 1, false);
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getBestRowIdentifier(null, "test", "xyz", 1, false);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getBestRowIdentifier("abc", "TEST", "XYz", 1, false));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getBestRowIdentifier("ABC", "TEST", "XYz", 1, false));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getBestRowIdentifier("ABC", "TEST", "XYz", 1, false);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testIndexInfo() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo(null, null, null, true, false));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo("abc1", "abc2", "abc3", false, true));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setIndexInfo(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getIndexInfo(null, null, null, true, false));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getIndexInfo("", "test", "xyz", false, true));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getIndexInfo("abc1", "test", "xyz", false, false));
        this.metaData.clearIndexInfo();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo("", "test", "xyz", true, false));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setIndexInfo("", "test%", "xyz", true, false, testResult);
        this.metaData.setIndexInfo("abc", "test", "xyz", false, true, testResult2);
        this.metaData.setIndexInfo(null, "test", "xyz", false, true, testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getIndexInfo("abc", "test", "xyz", false, true));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getIndexInfo(null, "test", "xyz", false, true);
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getIndexInfo("", "test%", "xyz", true, false));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getIndexInfo("", "test", "xyz", false, true));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getIndexInfo("abc", "test", "xyz", false, true));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo(null, "test_", "xyz", true, false));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo(null, "test", "xyz1", false, true));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo(null, "test", null, false, true));
        this.metaData.setIndexInfo(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getIndexInfo(null, "test3", "xyz", true, false));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getIndexInfo(null, "test", "xyz1", false, true));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getIndexInfo(null, "test", null, false, false));
        polyResult = (PolyResultSet)this.metaData.getIndexInfo(null, "test", "xyz", false, true);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testIndexInfoCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setIndexInfo("abc", "TEST", "XYz", true, false, testResult);
        this.metaData.setIndexInfo("abc", "test", "xyz", true, false, testResult2);
        this.metaData.setIndexInfo(null, "test", "xyz", true, false, testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getIndexInfo(null, "test", "xyz", true, false);
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getIndexInfo(null, "test", "xyz", true, false);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getIndexInfo("abc", "TEST", "XYz", true, false));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getIndexInfo("ABC", "TEST", "XYz", true, false));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getIndexInfo("ABC", "TEST", "XYz", true, false);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testUDTs() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("abc1", "abc2", "abc3", new int[]{1}));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setUDTs(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("", "test", "xyz", new int[]{1, 2, 3}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc1", "test", "xyz", new int[0]));
        this.metaData.clearUDTs();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setUDTs("", "test1", "xyz", null, testResult);
        this.metaData.setUDTs("abc", "test", "xyz", new int[]{1}, testResult2);
        this.metaData.setUDTs(null, "test", "xyz", new int[]{1, 2, 3}, testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getUDTs("abc", "test", "xyz", new int[]{1, 2, 3}));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getUDTs(null, "test", "xyz", new int[]{1, 2, 3});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("", "test1", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getUDTs("", "test", "xyz", new int[]{1, 2, 3}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getUDTs("abc", "test", "xyz", new int[]{1, 2, 3}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs(null, "test", "xyz1", new int[]{1, 2, 3}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs(null, "test", null, new int[]{1, 2, 3}));
        this.metaData.setUDTs(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getUDTs(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getUDTs(null, "test", "xyz1", new int[]{1, 2, 3}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getUDTs(null, "test", null, new int[0]));
        polyResult = (PolyResultSet)this.metaData.getUDTs(null, "test", "xyz", new int[]{1, 2, 3});
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.clearUDTs();
        this.metaData.setUDTs("1", "2", "3", null, testResult);
        this.metaData.setUDTs("1", "2", "3", new int[]{1, 2, 3}, testResult2);
        this.metaData.setUDTs("1", "2", "3", new int[]{4}, testResult3);
        this.metaData.setUDTs("1", "2", "3", new int[]{1}, testResult4);
        polyResult = (PolyResultSet)this.metaData.getUDTs("1", "2", "3", null);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)4, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getUDTs("1", "2", "3", new int[]{4}));
    }

    public void testUDTsWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setUDTs("abc", "test", "xyz", new int[]{1}, testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc", "test", "xyz", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs(null, "t__t", "%", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc", "tes%", "___", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc", "%es%", "x_z", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs(null, "_est", "xyz", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs(null, "test", "_yz", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc", "t%", "xy_", new int[]{1}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc", "test%", "%xyz", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("ab_", "test", "xyz", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("a%", "te_t", "xyz", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("abc", "test", "a%", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("abc", "t____", "xyz", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs(null, "test", "%xyz_", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("abc", "test1%", "x_z", new int[]{1}));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setUDTs("abc1", "abc", "xyz", new int[]{1}, testResult2);
        this.metaData.setUDTs("abc1", "abc", "xyz1", new int[]{1}, testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getUDTs(null, "%", "%", null);
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getUDTs("abc", "%", "xyz", new int[]{1}) instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getUDTs("abc1", "%", "xyz", null) instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getUDTs(null, "a__", "xyz%", new int[]{1});
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getUDTs(null, "a__", "xyz_", null) instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("%", "%", "%", null));
        polyResult = (PolyResultSet)this.metaData.getUDTs(null, "ab%", "%", new int[]{1});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testUDTsWithTypes() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setUDTs("abc", "test", "xyz", new int[]{1}, testResult);
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("abc", "test", "xyz", new int[]{2}));
        MockDatabaseMetaDataTest.assertEquals((Object)testResult, (Object)this.metaData.getUDTs("abc", "test", "xyz", null));
        MockDatabaseMetaDataTest.assertEquals((Object)testResult, (Object)this.metaData.getUDTs("abc", "test", "xyz", new int[]{1, 2}));
        MockResultSet testResult2 = new MockResultSet("id2");
        this.metaData.setUDTs("abc", "test", "xyz", new int[]{2, 4}, testResult2);
        MockDatabaseMetaDataTest.assertEquals((Object)testResult2, (Object)this.metaData.getUDTs("abc", "test", "xyz", new int[]{2}));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getUDTs("abc", "%", "%", new int[]{1, 2, 3});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
    }

    public void testUDTsCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setUDTs("abc", "TEST", "XYz", new int[]{1}, testResult);
        this.metaData.setUDTs("abc", "test", "xyz", new int[]{1}, testResult2);
        this.metaData.setUDTs(null, "test", "xyz", new int[]{1}, testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getUDTs(null, "t_st", "xyz", new int[]{1});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getUDTs(null, "t_st", "xyz", new int[]{1});
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getUDTs("abc", "TE%", "XYz", new int[]{1}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getUDTs("ABC", "TEST", "XYz", new int[]{1}));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getUDTs("ABC", "TEST", "_Yz", new int[]{1});
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testAttributes() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("abc1", "abc2", "abc3", "abc4"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setAttributes(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc1", "test", "xyz", "12345"));
        this.metaData.clearAttributes();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setAttributes("", "test1", "xyz", "123", testResult);
        this.metaData.setAttributes("abc", "test", "xyz", "456", testResult2);
        this.metaData.setAttributes(null, "test", "xyz", "456", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getAttributes("abc", "test", "xyz", "456"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getAttributes(null, "test", "xyz", "456");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("", "test1", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getAttributes("", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getAttributes("abc", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes(null, "test3", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes(null, "test", "xyz1", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes(null, "test", null, "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("abc", "test", "xyz", null));
        this.metaData.setAttributes(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getAttributes(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getAttributes(null, "test", "xyz1", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getAttributes(null, "test", null, null));
        polyResult = (PolyResultSet)this.metaData.getAttributes(null, "test", "xyz", "456");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testAttributesWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setAttributes("abc", "test", "xyz", "123", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes(null, "t__t", "%", "12_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc", "tes%", "___", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc", "%es%", "x_z", "%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes(null, "_est", "xyz", "1_3%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes(null, "test", "_yz", "%123%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc", "t%", "xy_", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc", "test%", "%xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("ab_", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("a%", "te_t", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("abc", "test", "a%", "1_3"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("abc", "t____", "xyz", "1%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes(null, "test", "%xyz_", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("abc", "test1%", "x_z", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("abc", "test%", "xyz", "1___%"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setAttributes("abc1", "abc", "xyz", "456", testResult2);
        this.metaData.setAttributes("abc1", "abc", "xyz1", "456", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getAttributes(null, "%", "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getAttributes("abc", "%", "xyz", "1__") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getAttributes("abc1", "%", "xyz", "456") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getAttributes(null, "a__", "xyz%", "_56%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getAttributes(null, "a__", "xyz_", "4_6") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("%", "%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getAttributes(null, "ab%", "%", "4%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testAttributesCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setAttributes("abc", "TEST", "XYz", "efg", testResult);
        this.metaData.setAttributes("abc", "test", "xyz", "EFg", testResult2);
        this.metaData.setAttributes(null, "test", "xyz", "EFg", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getAttributes(null, "t_st", "xyz", "EFG");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getAttributes(null, "t_st", "xyz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getAttributes("abc", "TE%", "XYz", "efg"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getAttributes("ABC", "TEST", "XYz", "efg"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getAttributes("ABC", "TEST", "_Yz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testColumnPrivileges() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc1", "abc2", "abc3", "abc4"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setColumnPrivileges(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("abc1", "test", "xyz", "12345"));
        this.metaData.clearColumnPrivileges();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setColumnPrivileges("", "test1", "xyz", "123", testResult);
        this.metaData.setColumnPrivileges("abc", "test", "xyz", "456", testResult2);
        this.metaData.setColumnPrivileges(null, "test", "xyz", "456", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getColumnPrivileges("abc", "test", "xyz", "456"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getColumnPrivileges(null, "test", "xyz", "456");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("", "test1", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getColumnPrivileges("", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getColumnPrivileges("abc", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges(null, "test3", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges(null, "test", "xyz1", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges(null, "test", null, "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc", "test", "xyz", null));
        this.metaData.setColumnPrivileges(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getColumnPrivileges(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getColumnPrivileges(null, "test", "xyz1", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getColumnPrivileges(null, "test", null, null));
        polyResult = (PolyResultSet)this.metaData.getColumnPrivileges(null, "test", "xyz", "456");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testColumnPrivilegesWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setColumnPrivileges("abc", "test", "xyz", "123", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("abc", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges(null, "test", "xyz", "12_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("abc", "test", "xyz", "%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("abc", "test", "xyz", "%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges(null, "test", "xyz", "1_3%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc", "te_t", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc", "test", "a%", "1_3"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc", "t____", "xyz", "1%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges(null, "test", "%xyz_", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc", "test1%", "x_z", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("abc", "test%", "xyz", "1___%"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setColumnPrivileges("abc1", "abc", "xyz", "456", testResult2);
        this.metaData.setColumnPrivileges("abc1", "abc", "xyz1", "456", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getColumnPrivileges(null, "abc", "xyz", "%"));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getColumnPrivileges("abc", "test", "xyz", "1__") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getColumnPrivileges("abc1", "abc", "xyz", "456") instanceof MockResultSet));
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setColumnPrivileges("abc1", "abc", "xyz1", "789", testResult4);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getColumnPrivileges("abc1", "abc", "xyz1", "___");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testColumnPrivilegesCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setColumnPrivileges("abc", "TEST", "XYz", "efg", testResult);
        this.metaData.setColumnPrivileges("abc", "test", "xyz", "EFg", testResult2);
        this.metaData.setColumnPrivileges(null, "test", "xyz", "EFg", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getColumnPrivileges(null, "test", "xyz", "EFG");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getColumnPrivileges(null, "test", "xyz", "E_g");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumnPrivileges("abc", "TEST", "XYz", "efg"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumnPrivileges("ABC", "TEST", "XYz", "efg"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getColumnPrivileges("ABC", "TEST", "XYz", "EF%");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testColumns() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("abc1", "abc2", "abc3", "abc4"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setColumns(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc1", "test", "xyz", "12345"));
        this.metaData.clearColumns();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setColumns("", "test1", "xyz", "123", testResult);
        this.metaData.setColumns("abc", "test", "xyz", "456", testResult2);
        this.metaData.setColumns(null, "test", "xyz", "456", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getColumns("abc", "test", "xyz", "456"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getColumns(null, "test", "xyz", "456");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("", "test1", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getColumns("", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getColumns("abc", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns(null, "test3", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns(null, "test", "xyz1", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns(null, "test", null, "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("abc", "test", "xyz", null));
        this.metaData.setColumns(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getColumns(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getColumns(null, "test", "xyz1", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getColumns(null, "test", null, null));
        polyResult = (PolyResultSet)this.metaData.getColumns(null, "test", "xyz", "456");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testColumnsWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setColumns("abc", "test", "xyz", "123", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns(null, "t__t", "%", "12_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc", "tes%", "___", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc", "%es%", "x_z", "%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns(null, "_est", "xyz", "1_3%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns(null, "test", "_yz", "%123%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc", "t%", "xy_", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc", "test%", "%xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("ab_", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("a%", "te_t", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("abc", "test", "a%", "1_3"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("abc", "t____", "xyz", "1%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns(null, "test", "%xyz_", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("abc", "test1%", "x_z", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("abc", "test%", "xyz", "1___%"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setColumns("abc1", "abc", "xyz", "456", testResult2);
        this.metaData.setColumns("abc1", "abc", "xyz1", "456", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getColumns(null, "%", "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getColumns("abc", "%", "xyz", "1__") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getColumns("abc1", "%", "xyz", "456") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getColumns(null, "a__", "xyz%", "_56%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getColumns(null, "a__", "xyz_", "4_6") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("%", "%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getColumns(null, "ab%", "%", "4%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testColumnsCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setColumns("abc", "TEST", "XYz", "efg", testResult);
        this.metaData.setColumns("abc", "test", "xyz", "EFg", testResult2);
        this.metaData.setColumns(null, "test", "xyz", "EFg", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getColumns(null, "t_st", "xyz", "EFG");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getColumns(null, "t_st", "xyz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getColumns("abc", "TE%", "XYz", "efg"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getColumns("ABC", "TEST", "XYz", "efg"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getColumns("ABC", "TEST", "_Yz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testProcedureColumns() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("abc1", "abc2", "abc3", "abc4"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setProcedureColumns(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc1", "test", "xyz", "12345"));
        this.metaData.clearProcedureColumns();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setProcedureColumns("", "test1", "xyz", "123", testResult);
        this.metaData.setProcedureColumns("abc", "test", "xyz", "456", testResult2);
        this.metaData.setProcedureColumns(null, "test", "xyz", "456", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getProcedureColumns("abc", "test", "xyz", "456"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "test", "xyz", "456");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("", "test1", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getProcedureColumns("", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getProcedureColumns("abc", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns(null, "test3", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns(null, "test", "xyz1", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns(null, "test", null, "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("abc", "test", "xyz", null));
        this.metaData.setProcedureColumns(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getProcedureColumns(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getProcedureColumns(null, "test", "xyz1", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getProcedureColumns(null, "test", null, null));
        polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "test", "xyz", "456");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testProcedureColumnsWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setProcedureColumns("abc", "test", "xyz", "123", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns(null, "t__t", "%", "12_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc", "tes%", "___", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc", "%es%", "x_z", "%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns(null, "_est", "xyz", "1_3%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns(null, "test", "_yz", "%123%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc", "t%", "xy_", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc", "test%", "%xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("ab_", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("a%", "te_t", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("abc", "test", "a%", "1_3"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("abc", "t____", "xyz", "1%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns(null, "test", "%xyz_", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("abc", "test1%", "x_z", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("abc", "test%", "xyz", "1___%"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setProcedureColumns("abc1", "abc", "xyz", "456", testResult2);
        this.metaData.setProcedureColumns("abc1", "abc", "xyz1", "456", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "%", "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getProcedureColumns("abc", "%", "xyz", "1__") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getProcedureColumns("abc1", "%", "xyz", "456") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "a__", "xyz%", "_56%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getProcedureColumns(null, "a__", "xyz_", "4_6") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("%", "%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "ab%", "%", "4%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testProcedureColumnsCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setProcedureColumns("abc", "TEST", "XYz", "efg", testResult);
        this.metaData.setProcedureColumns("abc", "test", "xyz", "EFg", testResult2);
        this.metaData.setProcedureColumns(null, "test", "xyz", "EFg", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "t_st", "xyz", "EFG");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getProcedureColumns(null, "t_st", "xyz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getProcedureColumns("abc", "TE%", "XYz", "efg"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getProcedureColumns("ABC", "TEST", "XYz", "efg"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getProcedureColumns("ABC", "TEST", "_Yz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testFunctionColumns() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("abc1", "abc2", "abc3", "abc4"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setFunctionColumns(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc1", "test", "xyz", "12345"));
        this.metaData.clearFunctionColumns();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setFunctionColumns("", "test1", "xyz", "123", testResult);
        this.metaData.setFunctionColumns("abc", "test", "xyz", "456", testResult2);
        this.metaData.setFunctionColumns(null, "test", "xyz", "456", testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getFunctionColumns("abc", "test", "xyz", "456"));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "test", "xyz", "456");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("", "test1", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getFunctionColumns("", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getFunctionColumns("abc", "test", "xyz", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns(null, "test3", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns(null, "test", "xyz1", "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns(null, "test", null, "456"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("abc", "test", "xyz", null));
        this.metaData.setFunctionColumns(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getFunctionColumns(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getFunctionColumns(null, "test", "xyz1", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getFunctionColumns(null, "test", null, null));
        polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "test", "xyz", "456");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
    }

    public void testFunctionColumnsWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setFunctionColumns("abc", "test", "xyz", "123", testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns(null, "t__t", "%", "12_"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc", "tes%", "___", "123"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc", "%es%", "x_z", "%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns(null, "_est", "xyz", "1_3%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns(null, "test", "_yz", "%123%%"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc", "t%", "xy_", "___"));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc", "test%", "%xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("ab_", "test", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("a%", "te_t", "xyz", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("abc", "test", "a%", "1_3"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("abc", "t____", "xyz", "1%"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns(null, "test", "%xyz_", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("abc", "test1%", "x_z", "123"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("abc", "test%", "xyz", "1___%"));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setFunctionColumns("abc1", "abc", "xyz", "456", testResult2);
        this.metaData.setFunctionColumns("abc1", "abc", "xyz1", "456", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "%", "%", "%");
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getFunctionColumns("abc", "%", "xyz", "1__") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getFunctionColumns("abc1", "%", "xyz", "456") instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "a__", "xyz%", "_56%");
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getFunctionColumns(null, "a__", "xyz_", "4_6") instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("%", "%", "%", "%"));
        polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "ab%", "%", "4%");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testFunctionColumnsCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setFunctionColumns("abc", "TEST", "XYz", "efg", testResult);
        this.metaData.setFunctionColumns("abc", "test", "xyz", "EFg", testResult2);
        this.metaData.setFunctionColumns(null, "test", "xyz", "EFg", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "t_st", "xyz", "EFG");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getFunctionColumns(null, "t_st", "xyz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getFunctionColumns("abc", "TE%", "XYz", "efg"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getFunctionColumns("ABC", "TEST", "XYz", "efg"));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getFunctionColumns("ABC", "TEST", "_Yz", "EFg");
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testTables() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables(null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("abc1", "abc2", "abc3", new String[]{"1", "2", "3"}));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setTables(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables(null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("", "test", "xyz", new String[]{"1", "2", "3"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc1", "test", "xyz", new String[0]));
        this.metaData.clearTables();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("", "test", "xyz", null));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        MockResultSet testResult4 = new MockResultSet("id4");
        this.metaData.setTables("", "test1", "xyz", null, testResult);
        this.metaData.setTables("abc", "test", "xyz", new String[]{"1"}, testResult2);
        this.metaData.setTables(null, "test", "xyz", new String[]{"2", "3"}, testResult3);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getTables("abc", "test", "xyz", new String[]{"1", "2", "3"}));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTables(null, "test", "xyz", new String[]{"1", "2", "3"});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("", "test1", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getTables("", "test", "xyz", new String[]{"1", "2", "3"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getTables("abc", "test", "xyz", new String[]{"1", "2", "3"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables(null, "test", "xyz1", new String[]{"1", "2", "3"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables(null, "test", null, new String[]{"1", "2", "3"}));
        this.metaData.setTables(testResult4);
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getTables(null, "test3", "xyz", null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getTables(null, "test", "xyz1", new String[]{"1", "2", "3"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult4, (Object)this.metaData.getTables(null, "test", null, new String[0]));
        polyResult = (PolyResultSet)this.metaData.getTables(null, "test", "xyz", new String[]{"1", "2", "3"});
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.clearTables();
        this.metaData.setTables("1", "2", "3", null, testResult);
        this.metaData.setTables("1", "2", "3", new String[]{"1", "2", "3"}, testResult2);
        this.metaData.setTables("1", "2", "3", new String[]{"5"}, testResult3);
        this.metaData.setTables("1", "2", "3", new String[]{"1"}, testResult4);
        polyResult = (PolyResultSet)this.metaData.getTables("1", "2", "3", null);
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)4, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult3, (Object)this.metaData.getTables("1", "2", "3", new String[]{"5", "6"}));
    }

    public void testTablesWithWildcards() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setTables("abc", "test", "xyz", new String[]{"1"}, testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc", "test", "xyz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables(null, "t__t", "%", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc", "tes%", "___", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc", "%es%", "x_z", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables(null, "_est", "xyz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables(null, "test", "_yz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc", "t%", "xy_", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc", "test%", "%xyz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("ab_", "test", "xyz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("a%", "te_t", "xyz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("abc", "test", "a%", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("abc", "t____", "xyz", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables(null, "test", "%xyz_", new String[]{"1"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("abc", "test1%", "x_z", new String[]{"1"}));
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setTables("abc1", "abc", "xyz", new String[]{"1"}, testResult2);
        this.metaData.setTables("abc1", "abc", "xyz1", new String[]{"1"}, testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTables(null, "%", "%", null);
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getTables("abc", "%", "xyz", new String[]{"1"}) instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getTables("abc1", "%", "xyz", null) instanceof MockResultSet));
        polyResult = (PolyResultSet)this.metaData.getTables(null, "a__", "xyz%", new String[]{"1"});
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)polyResult.getUnderlyingResultSetList().size());
        MockDatabaseMetaDataTest.assertTrue((boolean)(this.metaData.getTables(null, "a__", "xyz_", null) instanceof MockResultSet));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("%", "%", "%", null));
        polyResult = (PolyResultSet)this.metaData.getTables(null, "ab%", "%", new String[]{"1"});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
    }

    public void testTablesWithTypes() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setTables("abc", "test", "xyz", new String[]{"1"}, testResult);
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("abc", "test", "xyz", new String[]{"2"}));
        MockDatabaseMetaDataTest.assertEquals((Object)testResult, (Object)this.metaData.getTables("abc", "test", "xyz", null));
        MockDatabaseMetaDataTest.assertEquals((Object)testResult, (Object)this.metaData.getTables("abc", "test", "xyz", new String[]{"1", "2"}));
        MockResultSet testResult2 = new MockResultSet("id2");
        this.metaData.setTables("abc", "test", "xyz", new String[]{"2", "4"}, testResult2);
        MockDatabaseMetaDataTest.assertEquals((Object)testResult2, (Object)this.metaData.getTables("abc", "test", "xyz", new String[]{"2"}));
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTables("abc", "%", "%", new String[]{"1", "2", "3"});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
    }

    public void testTablesCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setTables("abc", "TEST", "XYz", new String[]{"a"}, testResult);
        this.metaData.setTables("abc", "test", "xyz", new String[]{"a"}, testResult2);
        this.metaData.setTables(null, "test", "xyz", new String[]{"a"}, testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getTables(null, "t_st", "xyz", new String[]{"a"});
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        this.metaData.setCaseSensitive(true);
        polyResult = (PolyResultSet)this.metaData.getTables(null, "t_st", "xyz", new String[]{"a"});
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getTables("abc", "TE%", "XYz", new String[]{"a"}));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getTables("ABC", "TEST", "XYz", new String[]{"a"}));
        this.metaData.setCaseSensitive(false);
        polyResult = (PolyResultSet)this.metaData.getTables("ABC", "TEST", "_Yz", new String[]{"a"});
        resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
    }

    public void testCrossReference() throws SQLException {
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getCrossReference(null, null, null, null, null, null));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getCrossReference(null, "ab", null, "12", null, "34"));
        MockResultSet testResult = new MockResultSet("id");
        this.metaData.setCrossReference(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getCrossReference(null, null, null, null, null, null));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getCrossReference("", "", "", "", "", ""));
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getCrossReference(null, "ab", null, "12", null, "34"));
        this.metaData.clearCrossReference();
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getCrossReference(null, "ab", null, "12", null, "34"));
        MockResultSet testResult2 = new MockResultSet("id2");
        this.metaData.setCrossReference(null, "ab", "78", "12", null, "34", testResult);
        this.metaData.setCrossReference("cd", "ab", "78", "12", "56", "34", testResult2);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getCrossReference(null, "ab", "78", "12", null, "34");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)2, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getCrossReference("cd", "ab", "78", "12", "56", "34"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getCrossReference(null, "b", "78", "12", null, "34"));
        MockDatabaseMetaDataTest.assertNull((Object)this.metaData.getCrossReference("cd", "ab", "78", "12", "56", null));
        this.metaData.setCrossReference(testResult);
        MockDatabaseMetaDataTest.assertSame((Object)testResult, (Object)this.metaData.getCrossReference("cd", "ab", "78", "12", "56", null));
    }

    public void testCrossReferenceCaseSensitive() throws SQLException {
        MockResultSet testResult = new MockResultSet("id");
        MockResultSet testResult2 = new MockResultSet("id2");
        MockResultSet testResult3 = new MockResultSet("id3");
        this.metaData.setCrossReference("ab", "cd", "ef", "gh", "ij", "kl", testResult);
        this.metaData.setCrossReference("Ab", "cd", "EF", "gh", "ij", "kl", testResult2);
        this.metaData.setCrossReference("ab", "CD", "ef", "gH", "IJ", "kl", testResult3);
        PolyResultSet polyResult = (PolyResultSet)this.metaData.getCrossReference("ab", "Cd", "ef", "gh", "ij", "kl");
        List resultSets = polyResult.getUnderlyingResultSetList();
        MockDatabaseMetaDataTest.assertEquals((int)3, (int)resultSets.size());
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult2));
        MockDatabaseMetaDataTest.assertTrue((boolean)resultSets.contains(testResult3));
        this.metaData.setCaseSensitive(true);
        MockDatabaseMetaDataTest.assertSame((Object)testResult2, (Object)this.metaData.getCrossReference("Ab", "cd", "EF", "gh", "ij", "kl"));
    }
}

