/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockRowId;
import java.util.Arrays;
import junit.framework.TestCase;

public class MockRowIdTest
extends TestCase {
    private MockRowId rowId;

    protected void setUp() throws Exception {
        super.setUp();
        this.rowId = new MockRowId(new byte[]{1, 2, 3});
    }

    public void testGetBytes() throws Exception {
        MockRowIdTest.assertTrue((boolean)Arrays.equals(this.rowId.getBytes(), new byte[]{1, 2, 3}));
        MockRowId emptyRowId = new MockRowId(new byte[0]);
        MockRowIdTest.assertTrue((boolean)Arrays.equals(emptyRowId.getBytes(), new byte[0]));
    }

    public void testEquals() throws Exception {
        MockRowIdTest.assertFalse((boolean)this.rowId.equals(null));
        MockRowIdTest.assertTrue((boolean)this.rowId.equals(this.rowId));
        MockRowId rowId2 = new MockRowId(new byte[]{1, 2, 3, 4});
        MockRowIdTest.assertFalse((boolean)this.rowId.equals(rowId2));
        MockRowIdTest.assertFalse((boolean)rowId2.equals(this.rowId));
        rowId2 = new MockRowId(new byte[]{1, 2, 3});
        MockRowIdTest.assertTrue((boolean)this.rowId.equals(rowId2));
        MockRowIdTest.assertTrue((boolean)rowId2.equals(this.rowId));
        MockRowIdTest.assertEquals((int)this.rowId.hashCode(), (int)rowId2.hashCode());
    }

    public void testClone() throws Exception {
        MockRowId cloneRowId = (MockRowId)this.rowId.clone();
        MockRowIdTest.assertTrue((boolean)Arrays.equals(this.rowId.getBytes(), cloneRowId.getBytes()));
        this.rowId.getBytes()[0] = 25;
        MockRowIdTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, cloneRowId.getBytes()));
        cloneRowId = (MockRowId)new MockRowId(new byte[0]).clone();
        MockRowIdTest.assertTrue((boolean)Arrays.equals(new byte[0], cloneRowId.getBytes()));
    }

    public void testToString() throws Exception {
        MockRowId rowId = new MockRowId(new byte[0]);
        MockRowIdTest.assertEquals((String)(MockRowId.class.getName() + ": []"), (String)rowId.toString());
        rowId = new MockRowId(new byte[]{1});
        MockRowIdTest.assertEquals((String)(MockRowId.class.getName() + ": [1]"), (String)rowId.toString());
        rowId = new MockRowId(new byte[]{1, 2, 3});
        MockRowIdTest.assertEquals((String)(MockRowId.class.getName() + ": [1, 2, 3]"), (String)rowId.toString());
    }
}

