/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockStruct;
import java.util.ArrayList;
import junit.framework.TestCase;

public class MockStructTest
extends TestCase {
    private MockStruct prepareTestStruct() {
        MockStruct struct = new MockStruct("teststruct", new Object[]{new Long(1L), "anAttribute2"});
        struct.addAttribute("myAttribute3");
        struct.addAttributes(new Object[]{new Integer(4), "anAttribute5"});
        ArrayList<String> list = new ArrayList<String>();
        list.add("myAttribute6");
        list.add("myAttribute7");
        struct.addAttributes(list);
        return struct;
    }

    public void testEquals() throws Exception {
        MockStruct nullStruct = new MockStruct((String)null);
        MockStructTest.assertFalse((boolean)nullStruct.equals(null));
        MockStructTest.assertTrue((boolean)nullStruct.equals(nullStruct));
        MockStruct struct = new MockStruct("test");
        MockStructTest.assertFalse((boolean)struct.equals(nullStruct));
        MockStructTest.assertFalse((boolean)nullStruct.equals(struct));
        MockStruct other = new MockStruct("test");
        MockStructTest.assertTrue((boolean)struct.equals(other));
        MockStructTest.assertTrue((boolean)other.equals(struct));
        MockStructTest.assertEquals((int)struct.hashCode(), (int)other.hashCode());
        other = new MockStruct("test"){};
        MockStructTest.assertFalse((boolean)other.equals(struct));
        MockStructTest.assertFalse((boolean)struct.equals(other));
        other = new MockStruct("test");
        other.addAttribute("myAttribute1");
        MockStructTest.assertFalse((boolean)other.equals(struct));
        MockStructTest.assertFalse((boolean)struct.equals(other));
        struct.addAttribute("myAttribute1");
        MockStructTest.assertTrue((boolean)struct.equals(other));
        MockStructTest.assertTrue((boolean)other.equals(struct));
        MockStructTest.assertEquals((int)struct.hashCode(), (int)other.hashCode());
        other.addAttributes(new String[]{"1", "2"});
        MockStructTest.assertFalse((boolean)other.equals(struct));
        MockStructTest.assertFalse((boolean)struct.equals(other));
        struct.addAttributes(new String[]{"1", "2"});
        MockStructTest.assertTrue((boolean)struct.equals(other));
        MockStructTest.assertTrue((boolean)other.equals(struct));
        MockStructTest.assertEquals((int)struct.hashCode(), (int)other.hashCode());
    }

    public void testAttributes() throws Exception {
        this.doTestAttributes(this.prepareTestStruct());
    }

    public void testToString() throws Exception {
        MockStruct struct = this.prepareTestStruct();
        MockStructTest.assertEquals((String)"Struct data: [1, anAttribute2, myAttribute3, 4, anAttribute5, myAttribute6, myAttribute7]", (String)struct.toString());
    }

    public void testClone() throws Exception {
        MockStruct struct = this.prepareTestStruct();
        MockStruct copyStruct = (MockStruct)struct.clone();
        MockStructTest.assertNotSame((Object)struct, (Object)copyStruct);
        this.doTestAttributes(copyStruct);
    }

    public void doTestAttributes(MockStruct struct) throws Exception {
        MockStructTest.assertEquals((String)"teststruct", (String)struct.getSQLTypeName());
        Object[] attributes = struct.getAttributes();
        MockStructTest.assertEquals((Object)new Long(1L), (Object)attributes[0]);
        MockStructTest.assertEquals((Object)"anAttribute2", (Object)attributes[1]);
        MockStructTest.assertEquals((Object)"myAttribute3", (Object)attributes[2]);
        MockStructTest.assertEquals((Object)new Integer(4), (Object)attributes[3]);
        MockStructTest.assertEquals((Object)"anAttribute5", (Object)attributes[4]);
        MockStructTest.assertEquals((Object)"myAttribute6", (Object)attributes[5]);
        MockStructTest.assertEquals((Object)"myAttribute7", (Object)attributes[6]);
    }
}

