/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractResultSetHandler {
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;
    private boolean continueProcessingOnBatchFailure = false;
    private Object globalResultSets;
    private Map resultSetsForStatement = new TreeMap();
    private Object globalUpdateCounts;
    private Map updateCountForStatement = new TreeMap();
    private MockResultSet globalGeneratedKeys;
    private Map generatedKeysForStatement = new TreeMap();
    private Map returnsResultSetMap = new TreeMap();
    private Map throwsSQLException = new TreeMap();
    private List executedStatements = new ArrayList();
    private List returnedResultSets = new ArrayList();

    public MockResultSet createResultSet() {
        return new MockResultSet(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String id) {
        return new MockResultSet(id);
    }

    public MockResultSet createResultSet(ResultSetFactory factory) {
        return factory.create(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String id, ResultSetFactory factory) {
        return factory.create(id);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    public void setUseRegularExpressions(boolean useRegularExpressions) {
        this.useRegularExpressions = useRegularExpressions;
    }

    public void setContinueProcessingOnBatchFailure(boolean continueProcessingOnBatchFailure) {
        this.continueProcessingOnBatchFailure = continueProcessingOnBatchFailure;
    }

    public void addExecutedStatement(String sql) {
        this.executedStatements.add(sql);
    }

    public void addReturnedResultSet(MockResultSet resultSet) {
        if (null == resultSet) {
            return;
        }
        this.returnedResultSets.add(resultSet);
    }

    public void addReturnedResultSets(MockResultSet[] resultSets) {
        if (null == resultSets) {
            return;
        }
        this.returnedResultSets.add(resultSets);
    }

    public List getExecutedStatements() {
        return Collections.unmodifiableList(this.executedStatements);
    }

    public List getReturnedResultSets() {
        return Collections.unmodifiableList(this.returnedResultSets);
    }

    public void clearResultSets() {
        this.resultSetsForStatement.clear();
    }

    public void clearUpdateCounts() {
        this.updateCountForStatement.clear();
    }

    public void clearReturnsResultSet() {
        this.returnsResultSetMap.clear();
    }

    public void clearThrowsSQLException() {
        this.throwsSQLException.clear();
    }

    public void clearGeneratedKeys() {
        this.generatedKeysForStatement.clear();
    }

    public void clearGlobalResultSet() {
        this.globalResultSets = null;
    }

    public void clearGlobalGeneratedKeys() {
        this.globalGeneratedKeys = null;
    }

    public void clearGlobalUpdateCount() {
        this.globalUpdateCounts = null;
    }

    public Map getResultSetMap() {
        return Collections.unmodifiableMap(this.resultSetsForStatement);
    }

    public Map getUpdateCountMap() {
        return Collections.unmodifiableMap(this.updateCountForStatement);
    }

    public Map getGeneratedKeysMap() {
        return Collections.unmodifiableMap(this.generatedKeysForStatement);
    }

    public MockResultSet getResultSet(String sql) {
        MockResultSet[] actualResults;
        Object resultSets = this.getMatchingResultSets(sql);
        if (null == resultSets) {
            return null;
        }
        if (resultSets instanceof MockResultSet) {
            return (MockResultSet)resultSets;
        }
        if (resultSets instanceof MockResultSet[] && (actualResults = (MockResultSet[])resultSets).length > 0) {
            return actualResults[0];
        }
        return null;
    }

    public MockResultSet[] getResultSets(String sql) {
        Object resultSets = this.getMatchingResultSets(sql);
        if (null == resultSets) {
            return null;
        }
        if (resultSets instanceof MockResultSet) {
            return new MockResultSet[]{(MockResultSet)resultSets};
        }
        if (resultSets instanceof MockResultSet[]) {
            return (MockResultSet[])resultSets;
        }
        return null;
    }

    public boolean hasMultipleResultSets(String sql) {
        Object resultSets = this.getMatchingResultSets(sql);
        return resultSets instanceof MockResultSet[];
    }

    private Object getMatchingResultSets(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(this.resultSetsForStatement, sql, true, true);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalResultSet() {
        if (null == this.globalResultSets) {
            return null;
        }
        if (this.globalResultSets instanceof MockResultSet) {
            return (MockResultSet)this.globalResultSets;
        }
        MockResultSet[] resultSets = this.getGlobalResultSets();
        if (null != resultSets && resultSets.length > 0) {
            return resultSets[0];
        }
        return null;
    }

    public MockResultSet[] getGlobalResultSets() {
        if (null == this.globalResultSets) {
            return null;
        }
        if (this.globalResultSets instanceof MockResultSet[]) {
            return (MockResultSet[])this.globalResultSets;
        }
        return new MockResultSet[]{(MockResultSet)this.globalResultSets};
    }

    public boolean hasMultipleGlobalResultSets() {
        return this.globalResultSets instanceof MockResultSet[];
    }

    public Integer getUpdateCount(String sql) {
        Integer[] actualUpdateCounts;
        Object updateCounts = this.getMatchingUpdateCounts(sql);
        if (null == updateCounts) {
            return null;
        }
        if (updateCounts instanceof Integer) {
            return (Integer)updateCounts;
        }
        if (updateCounts instanceof Integer[] && (actualUpdateCounts = (Integer[])updateCounts).length > 0) {
            return actualUpdateCounts[0];
        }
        return null;
    }

    public Integer[] getUpdateCounts(String sql) {
        Object updateCounts = this.getMatchingUpdateCounts(sql);
        if (null == updateCounts) {
            return null;
        }
        if (updateCounts instanceof Integer) {
            return new Integer[]{(Integer)updateCounts};
        }
        if (updateCounts instanceof Integer[]) {
            return (Integer[])updateCounts;
        }
        return null;
    }

    public boolean hasMultipleUpdateCounts(String sql) {
        Object updateCounts = this.getMatchingUpdateCounts(sql);
        return updateCounts instanceof Integer[];
    }

    private Object getMatchingUpdateCounts(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(this.updateCountForStatement, sql, true, true);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int getGlobalUpdateCount() {
        if (null == this.globalUpdateCounts) {
            return 0;
        }
        if (this.globalUpdateCounts instanceof Integer) {
            return (Integer)this.globalUpdateCounts;
        }
        int[] updateCounts = this.getGlobalUpdateCounts();
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return 0;
    }

    public int[] getGlobalUpdateCounts() {
        if (null == this.globalUpdateCounts) {
            return null;
        }
        if (this.globalUpdateCounts instanceof int[]) {
            return (int[])this.globalUpdateCounts;
        }
        return new int[]{(Integer)this.globalUpdateCounts};
    }

    public boolean hasMultipleGlobalUpdateCounts() {
        return this.globalUpdateCounts instanceof int[];
    }

    public MockResultSet getGeneratedKeys(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(this.generatedKeysForStatement, sql, true, true);
        if (null != list && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalGeneratedKeys() {
        return this.globalGeneratedKeys;
    }

    public Boolean getReturnsResultSet(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(this.returnsResultSetMap, sql, true, true);
        if (null != list && list.size() > 0) {
            return (Boolean)list.get(0);
        }
        return null;
    }

    public boolean getThrowsSQLException(String sql) {
        return this.getSQLException(sql) != null;
    }

    public SQLException getSQLException(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(this.throwsSQLException, sql, true, true);
        if (null == list || list.size() == 0) {
            return null;
        }
        return (SQLException)list.get(0);
    }

    public void prepareResultSet(String sql, MockResultSet resultSet) {
        this.resultSetsForStatement.put(sql, resultSet);
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets) {
        this.resultSetsForStatement.put(sql, resultSets.clone());
    }

    public void prepareGlobalResultSet(MockResultSet resultSet) {
        this.globalResultSets = resultSet;
    }

    public void prepareGlobalResultSets(MockResultSet[] resultSets) {
        this.globalResultSets = (MockResultSet[])resultSets.clone();
    }

    public void prepareUpdateCount(String sql, int updateCount) {
        this.updateCountForStatement.put(sql, new Integer(updateCount));
    }

    public void prepareUpdateCounts(String sql, int[] updateCounts) {
        this.updateCountForStatement.put(sql, ArrayUtil.convertToObjectArray((Object)updateCounts));
    }

    public void prepareGlobalUpdateCount(int updateCount) {
        this.globalUpdateCounts = new Integer(updateCount);
    }

    public void prepareGlobalUpdateCounts(int[] updateCounts) {
        this.globalUpdateCounts = (int[])updateCounts.clone();
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult) {
        this.generatedKeysForStatement.put(sql, generatedKeysResult);
    }

    public void prepareGlobalGeneratedKeys(MockResultSet generatedKeysResult) {
        this.globalGeneratedKeys = generatedKeysResult;
    }

    public void prepareReturnsResultSet(String sql, boolean returnsResultSet) {
        this.returnsResultSetMap.put(sql, new Boolean(returnsResultSet));
    }

    public void prepareThrowsSQLException(String sql) {
        this.throwsSQLException.put(sql, new SQLException("Statement " + sql + " was specified to throw an exception"));
    }

    public void prepareThrowsSQLException(String sql, SQLException exc) {
        this.throwsSQLException.put(sql, exc);
    }

    protected boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    protected boolean getExactMatch() {
        return this.exactMatch;
    }

    protected boolean getUseRegularExpressions() {
        return this.useRegularExpressions;
    }

    public boolean getContinueProcessingOnBatchFailure() {
        return this.continueProcessingOnBatchFailure;
    }

    public void removeResultSet(String sql) {
        this.resultSetsForStatement.remove(sql);
    }

    public void removeThrowsSqlException(String sql) {
        this.throwsSQLException.remove(sql);
    }

    public void removeUpdateCount(String sql) {
        this.updateCountForStatement.remove(sql);
    }

    public void removeGeneratedKeys(String sql) {
        this.generatedKeysForStatement.remove(sql);
    }
}

