/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.jdbc.CallableStatementResultSetHandler;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.JDBCMockObjectFactory;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.StringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JDBCTestModule {
    private JDBCMockObjectFactory mockFactory;
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;

    public JDBCTestModule(JDBCMockObjectFactory mockFactory) {
        this.mockFactory = mockFactory;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    public void setUseRegularExpressions(boolean useRegularExpressions) {
        this.useRegularExpressions = useRegularExpressions;
    }

    public StatementResultSetHandler getStatementResultSetHandler() {
        return this.mockFactory.getMockConnection().getStatementResultSetHandler();
    }

    public PreparedStatementResultSetHandler getPreparedStatementResultSetHandler() {
        return this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler();
    }

    public CallableStatementResultSetHandler getCallableStatementResultSetHandler() {
        return this.mockFactory.getMockConnection().getCallableStatementResultSetHandler();
    }

    public MockStatement getStatement(int index) {
        List statements = this.getStatements();
        if (index < statements.size()) {
            return (MockStatement)statements.get(index);
        }
        return null;
    }

    public List getStatements() {
        return this.mockFactory.getMockConnection().getStatementResultSetHandler().getStatements();
    }

    public List getExecutedSQLStatements() {
        ArrayList list = new ArrayList();
        list.addAll(this.mockFactory.getMockConnection().getStatementResultSetHandler().getExecutedStatements());
        list.addAll(this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getExecutedStatements());
        list.addAll(this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getExecutedStatements());
        return list;
    }

    public Map getExecutedSQLStatementParameter() {
        return this.getExecutedSQLStatementParameterMap();
    }

    public Map getExecutedSQLStatementParameterMap() {
        TreeMap map = new TreeMap();
        map.putAll(this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getExecutedStatementParameterMap());
        map.putAll(this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getExecutedStatementParameterMap());
        return map;
    }

    public ParameterSets getExecutedSQLStatementParameterSets(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        Map map = this.getExecutedSQLStatementParameterMap();
        List list = matcher.getMatchingObjects(map, sql, false, false);
        if (list != null && list.size() > 0) {
            return (ParameterSets)list.get(0);
        }
        return null;
    }

    public MockResultSet getReturnedResultSet(String id) {
        List list = this.getReturnedResultSets(id);
        if (list != null && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public List getReturnedResultSets(String id) {
        List list = this.getReturnedResultSets();
        ArrayList resultList = new ArrayList();
        for (int ii = 0; ii < list.size(); ++ii) {
            Object object = list.get(ii);
            if (object instanceof MockResultSet) {
                this.addIfIdMatches((MockResultSet)object, id, resultList);
                continue;
            }
            if (!(object instanceof MockResultSet[])) continue;
            MockResultSet[] resultSets = (MockResultSet[])object;
            for (int yy = 0; yy < resultSets.length; ++yy) {
                this.addIfIdMatches(resultSets[yy], id, resultList);
            }
        }
        return resultList;
    }

    private void addIfIdMatches(MockResultSet resultSet, String id, List resultList) {
        if (null == id) {
            return;
        }
        if (id.equals(resultSet.getId())) {
            resultList.add(resultSet);
        }
    }

    public List getReturnedResultSets() {
        ArrayList list = new ArrayList();
        list.addAll(this.mockFactory.getMockConnection().getStatementResultSetHandler().getReturnedResultSets());
        list.addAll(this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getReturnedResultSets());
        list.addAll(this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getReturnedResultSets());
        return list;
    }

    public MockPreparedStatement getPreparedStatement(int index) {
        List statements = this.getPreparedStatements();
        if (index < statements.size()) {
            return (MockPreparedStatement)statements.get(index);
        }
        return null;
    }

    public MockPreparedStatement getPreparedStatement(String sql) {
        List list = this.getPreparedStatements(sql);
        if (null != list && list.size() > 0) {
            return (MockPreparedStatement)list.get(0);
        }
        return null;
    }

    public List getPreparedStatements() {
        return this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getPreparedStatements();
    }

    public List getPreparedStatements(String sql) {
        Map sqlStatements = this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getPreparedStatementMap();
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        return matcher.getMatchingObjects(sqlStatements, sql, true, false);
    }

    public MockCallableStatement getCallableStatement(int index) {
        List statements = this.getCallableStatements();
        if (index < statements.size()) {
            return (MockCallableStatement)statements.get(index);
        }
        return null;
    }

    public MockCallableStatement getCallableStatement(String sql) {
        List list = this.getCallableStatements(sql);
        if (null != list && list.size() > 0) {
            return (MockCallableStatement)list.get(0);
        }
        return null;
    }

    public List getCallableStatements() {
        return this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getCallableStatements();
    }

    public List getCallableStatements(String sql) {
        Map sqlStatements = this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getCallableStatementMap();
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        return matcher.getMatchingObjects(sqlStatements, sql, true, false);
    }

    public Object getPreparedStatementParameter(PreparedStatement statement, int indexOfParameter) {
        if (null == statement) {
            return null;
        }
        return ((MockPreparedStatement)statement).getParameter(indexOfParameter);
    }

    public Object getPreparedStatementParameter(String sql, int indexOfParameter) {
        return this.getPreparedStatementParameter(this.getPreparedStatement(sql), indexOfParameter);
    }

    public Object getPreparedStatementParameter(int indexOfStatement, int indexOfParameter) {
        return this.getPreparedStatementParameter(this.getPreparedStatement(indexOfStatement), indexOfParameter);
    }

    public Object getCallableStatementParameter(CallableStatement statement, int indexOfParameter) {
        if (null == statement) {
            return null;
        }
        return ((MockCallableStatement)statement).getParameter(indexOfParameter);
    }

    public Object getCallableStatementParameter(String sql, int indexOfParameter) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(sql), indexOfParameter);
    }

    public Object getCallableStatementParameter(int indexOfStatement, int indexOfParameter) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(indexOfStatement), indexOfParameter);
    }

    public Object getCallableStatementParameter(CallableStatement statement, String nameOfParameter) {
        if (null == statement) {
            return null;
        }
        return ((MockCallableStatement)statement).getParameter(nameOfParameter);
    }

    public Object getCallableStatementParameter(String sql, String nameOfParameter) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(sql), nameOfParameter);
    }

    public Object getCallableStatementParameter(int indexOfStatement, String nameOfParameter) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(indexOfStatement), nameOfParameter);
    }

    public List getSavepoints() {
        return new ArrayList(this.mockFactory.getMockConnection().getSavepointMap().values());
    }

    public MockSavepoint getSavepoint(int index) {
        List savepoints = this.getSavepoints();
        for (int ii = 0; ii < savepoints.size(); ++ii) {
            MockSavepoint currentSavepoint = (MockSavepoint)savepoints.get(ii);
            if (currentSavepoint.getNumber() != index) continue;
            return currentSavepoint;
        }
        return null;
    }

    public MockSavepoint getSavepoint(String name) {
        List savepoints = this.getSavepoints();
        for (int ii = 0; ii < savepoints.size(); ++ii) {
            MockSavepoint currentSavepoint = (MockSavepoint)savepoints.get(ii);
            try {
                if (!currentSavepoint.getSavepointName().equals(name)) continue;
                return currentSavepoint;
            }
            catch (SQLException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    public void verifySQLStatementExecuted(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        if (!matcher.contains(this.getExecutedSQLStatements(), sql, false)) {
            throw new VerifyFailedException("Statement " + sql + " not executed.");
        }
    }

    public void verifySQLStatementNotExecuted(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        if (matcher.contains(this.getExecutedSQLStatements(), sql, false)) {
            throw new VerifyFailedException("Statement " + sql + " was executed.");
        }
    }

    public void verifySQLStatementParameterNumber(String sql, int indexOfParameterSet, int number) {
        Map actualParameterMap = this.verifyAndGetParametersForSQL(sql, indexOfParameterSet);
        if (actualParameterMap.size() != number) {
            throw new VerifyFailedException("Expected " + number + " parameter, actual " + actualParameterMap.size() + " parameter");
        }
    }

    public void verifySQLStatementParameter(String sql, int indexOfParameterSet, Map parameterMap) {
        this.verifySQLStatementParameterNumber(sql, indexOfParameterSet, parameterMap.size());
        Map actualParameterMap = this.verifyAndGetParametersForSQL(sql, indexOfParameterSet);
        for (Object nextKey : parameterMap.keySet()) {
            Object nextExpectedParameter = parameterMap.get(nextKey);
            Object nextActualParameter = actualParameterMap.get(nextKey);
            if (null == nextActualParameter) {
                throw new VerifyFailedException("No parameter " + nextKey + " found.");
            }
            if (ParameterUtil.compareParameter(nextExpectedParameter, nextActualParameter)) continue;
            throw new VerifyFailedException("Expected " + nextExpectedParameter + " for parameter " + nextKey + ", but was " + nextActualParameter);
        }
    }

    public void verifySQLStatementParameter(String sql, int indexOfParameterSet, int indexOfParameter, Object expectedParameter) {
        Map actualParameterMap = this.verifyAndGetParametersForSQL(sql, indexOfParameterSet);
        Object actualParameter = actualParameterMap.get(new Integer(indexOfParameter));
        if (!ParameterUtil.compareParameter(expectedParameter, actualParameter)) {
            throw new VerifyFailedException("Expected " + expectedParameter + " for parameter " + indexOfParameter + ", but was " + actualParameter);
        }
    }

    public void verifySQLStatementParameter(String sql, int indexOfParameterSet, String nameOfParameter, Object expectedParameter) {
        Map actualParameterMap = this.verifyAndGetParametersForSQL(sql, indexOfParameterSet);
        Object actualParameter = actualParameterMap.get(nameOfParameter);
        if (!ParameterUtil.compareParameter(expectedParameter, actualParameter)) {
            throw new VerifyFailedException("Expected " + expectedParameter + " for parameter " + nameOfParameter + ", but was " + actualParameter);
        }
    }

    private Map verifyAndGetParametersForSQL(String sql, int indexOfParameterSet) {
        this.verifySQLStatementExecuted(sql);
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        List matchingParameterList = matcher.getMatchingObjects(this.getExecutedSQLStatementParameterMap(), sql, true, false);
        if (null == matchingParameterList || matchingParameterList.size() == 0) {
            throw new VerifyFailedException("No parameter sets for SQL " + sql + " found. Maybe the SQL has been executed by a regular " + "statement instead of a prepared statement or callable statement.");
        }
        ParameterSets actualParameterSets = (ParameterSets)matchingParameterList.get(0);
        if (null == actualParameterSets || indexOfParameterSet >= actualParameterSets.getNumberParameterSets()) {
            throw new VerifyFailedException("Statement " + sql + " has no parameter set with index " + indexOfParameterSet + ". Maybe it has been executed less than " + (indexOfParameterSet + 1) + " times.");
        }
        return actualParameterSets.getParameterSet(indexOfParameterSet);
    }

    public void verifyConnectionClosed() {
        try {
            if (!this.mockFactory.getMockConnection().isClosed()) {
                throw new VerifyFailedException("Connection not closed.");
            }
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void verifyAllStatementsClosed() {
        MockStatement statement;
        int ii;
        List statements = this.getStatements();
        for (ii = 0; ii < statements.size(); ++ii) {
            statement = (MockStatement)statements.get(ii);
            if (statement.isClosed()) continue;
            throw new VerifyFailedException("Statement with index " + ii + " not closed.");
        }
        statements = this.getPreparedStatements();
        for (ii = 0; ii < statements.size(); ++ii) {
            statement = (MockPreparedStatement)statements.get(ii);
            if (statement.isClosed()) continue;
            throw new VerifyFailedException("Prepared statement with index " + ii + " (SQL " + ((MockPreparedStatement)statement).getSQL() + ") not closed.");
        }
        statements = this.getCallableStatements();
        for (ii = 0; ii < statements.size(); ++ii) {
            statement = (MockCallableStatement)statements.get(ii);
            if (statement.isClosed()) continue;
            throw new VerifyFailedException("Callable statement with index " + ii + " (SQL " + ((MockPreparedStatement)statement).getSQL() + ") not closed.");
        }
    }

    public void verifyResultSetClosed(String id) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        if (!resultSet.isClosed()) {
            throw new VerifyFailedException("ResultSet with id " + id + " not closed.");
        }
    }

    public void verifyResultSetRowInserted(MockResultSet resultSet, int number) {
        if (!resultSet.rowInserted(number)) {
            throw new VerifyFailedException("Row number " + number + " of ResultSet " + resultSet.getId() + " not inserted.");
        }
    }

    public void verifyResultSetRowInserted(String id, int number) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRowInserted(resultSet, number);
    }

    public void verifyResultSetRowNotInserted(MockResultSet resultSet, int number) {
        if (resultSet.rowInserted(number)) {
            throw new VerifyFailedException("Row number " + number + " of ResultSet " + resultSet.getId() + " was inserted.");
        }
    }

    public void verifyResultSetRowNotInserted(String id, int number) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRowNotInserted(resultSet, number);
    }

    public void verifyResultSetRowUpdated(MockResultSet resultSet, int number) {
        if (!resultSet.rowUpdated(number)) {
            throw new VerifyFailedException("Row number " + number + " of ResultSet " + resultSet.getId() + " not updated.");
        }
    }

    public void verifyResultSetRowUpdated(String id, int number) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRowUpdated(resultSet, number);
    }

    public void verifyResultSetRowNotUpdated(MockResultSet resultSet, int number) {
        if (resultSet.rowUpdated(number)) {
            throw new VerifyFailedException("Row number " + number + " of ResultSet " + resultSet.getId() + " was updated.");
        }
    }

    public void verifyResultSetRowNotUpdated(String id, int number) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRowNotUpdated(resultSet, number);
    }

    public void verifyResultSetRowDeleted(MockResultSet resultSet, int number) {
        if (!resultSet.rowDeleted(number)) {
            throw new VerifyFailedException("Row number " + number + " of ResultSet " + resultSet.getId() + " not deleted.");
        }
    }

    public void verifyResultSetRowDeleted(String id, int number) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRowDeleted(resultSet, number);
    }

    public void verifyResultSetRowNotDeleted(MockResultSet resultSet, int number) {
        if (resultSet.rowDeleted(number)) {
            throw new VerifyFailedException("Row number " + number + " of ResultSet " + resultSet.getId() + " was deleted.");
        }
    }

    public void verifyResultSetRowNotDeleted(String id, int number) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRowNotDeleted(resultSet, number);
    }

    public void verifyAllResultSetsClosed() {
        List allResultSets = this.getReturnedResultSets();
        for (int ii = 0; ii < allResultSets.size(); ++ii) {
            Object object = allResultSets.get(ii);
            if (object instanceof MockResultSet) {
                this.throwExceptionIfNotClosed((MockResultSet)object);
                continue;
            }
            if (!(object instanceof MockResultSet[])) continue;
            MockResultSet[] resultSets = (MockResultSet[])object;
            for (int yy = 0; yy < resultSets.length; ++yy) {
                this.throwExceptionIfNotClosed(resultSets[yy]);
            }
        }
    }

    private void throwExceptionIfNotClosed(MockResultSet resultSet) {
        if (!resultSet.isClosed()) {
            throw new VerifyFailedException("ResultSet with id " + resultSet.getId() + " not closed.");
        }
    }

    public void verifyCommitted() {
        int number = this.mockFactory.getMockConnection().getNumberCommits();
        if (number <= 0) {
            throw new VerifyFailedException("Connection received no commits.");
        }
    }

    public void verifyNotCommitted() {
        int number = this.mockFactory.getMockConnection().getNumberCommits();
        if (number > 0) {
            throw new VerifyFailedException("Connection was committed");
        }
    }

    public void verifyRolledBack() {
        int number = this.mockFactory.getMockConnection().getNumberRollbacks();
        if (number <= 0) {
            throw new VerifyFailedException("Connection received no rollbacks.");
        }
    }

    public void verifyNotRolledBack() {
        int number = this.mockFactory.getMockConnection().getNumberRollbacks();
        if (number > 0) {
            throw new VerifyFailedException("Connection was rolled back.");
        }
    }

    public void verifyNumberCommits(int number) {
        int actualNumber = this.mockFactory.getMockConnection().getNumberCommits();
        if (actualNumber != number) {
            throw new VerifyFailedException("Connection received " + actualNumber + " commits, expected " + number);
        }
    }

    public void verifyNumberRollbacks(int number) {
        int actualNumber = this.mockFactory.getMockConnection().getNumberRollbacks();
        if (actualNumber != number) {
            throw new VerifyFailedException("Connection received " + actualNumber + " rollbacks, expected " + number);
        }
    }

    public void verifyNumberStatements(int number) {
        this.verifyNumberStatements(number, this.getStatements());
    }

    public void verifyNumberPreparedStatements(int number) {
        this.verifyNumberStatements(number, this.getPreparedStatements());
    }

    public void verifyNumberPreparedStatements(int number, String sql) {
        this.verifyNumberStatements(number, this.getPreparedStatements(sql));
    }

    public void verifyNumberCallableStatements(int number) {
        this.verifyNumberStatements(number, this.getCallableStatements());
    }

    public void verifyNumberCallableStatements(int number, String sql) {
        this.verifyNumberStatements(number, this.getCallableStatements(sql));
    }

    private void verifyNumberStatements(int number, List statements) {
        if (null == statements || statements.size() == 0) {
            if (number == 0) {
                return;
            }
            throw new VerifyFailedException("Expected " + number + " statements, received 0 statements");
        }
        if (statements.size() != number) {
            throw new VerifyFailedException("Expected " + number + " statements, received " + statements.size() + " statements");
        }
    }

    public void verifyStatementClosed(int index) {
        MockStatement statement = this.getStatement(index);
        if (null == statement) {
            throw new VerifyFailedException("No statement with index " + index + " present.");
        }
        if (!statement.isClosed()) {
            throw new VerifyFailedException("Statement with index " + index + " not closed.");
        }
    }

    public void verifyPreparedStatementClosed(int index) {
        MockPreparedStatement statement = this.getPreparedStatement(index);
        if (null == statement) {
            throw new VerifyFailedException("No prepared statement with index " + index + " present.");
        }
        if (!statement.isClosed()) {
            throw new VerifyFailedException("Prepared statement with index " + index + " not closed.");
        }
    }

    public void verifyPreparedStatementClosed(String sql) {
        MockPreparedStatement statement = this.getPreparedStatement(sql);
        if (null == statement) {
            throw new VerifyFailedException("No prepared statement with SQL " + sql + " present.");
        }
        if (!statement.isClosed()) {
            throw new VerifyFailedException("Prepared statement with SQL " + sql + " not closed.");
        }
    }

    public void verifyCallableStatementClosed(int index) {
        MockCallableStatement statement = this.getCallableStatement(index);
        if (null == statement) {
            throw new VerifyFailedException("No callable statement with index " + index + " present.");
        }
        if (!statement.isClosed()) {
            throw new VerifyFailedException("Callable statement with index " + index + " not closed.");
        }
    }

    public void verifyCallableStatementClosed(String sql) {
        MockCallableStatement statement = this.getCallableStatement(sql);
        if (null == statement) {
            throw new VerifyFailedException("No callable statement with SQL " + sql + " present.");
        }
        if (!statement.isClosed()) {
            throw new VerifyFailedException("Callable statement with SQL " + sql + " not closed.");
        }
    }

    public void verifyResultSetRow(MockResultSet resultSet, int number, List rowData) {
        if (null == resultSet.getRow(number)) {
            throw new VerifyFailedException("ResultSet " + resultSet.getId() + " has no row " + number);
        }
        if (!resultSet.isRowEqual(number, rowData)) {
            StringBuffer buffer = new StringBuffer("Actual row data:\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, (List)resultSet.getRow(number));
            buffer.append("\n");
            buffer.append("Expected row data:\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, (List)rowData);
            throw new VerifyFailedException("Mismatch in row data.\n" + buffer.toString());
        }
    }

    public void verifyResultSetRow(MockResultSet resultSet, int number, Object[] rowData) {
        List<Object> dataList = Arrays.asList(rowData);
        this.verifyResultSetRow(resultSet, number, dataList);
    }

    public void verifyResultSetRow(String id, int number, List rowData) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetRow(resultSet, number, rowData);
    }

    public void verifyResultSetRow(String id, int number, Object[] rowData) {
        List<Object> dataList = Arrays.asList(rowData);
        this.verifyResultSetRow(id, number, dataList);
    }

    public void verifyResultSetColumn(MockResultSet resultSet, int number, List columnData) {
        if (null == resultSet.getColumn(number)) {
            throw new VerifyFailedException("ResultSet " + resultSet.getId() + " has no column " + number);
        }
        if (!resultSet.isColumnEqual(number, columnData)) {
            StringBuffer buffer = new StringBuffer("Actual column data:\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, (List)resultSet.getColumn(number));
            buffer.append("\n");
            buffer.append("Expected column data:\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, (List)columnData);
            throw new VerifyFailedException("Mismatch in column data.\n" + buffer.toString());
        }
    }

    public void verifyResultSetColumn(MockResultSet resultSet, int number, Object[] columnData) {
        List<Object> dataList = Arrays.asList(columnData);
        this.verifyResultSetColumn(resultSet, number, dataList);
    }

    public void verifyResultSetColumn(String id, int number, List columnData) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetColumn(resultSet, number, columnData);
    }

    public void verifyResultSetColumn(String id, int number, Object[] columnData) {
        List<Object> dataList = Arrays.asList(columnData);
        this.verifyResultSetColumn(id, number, dataList);
    }

    public void verifyResultSetColumn(MockResultSet resultSet, String name, List columnData) {
        if (null == resultSet.getColumn(name)) {
            throw new VerifyFailedException("ResultSet " + resultSet.getId() + " has no column " + name);
        }
        if (!resultSet.isColumnEqual(name, columnData)) {
            StringBuffer buffer = new StringBuffer("Actual column data:\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, (List)resultSet.getColumn(name));
            buffer.append("\n");
            buffer.append("Expected column data:\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, (List)columnData);
            throw new VerifyFailedException("Mismatch in column data.\n" + buffer.toString());
        }
    }

    public void verifyResultSetColumn(MockResultSet resultSet, String name, Object[] columnData) {
        List<Object> dataList = Arrays.asList(columnData);
        this.verifyResultSetColumn(resultSet, name, dataList);
    }

    public void verifyResultSetColumn(String id, String name, List columnData) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetColumn(resultSet, name, columnData);
    }

    public void verifyResultSetColumn(String id, String name, Object[] columnData) {
        List<Object> dataList = Arrays.asList(columnData);
        this.verifyResultSetColumn(id, name, dataList);
    }

    public void verifyResultSetEquals(MockResultSet source, MockResultSet target) {
        if (!source.isEqual(target)) {
            StringBuffer buffer = new StringBuffer("Source data:\n");
            buffer.append(source.toString());
            buffer.append("\n");
            buffer.append("Target data:\n");
            buffer.append(target.toString());
            throw new VerifyFailedException("Mismatch in ResultSet data.\n" + buffer.toString());
        }
    }

    public void verifyResultSetEquals(String id, MockResultSet target) {
        MockResultSet resultSet = this.getReturnedResultSet(id);
        if (null == resultSet) {
            throw new VerifyFailedException("ResultSet with id " + id + " not present.");
        }
        this.verifyResultSetEquals(resultSet, target);
    }

    public void verifyPreparedStatementPresent(String sql) {
        if (null == this.getPreparedStatement(sql)) {
            throw new VerifyFailedException("Prepared statement with SQL " + sql + " present.");
        }
    }

    public void verifyPreparedStatementNotPresent(String sql) {
        if (null != this.getPreparedStatement(sql)) {
            throw new VerifyFailedException("Prepared statement with SQL " + sql + " not present.");
        }
    }

    public void verifyCallableStatementPresent(String sql) {
        if (null == this.getCallableStatement(sql)) {
            throw new VerifyFailedException("Callable statement with SQL " + sql + " present.");
        }
    }

    public void verifyCallableStatementNotPresent(String sql) {
        if (null != this.getCallableStatement(sql)) {
            throw new VerifyFailedException("Callable statement with SQL " + sql + " not present.");
        }
    }

    public void verifyPreparedStatementParameterPresent(PreparedStatement statement, int indexOfParameter) {
        if (!this.containsPreparedStatementParameter(statement, indexOfParameter)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " not present.");
        }
    }

    public void verifyPreparedStatementParameterPresent(String sql, int indexOfParameter) {
        if (!this.containsPreparedStatementParameter(sql, indexOfParameter)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " not present.");
        }
    }

    public void verifyPreparedStatementParameterPresent(int indexOfStatement, int indexOfParameter) {
        if (!this.containsPreparedStatementParameter(indexOfStatement, indexOfParameter)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " not present.");
        }
    }

    public void verifyPreparedStatementParameterNotPresent(PreparedStatement statement, int indexOfParameter) {
        if (this.containsPreparedStatementParameter(statement, indexOfParameter)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " present.");
        }
    }

    public void verifyPreparedStatementParameterNotPresent(String sql, int indexOfParameter) {
        if (this.containsPreparedStatementParameter(sql, indexOfParameter)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " present.");
        }
    }

    public void verifyPreparedStatementParameterNotPresent(int indexOfStatement, int indexOfParameter) {
        if (this.containsPreparedStatementParameter(indexOfStatement, indexOfParameter)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " present.");
        }
    }

    private boolean containsPreparedStatementParameter(int indexOfStatement, int indexOfParameter) {
        MockPreparedStatement statement = this.getPreparedStatement(indexOfStatement);
        if (null == statement) {
            return false;
        }
        return this.containsPreparedStatementParameter(statement, indexOfParameter);
    }

    private boolean containsPreparedStatementParameter(String sql, int indexOfParameter) {
        MockPreparedStatement statement = this.getPreparedStatement(sql);
        if (null == statement) {
            return false;
        }
        return this.containsPreparedStatementParameter(statement, indexOfParameter);
    }

    private boolean containsPreparedStatementParameter(PreparedStatement statement, int indexOfParameter) {
        return ((MockPreparedStatement)statement).getParameterMap().containsKey(new Integer(indexOfParameter));
    }

    public void verifyCallableStatementParameterPresent(CallableStatement statement, int indexOfParameter) {
        if (!this.containsCallableStatementParameter(statement, indexOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(String sql, int indexOfParameter) {
        if (!this.containsCallableStatementParameter(sql, indexOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(int indexOfStatement, int indexOfParameter) {
        if (!this.containsCallableStatementParameter(indexOfStatement, indexOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " not present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(CallableStatement statement, int indexOfParameter) {
        if (this.containsCallableStatementParameter(statement, indexOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(String sql, int indexOfParameter) {
        if (this.containsCallableStatementParameter(sql, indexOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(int indexOfStatement, int indexOfParameter) {
        if (this.containsCallableStatementParameter(indexOfStatement, indexOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " present.");
        }
    }

    public void verifyCallableStatementParameterPresent(CallableStatement statement, String nameOfParameter) {
        if (!this.containsCallableStatementParameter(statement, nameOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + nameOfParameter + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(String sql, String nameOfParameter) {
        if (!this.containsCallableStatementParameter(sql, nameOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + nameOfParameter + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(int indexOfStatement, String nameOfParameter) {
        if (!this.containsCallableStatementParameter(indexOfStatement, nameOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + nameOfParameter + " not present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(CallableStatement statement, String nameOfParameter) {
        if (this.containsCallableStatementParameter(statement, nameOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + nameOfParameter + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(String sql, String nameOfParameter) {
        if (this.containsCallableStatementParameter(sql, nameOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + nameOfParameter + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(int indexOfStatement, String nameOfParameter) {
        if (this.containsCallableStatementParameter(indexOfStatement, nameOfParameter)) {
            throw new VerifyFailedException("Callable statement parameter with index " + nameOfParameter + " present.");
        }
    }

    private boolean containsCallableStatementParameter(int indexOfStatement, int indexOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(indexOfStatement);
        if (null == statement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)statement, indexOfParameter);
    }

    private boolean containsCallableStatementParameter(String sql, int indexOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(sql);
        if (null == statement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)statement, indexOfParameter);
    }

    private boolean containsCallableStatementParameter(CallableStatement statement, int indexOfParameter) {
        return ((MockCallableStatement)statement).getParameterMap().containsKey(new Integer(indexOfParameter));
    }

    private boolean containsCallableStatementParameter(int indexOfStatement, String nameOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(indexOfStatement);
        if (null == statement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)statement, nameOfParameter);
    }

    private boolean containsCallableStatementParameter(String sql, String nameOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(sql);
        if (null == statement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)statement, nameOfParameter);
    }

    private boolean containsCallableStatementParameter(CallableStatement statement, String nameOfParameter) {
        return ((MockCallableStatement)statement).getParameterMap().containsKey(nameOfParameter);
    }

    public void verifyPreparedStatementParameter(PreparedStatement statement, int indexOfParameter, Object object) {
        this.verifyPreparedStatementParameterPresent(statement, indexOfParameter);
        Object actualObject = this.getPreparedStatementParameter(statement, indexOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyPreparedStatementParameter(String sql, int indexOfParameter, Object object) {
        this.verifyPreparedStatementParameterPresent(sql, indexOfParameter);
        Object actualObject = this.getPreparedStatementParameter(sql, indexOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyPreparedStatementParameter(int indexOfStatement, int indexOfParameter, Object object) {
        this.verifyPreparedStatementParameterPresent(indexOfStatement, indexOfParameter);
        Object actualObject = this.getPreparedStatementParameter(indexOfStatement, indexOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + indexOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementParameter(CallableStatement statement, int indexOfParameter, Object object) {
        this.verifyCallableStatementParameterPresent(statement, indexOfParameter);
        Object actualObject = this.getCallableStatementParameter(statement, indexOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementParameter(String sql, int indexOfParameter, Object object) {
        this.verifyCallableStatementParameterPresent(sql, indexOfParameter);
        Object actualObject = this.getCallableStatementParameter(sql, indexOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementParameter(int indexOfStatement, int indexOfParameter, Object object) {
        this.verifyCallableStatementParameterPresent(indexOfStatement, indexOfParameter);
        Object actualObject = this.getCallableStatementParameter(indexOfStatement, indexOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Callable statement parameter with index " + indexOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementParameter(CallableStatement statement, String nameOfParameter, Object object) {
        this.verifyCallableStatementParameterPresent(statement, nameOfParameter);
        Object actualObject = this.getCallableStatementParameter(statement, nameOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Callable statement parameter with name " + nameOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementParameter(String sql, String nameOfParameter, Object object) {
        this.verifyCallableStatementParameterPresent(sql, nameOfParameter);
        Object actualObject = this.getCallableStatementParameter(sql, nameOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Callable statement parameter with name " + nameOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementParameter(int indexOfStatement, String nameOfParameter, Object object) {
        this.verifyCallableStatementParameterPresent(indexOfStatement, nameOfParameter);
        Object actualObject = this.getCallableStatementParameter(indexOfStatement, nameOfParameter);
        if (!ParameterUtil.compareParameter(actualObject, object)) {
            throw new VerifyFailedException("Callable statement parameter with name " + nameOfParameter + " has the value " + String.valueOf(actualObject) + ", expected " + String.valueOf(object));
        }
    }

    public void verifyCallableStatementOutParameterRegistered(CallableStatement statement, int indexOfParameter) {
        if (!((MockCallableStatement)statement).isOutParameterRegistered(indexOfParameter)) {
            throw new VerifyFailedException("Out parameter with index " + indexOfParameter + " not registered in callable statement ");
        }
    }

    public void verifyCallableStatementOutParameterRegistered(String sql, int indexOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(sql);
        if (null == statement) {
            throw new VerifyFailedException("No callable statement " + sql + " present");
        }
        if (!statement.isOutParameterRegistered(indexOfParameter)) {
            throw new VerifyFailedException("Out parameter with index " + indexOfParameter + " not registered in callable statement " + sql);
        }
    }

    public void verifyCallableStatementOutParameterRegistered(int indexOfStatement, int indexOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(indexOfStatement);
        if (null == statement) {
            throw new VerifyFailedException("No callable statement with index " + indexOfStatement + " present");
        }
        if (!statement.isOutParameterRegistered(indexOfParameter)) {
            throw new VerifyFailedException("Out parameter with index " + indexOfParameter + " not registered in callable statement with index " + indexOfStatement);
        }
    }

    public void verifyCallableStatementOutParameterRegistered(CallableStatement statement, String nameOfParameter) {
        if (!((MockCallableStatement)statement).isOutParameterRegistered(nameOfParameter)) {
            throw new VerifyFailedException("Out parameter with name " + nameOfParameter + " not registered in callable statement ");
        }
    }

    public void verifyCallableStatementOutParameterRegistered(String sql, String nameOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(sql);
        if (null == statement) {
            throw new VerifyFailedException("No callable statement " + sql + " present");
        }
        if (!statement.isOutParameterRegistered(nameOfParameter)) {
            throw new VerifyFailedException("Out parameter with name " + nameOfParameter + " not registered in callable statement " + sql);
        }
    }

    public void verifyCallableStatementOutParameterRegistered(int indexOfStatement, String nameOfParameter) {
        MockCallableStatement statement = this.getCallableStatement(indexOfStatement);
        if (null == statement) {
            throw new VerifyFailedException("No callable statement with index " + indexOfStatement + " present");
        }
        if (!statement.isOutParameterRegistered(nameOfParameter)) {
            throw new VerifyFailedException("Out parameter with name " + nameOfParameter + " not registered in callable statement with index " + indexOfStatement);
        }
    }

    public void verifySavepointPresent(int index) {
        MockSavepoint savepoint = this.getSavepoint(index);
        if (null == savepoint) {
            throw new VerifyFailedException("No savepoint with index " + index + " present.");
        }
    }

    public void verifySavepointPresent(String name) {
        MockSavepoint savepoint = this.getSavepoint(name);
        if (null == savepoint) {
            throw new VerifyFailedException("No savepoint with name " + name + " present.");
        }
    }

    public void verifySavepointReleased(int index) {
        this.verifySavepointPresent(index);
        if (!this.getSavepoint(index).isReleased()) {
            throw new VerifyFailedException("Savepoint with index " + index + " not released.");
        }
    }

    public void verifySavepointReleased(String name) {
        this.verifySavepointPresent(name);
        if (!this.getSavepoint(name).isReleased()) {
            throw new VerifyFailedException("Savepoint with name " + name + " not released.");
        }
    }

    public void verifySavepointNotReleased(int index) {
        this.verifySavepointPresent(index);
        if (this.getSavepoint(index).isReleased()) {
            throw new VerifyFailedException("Savepoint with index " + index + " is released.");
        }
    }

    public void verifySavepointNotReleased(String name) {
        this.verifySavepointPresent(name);
        if (this.getSavepoint(name).isReleased()) {
            throw new VerifyFailedException("Savepoint with name " + name + " is released.");
        }
    }

    public void verifySavepointRolledBack(int index) {
        this.verifySavepointPresent(index);
        if (!this.getSavepoint(index).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with index " + index + " not rolled back.");
        }
    }

    public void verifySavepointRolledBack(String name) {
        this.verifySavepointPresent(name);
        if (!this.getSavepoint(name).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with name " + name + " not rolled back.");
        }
    }

    public void verifySavepointNotRolledBack(int index) {
        this.verifySavepointPresent(index);
        if (this.getSavepoint(index).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with index " + index + " is rolled back.");
        }
    }

    public void verifySavepointNotRolledBack(String name) {
        this.verifySavepointPresent(name);
        if (this.getSavepoint(name).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with name " + name + " is rolled back.");
        }
    }

    public void verifySavepointRollbacked(int index) {
        this.verifySavepointRolledBack(index);
    }

    public void verifySavepointRollbacked(String name) {
        this.verifySavepointRolledBack(name);
    }

    public void verifySavepointNotRollbacked(int index) {
        this.verifySavepointNotRolledBack(index);
    }

    public void verifySavepointNotRollbacked(String name) {
        this.verifySavepointNotRolledBack(name);
    }
}

