/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import com.mycila.maven.plugin.license.HeaderSection;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.util.FileUtils;
import com.mycila.maven.plugin.license.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Header {
    private final URL location;
    private final String headerContent;
    private final String headerContentOneLine;
    private String[] lines;
    private final HeaderSection[] sections;

    public Header(URL location, String encoding, HeaderSection[] sections) {
        if (location == null) {
            throw new IllegalArgumentException("Cannot read license template header file with a null location");
        }
        this.location = location;
        this.sections = sections;
        try {
            this.headerContent = FileUtils.read(location, encoding);
            this.lines = this.headerContent.replace("\r", "").split("\n");
            this.headerContentOneLine = FileUtils.remove(this.headerContent, " ", "\t", "\r", "\n");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read header document " + location + ". Cause: " + e.getMessage(), e);
        }
    }

    public String asString() {
        return this.headerContent;
    }

    public String asOneLineString() {
        return this.headerContentOneLine;
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public URL getLocation() {
        return this.location;
    }

    public String eol(boolean unix) {
        return unix ? "\n" : "\r\n";
    }

    public String buildForDefinition(HeaderDefinition type, boolean unix) {
        StringBuilder newHeader = new StringBuilder();
        if (this.notEmpty(type.getFirstLine())) {
            newHeader.append(type.getFirstLine().replace("EOL", this.eol(unix)));
            newHeader.append(this.eol(unix));
        }
        String[] stringArray = this.getLines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String str = String.valueOf(type.getBeforeEachLine().replace("EOL", this.eol(unix))) + line;
            newHeader.append(StringUtils.rtrim(str));
            newHeader.append(this.eol(unix));
            ++n2;
        }
        if (this.notEmpty(type.getEndLine())) {
            newHeader.append(type.getEndLine().replace("EOL", this.eol(unix)));
            newHeader.append(this.eol(unix));
        }
        return newHeader.toString();
    }

    public String toString() {
        return this.asString();
    }

    public String[] getLines() {
        return this.lines;
    }

    public boolean isMatchForText(String potentialFileHeader, HeaderDefinition headerDefinition, boolean unix) {
        String expected = this.buildForDefinition(headerDefinition, unix);
        return this.isMatchForText(expected, potentialFileHeader, headerDefinition, unix);
    }

    public boolean isMatchForText(String expected, String potentialFileHeader, HeaderDefinition headerDefinition, boolean unix) {
        SortedMap<Integer, HeaderSection> sectionsByIndex = this.computeSectionsByIndex(expected);
        if (sectionsByIndex.isEmpty()) {
            return potentialFileHeader.contains(expected);
        }
        List<String> textBetweenSections = this.buildExpectedTextBetweenSections(expected, sectionsByIndex);
        ArrayList<HeaderSection> sectionsInOrder = new ArrayList<HeaderSection>(sectionsByIndex.values());
        return this.recursivelyFindMatch(potentialFileHeader, headerDefinition, textBetweenSections, sectionsInOrder, 0, 0);
    }

    public boolean isMatchForText(Document d, HeaderDefinition headerDefinition, boolean unix, String encoding) throws IOException {
        String fileHeader = FileUtils.readFirstLines(d.getFile(), this.getLineCount() + 10, encoding).replaceAll(" *\r?\n", "\n");
        String expected = this.buildForDefinition(headerDefinition, unix);
        expected = d.mergeProperties(expected);
        return this.isMatchForText(expected, fileHeader, headerDefinition, unix);
    }

    public String applyDefinitionAndSections(HeaderDefinition headerDefinition, boolean unix) {
        String expected = this.buildForDefinition(headerDefinition, unix);
        SortedMap<Integer, HeaderSection> sectionsByIndex = this.computeSectionsByIndex(expected);
        if (sectionsByIndex.isEmpty()) {
            return expected;
        }
        List<String> textBetweenSections = this.buildExpectedTextBetweenSections(expected, sectionsByIndex);
        ArrayList<HeaderSection> sectionsInOrder = new ArrayList<HeaderSection>(sectionsByIndex.values());
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < textBetweenSections.size()) {
            HeaderSection section;
            String sectionValue;
            String textBetween = textBetweenSections.get(i);
            b.append(textBetween);
            if (i < sectionsInOrder.size() && this.notEmpty(sectionValue = (section = (HeaderSection)sectionsInOrder.get(i)).getDefaultValue())) {
                String[] tokens = sectionValue.split(this.eol(unix));
                int j = 0;
                while (j < tokens.length) {
                    if (j > 0) {
                        b.append(this.eol(unix));
                        if (this.notEmpty(headerDefinition.getBeforeEachLine())) {
                            b.append(headerDefinition.getBeforeEachLine());
                        }
                    }
                    b.append(tokens[j]);
                    ++j;
                }
            }
            ++i;
        }
        return b.toString();
    }

    private boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private SortedMap<Integer, HeaderSection> computeSectionsByIndex(String expectedHeaderText) {
        TreeMap<Integer, HeaderSection> sectionsByIndex = new TreeMap<Integer, HeaderSection>();
        if (this.sections == null) {
            return sectionsByIndex;
        }
        HeaderSection[] headerSectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderSection section = headerSectionArray[n2];
            String key = section.getKey();
            int index = expectedHeaderText.indexOf(key);
            if (index != -1) {
                int indexEnd = index + section.getKey().length();
                for (Map.Entry entry : sectionsByIndex.entrySet()) {
                    int existingIndexStart = (Integer)entry.getKey();
                    HeaderSection existingSection = (HeaderSection)entry.getValue();
                    int existingIndexEnd = existingIndexStart + existingSection.getKey().length();
                    if (existingIndexStart < indexEnd && index < existingIndexEnd) {
                        throw new IllegalArgumentException(String.format("Existing section '%1$s' overlaps with new section '%2$s'", existingSection.getKey(), section.getKey()));
                    }
                    sectionsByIndex.put(index, section);
                }
                sectionsByIndex.put(index, section);
            }
            ++n2;
        }
        return sectionsByIndex;
    }

    private List<String> buildExpectedTextBetweenSections(String expectedHeaderText, SortedMap<Integer, HeaderSection> sectionsByIndex) {
        ArrayList<String> textBetweenSections = new ArrayList<String>();
        int currentIndex = 0;
        for (Map.Entry<Integer, HeaderSection> entry : sectionsByIndex.entrySet()) {
            int index = entry.getKey();
            HeaderSection section = entry.getValue();
            String textBetween = expectedHeaderText.substring(currentIndex, index);
            textBetweenSections.add(textBetween);
            currentIndex = index + section.getKey().length();
        }
        String textBetween = expectedHeaderText.substring(currentIndex, expectedHeaderText.length());
        textBetweenSections.add(textBetween);
        return textBetweenSections;
    }

    private boolean recursivelyFindMatch(String potentialFileHeader, HeaderDefinition headerDefinition, List<String> expectedTextBetweenSections, List<HeaderSection> sectionsInOrder, int currentTextSegmentIndex, int currentPotentialFileHeaderIndex) {
        if (currentTextSegmentIndex == expectedTextBetweenSections.size()) {
            return true;
        }
        int currentSearchFromIndex = currentPotentialFileHeaderIndex;
        String expectedText;
        int index;
        while ((index = potentialFileHeader.indexOf(expectedText = expectedTextBetweenSections.get(currentTextSegmentIndex), currentSearchFromIndex)) != -1) {
            String sectionValue;
            HeaderSection section;
            if (currentTextSegmentIndex > 0 && !this.ensureSectionMatch(headerDefinition, section = sectionsInOrder.get(currentTextSegmentIndex - 1), sectionValue = potentialFileHeader.substring(currentPotentialFileHeaderIndex, index))) {
                return false;
            }
            if (this.recursivelyFindMatch(potentialFileHeader, headerDefinition, expectedTextBetweenSections, sectionsInOrder, currentTextSegmentIndex + 1, index + expectedText.length())) {
                return true;
            }
            currentSearchFromIndex = index + 1;
        }
        return false;
    }

    private boolean ensureSectionMatch(HeaderDefinition headerDefinition, HeaderSection section, String sectionValue) {
        String match = section.getEnsureMatch();
        if (!this.notEmpty(match)) {
            return true;
        }
        String[] lines = sectionValue.split("\n");
        String before = headerDefinition.getBeforeEachLine();
        if (this.notEmpty(before)) {
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line.startsWith(before)) {
                    lines[i] = line.substring(before.length());
                }
                ++i;
            }
        }
        if (section.isMultiLineMatch()) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < lines.length) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append(lines[i]);
                ++i;
            }
            String multiLineValue = b.toString();
            return multiLineValue.matches(match);
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.matches(match)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

