/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import com.mycila.maven.plugin.license.header.HeaderDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum HeaderType {
    JAVADOC_STYLE("/**", " * ", " */", null, "(\\s|\\t)*/\\*.*$", ".*\\*/(\\s|\\t)*$", false, true),
    SCRIPT_STYLE("#", "# ", "#EOL", "^#!.*$", "#.*$", "#.*$", false, false),
    HAML_STYLE("-#", "-# ", "-#EOL", "^-#!.*$", "-#.*$", "-#.*$", false, false),
    XML_STYLE("<!--EOL", "    ", "EOL-->", "^<\\?xml.*>$", "(\\s|\\t)*<!--.*$", ".*-->(\\s|\\t)*$", true, true),
    SEMICOLON_STYLE(";", "; ", ";EOL", null, ";.*$", ";.*$", false, false),
    APOSTROPHE_STYLE("'", "' ", "'EOL", null, "'.*$", "'.*$", false, false),
    EXCLAMATION_STYLE("!", "! ", "!EOL", null, "!.*$", "!.*$", false, false),
    DOUBLEDASHES_STYLE("--", "-- ", "--EOL", null, "--.*$", "--.*$", false, false),
    SLASHSTAR_STYLE("/*", " * ", " */", null, "(\\s|\\t)*/\\*.*$", ".*\\*/(\\s|\\t)*$", false, true),
    BRACESSTAR_STYLE("\\{*", " * ", " *\\}", null, "(\\s|\\t)*\\{\\*.*$", ".*\\*\\}(\\s|\\t)*$", false, true),
    SHARPSTAR_STYLE("#*", " * ", " *#", null, "(\\s|\\t)*#\\*.*$", ".*\\*#(\\s|\\t)*$", false, true),
    DOUBLETILDE_STYLE("~~", "~~ ", "~~EOL", null, "~~.*$", "~~.*$", false, false),
    DYNASCRIPT_STYLE("<%--EOL", "    ", "EOL--%>", null, "(\\s|\\t)*<%--.*$", ".*--%>(\\s|\\t)*$", true, true),
    DYNASCRIPT3_STYLE("<!---EOL", "    ", "EOL--->", null, "(\\s|\\t)*<!---.*$", ".*--->(\\s|\\t)*$", true, true),
    PERCENT3_STYLE("%%%", "%%% ", "%%%EOL", null, "%%%.*$", "%%%.*$", false, false),
    EXCLAMATION3_STYLE("!!!", "!!! ", "!!!EOL", null, "!!!.*$", "!!!.*$", false, false),
    DOUBLESLASH_STYLE("//", "// ", "//EOL", null, "//.*$", "//.*$", false, false),
    PHP("/*", " * ", " */", "^<\\?php.*$", "(\\s|\\t)*/\\*.*$", ".*\\*/(\\s|\\t)*$", false, true),
    ASP("<%", "    ", "%>", null, "(\\s|\\t)*<%[^@].*$", ".*%>(\\s|\\t)*$", true, true),
    LUA("--[[EOL", "    ", "EOL]]", null, "--\\[\\[$", "\\]\\]$", true, true),
    FTL("<#--EOL", "    ", "EOL-->", null, "(\\s|\\t)*<#--.*$", ".*-->(\\s|\\t)*$", true, true),
    FTL_ALT("[#--EOL", "    ", "EOL--]", "\\[#ftl(\\s.*)?\\]", "(\\s|\\t)*\\[#--.*$", ".*--\\](\\s|\\t)*$", true, true),
    TEXT("====", "    ", "====EOL", null, "====.*$", "====.*$", true, true),
    BATCH("@REM", "@REM ", "@REMEOL", null, "@REM.*$", "@REM.*$", false, false),
    UNKNOWN("", "", "", null, null, null, false, false);

    private static final Map<String, HeaderDefinition> DEFINITIONS;
    private final HeaderDefinition definition;

    static {
        DEFINITIONS = new HashMap<String, HeaderDefinition>(HeaderType.values().length);
        HeaderType[] headerTypeArray = HeaderType.values();
        int n = headerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderType type = headerTypeArray[n2];
            DEFINITIONS.put(type.getDefinition().getType(), type.getDefinition());
            ++n2;
        }
    }

    private HeaderType(String firstLine, String beforeEachLine, String endLine, String skipLinePattern, String firstLineDetectionPattern, String endLineDetectionPattern, boolean allowBlankLines, boolean isMultiline) {
        this.definition = new HeaderDefinition(this.name().toLowerCase(), firstLine, beforeEachLine, endLine, skipLinePattern, firstLineDetectionPattern, endLineDetectionPattern, allowBlankLines, isMultiline);
    }

    public HeaderDefinition getDefinition() {
        return this.definition;
    }

    public static HeaderType fromName(String name) {
        HeaderType[] headerTypeArray = HeaderType.values();
        int n = headerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderType type = headerTypeArray[n2];
            if (type.name().equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static Map<String, HeaderDefinition> defaultDefinitions() {
        return Collections.unmodifiableMap(DEFINITIONS);
    }
}

