/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.velocity;

import com.nativelibs4java.velocity.MavenLogChute;
import com.nativelibs4java.velocity.Primitive;
import com.nativelibs4java.velocity.Utils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityMojo
extends AbstractMojo {
    private Map<String, String> properties;
    private File sourcePathRoot;
    private File velocitySources;
    private File velocityTestSources;
    private File sourcesOutputDirectory;
    private File testSourcesOutputDirectory;
    private File resourcesOutputDirectory;
    private File testResourcesOutputDirectory;
    private MavenProject project;

    static void listVeloFiles(File f, Collection<File> out) throws IOException {
        if (f.isHidden()) {
            return;
        }
        String n = f.getName().toLowerCase();
        if (f.isDirectory()) {
            if (n.equals(".svn") || n.equals("CVS")) {
                return;
            }
            for (File ff : f.listFiles()) {
                VelocityMojo.listVeloFiles(ff.getAbsoluteFile(), out);
            }
        } else if (f.isFile() && !n.startsWith(".")) {
            out.add(f);
        }
    }

    public File getOutputFile(File vmFile, File velocitySources, File outputDirectory) throws IOException {
        String canoRoot = velocitySources.getCanonicalPath();
        String abs = vmFile.getCanonicalPath();
        String rel = abs.substring(canoRoot.length());
        String relLow = rel.toLowerCase();
        for (String suf : new String[]{".vm", ".velo", ".velocity"}) {
            if (!relLow.endsWith(suf)) continue;
            rel = rel.substring(0, rel.length() - suf.length());
            break;
        }
        int i = rel.lastIndexOf(46);
        File out = outputDirectory;
        return new File(out.getCanonicalPath() + rel);
    }

    public void execute() throws MojoExecutionException {
        Resource res;
        if (this.executeAll(this.velocitySources, false)) {
            this.project.addCompileSourceRoot(this.sourcesOutputDirectory.toString());
            res = new Resource();
            res.setDirectory(this.resourcesOutputDirectory.getAbsolutePath());
            this.project.addResource(res);
        }
        if (this.executeAll(this.velocityTestSources, true)) {
            this.project.addTestCompileSourceRoot(this.testSourcesOutputDirectory.toString());
            res = new Resource();
            res.setDirectory(this.testResourcesOutputDirectory.getAbsolutePath());
            this.project.addTestResource(res);
        }
    }

    private VelocityEngine createEngine(String canoPath) throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("runtime.log.logsystem", (Object)new MavenLogChute(this.getLog()));
        ve.setProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)"true");
        ve.setProperty("velocimacro.permissions.allow.inline.local.scope", (Object)"false");
        ve.setProperty("velocimacro.context.localscope", (Object)"false");
        ve.setProperty("file.resource.loader.path", (Object)canoPath);
        ve.init();
        return ve;
    }

    private boolean executeAll(File velocitySources, boolean isTest) throws MojoExecutionException {
        String canoPath;
        ArrayList<File> files = new ArrayList<File>();
        try {
            velocitySources = velocitySources.getCanonicalFile();
            VelocityMojo.listVeloFiles(velocitySources, files);
            canoPath = this.sourcePathRoot.getCanonicalPath();
            this.getLog().info((CharSequence)("Velocity root path = " + canoPath));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to list files from '" + velocitySources + "'", ex);
        }
        this.getLog().info((CharSequence)("Found " + files.size() + " files in '" + velocitySources + "'..."));
        this.getLog().info((CharSequence)("Got Maven properties : " + this.project.getProperties()));
        this.getLog().info((CharSequence)("Got properties : " + this.properties));
        if (files.isEmpty()) {
            return false;
        }
        for (File file : files) {
            try {
                String propValue;
                String propName;
                boolean isSource;
                file = file.getCanonicalFile();
                String name = file.getName();
                if (name.endsWith("~") || name.endsWith(".bak")) {
                    this.getLog().info((CharSequence)("Skipping: '" + name + "'"));
                    continue;
                }
                String lowName = name.toLowerCase();
                boolean bl = isSource = name.endsWith(".java") || name.endsWith(".scala");
                File outputDirectory = isSource ? (isTest ? this.testSourcesOutputDirectory : this.sourcesOutputDirectory) : (isTest ? this.testResourcesOutputDirectory : this.resourcesOutputDirectory);
                File outFile = this.getOutputFile(file, velocitySources, outputDirectory);
                if (outFile.exists() && outFile.lastModified() > file.lastModified()) {
                    this.getLog().info((CharSequence)("Up-to-date: '" + name + "'"));
                    continue;
                }
                this.getLog().info((CharSequence)("Executing template '" + name + "'..."));
                String cano = file.getCanonicalPath();
                cano = cano.substring(canoPath.length());
                if (cano.startsWith(File.separator)) {
                    cano = cano.substring(File.separator.length());
                }
                VelocityEngine ve = this.createEngine(canoPath);
                VelocityContext context = new VelocityContext();
                context.put("primitives", Primitive.getPrimitives());
                context.put("primitivesNoBool", Primitive.getPrimitivesNoBool());
                context.put("bridJPrimitives", Primitive.getBridJPrimitives());
                context.put("pom", (Object)this.project);
                for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                    propName = ((String)entry.getKey()).replace('.', '_');
                    propValue = (String)entry.getValue();
                    this.getLog().debug((CharSequence)("Got property : " + propName + " = " + propValue));
                    context.put(propName, (Object)propValue);
                }
                if (this.properties != null) {
                    for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                        propName = (String)entry.getKey();
                        propValue = (String)entry.getValue();
                        this.getLog().debug((CharSequence)("Got property : " + propName + " = " + propValue));
                        context.put(propName, (Object)propValue);
                    }
                }
                StringWriter out = new StringWriter();
                boolean bl2 = true;
                if (bl2) {
                    String source = Utils.readTextFile(file);
                    String quoted = Utils.quoteSharpsInComments(source);
                    ve.evaluate((Context)context, (Writer)out, "velocity", quoted);
                } else {
                    Template template = ve.getTemplate(cano);
                    template.merge((Context)context, (Writer)out);
                }
                out.close();
                outFile.getParentFile().mkdirs();
                String transformed = out.toString();
                Utils.writeTextFile(outFile, transformed);
            }
            catch (Exception ex) {
                new MojoExecutionException("Failed to execute template '" + file + "'", ex).printStackTrace();
            }
        }
        return true;
    }
}

