/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.context;

import com.nepxion.discovery.plugin.framework.context.PluginApplicationContextInitializer;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.decorator.EurekaServiceRegistryDecorator;
import com.nepxion.discovery.plugin.framework.util.MetadataUtil;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EurekaApplicationContextInitializer
extends PluginApplicationContextInitializer {
    protected Object afterInitialization(ConfigurableApplicationContext applicationContext, Object bean, String beanName) throws BeansException {
        if (bean instanceof EurekaServiceRegistry) {
            EurekaServiceRegistry eurekaServiceRegistry = (EurekaServiceRegistry)bean;
            return new EurekaServiceRegistryDecorator(eurekaServiceRegistry, applicationContext);
        }
        if (bean instanceof EurekaInstanceConfigBean) {
            ConfigurableEnvironment environment = applicationContext.getEnvironment();
            EurekaInstanceConfigBean eurekaInstanceConfig = (EurekaInstanceConfigBean)bean;
            eurekaInstanceConfig.setPreferIpAddress(true);
            Map metadataMap = eurekaInstanceConfig.getMetadataMap();
            metadataMap.put("spring.application.discovery.plugin", "Eureka Plugin");
            metadataMap.put("spring.application.discovery.version", "4.8.4.1");
            metadataMap.put("spring.application.register.control.enabled", PluginContextAware.isRegisterControlEnabled((Environment)environment).toString());
            metadataMap.put("spring.application.discovery.control.enabled", PluginContextAware.isDiscoveryControlEnabled((Environment)environment).toString());
            metadataMap.put("spring.application.config.rest.control.enabled", PluginContextAware.isConfigRestControlEnabled((Environment)environment).toString());
            metadataMap.put("spring.application.group.key", PluginContextAware.getGroupKey((Environment)environment));
            metadataMap.put("spring.application.context-path", PluginContextAware.getContextPath((Environment)environment));
            MetadataUtil.filter((Map)metadataMap);
            return bean;
        }
        return bean;
    }
}

