/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.LoadBalanceListenerExecutor;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.List;
import org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServerList;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EurekaServerListDecorator
extends DomainExtractingServerList {
    private ConfigurableEnvironment environment;
    private LoadBalanceListenerExecutor loadBalanceListenerExecutor;
    private String serviceId;

    public EurekaServerListDecorator(ServerList<DiscoveryEnabledServer> list, IClientConfig clientConfig, boolean approximateZoneFromHostname) {
        super(list, clientConfig, approximateZoneFromHostname);
    }

    public List<DiscoveryEnabledServer> getInitialListOfServers() {
        List servers = super.getInitialListOfServers();
        this.filter(servers);
        return servers;
    }

    public List<DiscoveryEnabledServer> getUpdatedListOfServers() {
        List servers = super.getUpdatedListOfServers();
        this.filter(servers);
        return servers;
    }

    private void filter(List<DiscoveryEnabledServer> servers) {
        Boolean discoveryControlEnabled = PluginContextAware.isDiscoveryControlEnabled((Environment)this.environment);
        if (discoveryControlEnabled.booleanValue()) {
            this.loadBalanceListenerExecutor.onGetServers(this.serviceId, servers);
        }
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setLoadBalanceListenerExecutor(LoadBalanceListenerExecutor loadBalanceListenerExecutor) {
        this.loadBalanceListenerExecutor = loadBalanceListenerExecutor;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }
}

