/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.context;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;

public class PluginContextAware
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Environment environment;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
    }

    public Object getBean(String name) throws BeansException {
        return this.applicationContext.getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.applicationContext.getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.applicationContext.getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.applicationContext.getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return (T)this.applicationContext.getBean(requiredType, args);
    }

    public boolean containsBean(String name) {
        return this.applicationContext.containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isPrototype(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isTypeMatch(name, typeToMatch);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.applicationContext.getType(name);
    }

    public String[] getAliases(String name) {
        return this.applicationContext.getAliases(name);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Boolean isRegisterControlEnabled() {
        return PluginContextAware.isRegisterControlEnabled(this.environment);
    }

    public Boolean isDiscoveryControlEnabled() {
        return PluginContextAware.isDiscoveryControlEnabled(this.environment);
    }

    public Boolean isConfigRestControlEnabled() {
        return PluginContextAware.isConfigRestControlEnabled(this.environment);
    }

    public String getConfigFormat() {
        return PluginContextAware.getConfigFormat(this.environment);
    }

    public String getConfigPath() {
        return PluginContextAware.getConfigPath(this.environment);
    }

    public String getGroupKey() {
        return PluginContextAware.getGroupKey(this.environment);
    }

    public String getContextPath() {
        return PluginContextAware.getContextPath(this.environment);
    }

    public static Boolean isRegisterControlEnabled(Environment environment) {
        return (Boolean)environment.getProperty("spring.application.register.control.enabled", Boolean.class, (Object)Boolean.TRUE);
    }

    public static Boolean isDiscoveryControlEnabled(Environment environment) {
        return (Boolean)environment.getProperty("spring.application.discovery.control.enabled", Boolean.class, (Object)Boolean.TRUE);
    }

    public static Boolean isConfigRestControlEnabled(Environment environment) {
        return (Boolean)environment.getProperty("spring.application.config.rest.control.enabled", Boolean.class, (Object)Boolean.TRUE);
    }

    public static String getConfigFormat(Environment environment) {
        return (String)environment.getProperty("spring.application.config.format", String.class, (Object)"xml");
    }

    public static String getConfigPath(Environment environment) {
        return (String)environment.getProperty("spring.application.config.path", String.class, (Object)(StringUtils.equals((CharSequence)PluginContextAware.getConfigFormat(environment), (CharSequence)"xml") ? "classpath:rule.xml" : "classpath:rule.json"));
    }

    public static String getGroupKey(Environment environment) {
        return (String)environment.getProperty("spring.application.group.key", String.class, (Object)"group");
    }

    public static String getContextPath(Environment environment) {
        return (String)environment.getProperty("spring.application.context-path", String.class, (Object)"/");
    }
}

