/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.register;

import com.nepxion.discovery.common.entity.CountFilterEntity;
import com.nepxion.discovery.common.entity.RegisterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.decorator.DiscoveryClientDecorator;
import com.nepxion.discovery.plugin.framework.event.RegisterFailureEvent;
import com.nepxion.discovery.plugin.framework.listener.register.AbstractRegisterListener;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;

public class CountFilterRegisterListener
extends AbstractRegisterListener {
    @Autowired
    private DiscoveryClientDecorator discoveryClient;

    @Override
    public void onRegister(Registration registration) {
        String serviceId = registration.getServiceId().toLowerCase();
        String host = registration.getHost();
        int port = registration.getPort();
        this.applyCountFilter(serviceId, host, port);
    }

    private void applyCountFilter(String serviceId, String host, int port) {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        RegisterEntity registerEntity = ruleEntity.getRegisterEntity();
        if (registerEntity == null) {
            return;
        }
        CountFilterEntity countFilterEntity = registerEntity.getCountFilterEntity();
        if (countFilterEntity == null) {
            return;
        }
        Integer globalFilterValue = countFilterEntity.getFilterValue();
        Map filterMap = countFilterEntity.getFilterMap();
        Integer filterValue = (Integer)filterMap.get(serviceId);
        Integer maxCount = null;
        maxCount = filterValue != null ? filterValue : globalFilterValue;
        if (maxCount == null) {
            return;
        }
        int count = this.discoveryClient.getRealInstances(serviceId).size();
        if (count >= maxCount) {
            this.onRegisterFailure(maxCount, serviceId, host, port);
        }
    }

    private void onRegisterFailure(int maxCount, String serviceId, String host, int port) {
        String description = serviceId + " for " + host + ":" + port + " isn't allowed to register to Register server, reach max limited count=" + maxCount;
        this.pluginEventWapper.fireRegisterFailure(new RegisterFailureEvent("reach max limited count", description, serviceId, host, port));
        throw new DiscoveryException(description);
    }

    @Override
    public void onDeregister(Registration registration) {
    }

    @Override
    public void onSetStatus(Registration registration, String status) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

