/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.rule;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledAdapter;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidancePredicate;
import java.util.Map;

public class DiscoveryEnabledZoneAvoidancePredicate
extends ZoneAvoidancePredicate {
    protected PluginAdapter pluginAdapter;
    protected DiscoveryEnabledAdapter discoveryEnabledAdapter;

    public DiscoveryEnabledZoneAvoidancePredicate(IRule rule, IClientConfig clientConfig) {
        super(rule, clientConfig);
    }

    public DiscoveryEnabledZoneAvoidancePredicate(LoadBalancerStats lbStats, IClientConfig clientConfig) {
        super(lbStats, clientConfig);
    }

    public boolean apply(PredicateKey input) {
        boolean enabled = super.apply(input);
        if (!enabled) {
            return false;
        }
        return this.apply(input.getServer());
    }

    protected boolean apply(Server server) {
        if (this.discoveryEnabledAdapter == null) {
            return true;
        }
        Map metadata = this.pluginAdapter.getServerMetadata(server);
        return this.discoveryEnabledAdapter.apply(server, metadata);
    }

    public void setPluginAdapter(PluginAdapter pluginAdapter) {
        this.pluginAdapter = pluginAdapter;
    }

    public void setDiscoveryEnabledAdapter(DiscoveryEnabledAdapter discoveryEnabledAdapter) {
        this.discoveryEnabledAdapter = discoveryEnabledAdapter;
    }
}

