/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.transport;

import com.netflix.eureka.EurekaServerConfig;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.io.IOException;

public class Jersey3DynamicGZIPContentEncodingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private final EurekaServerConfig config;

    public Jersey3DynamicGZIPContentEncodingFilter(EurekaServerConfig config) {
        this.config = config;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Object contentEncoding;
        if (!requestContext.getHeaders().containsKey((Object)"Accept-Encoding")) {
            requestContext.getHeaders().add((Object)"Accept-Encoding", (Object)"gzip");
        }
        if (this.hasEntity(requestContext) && this.isCompressionEnabled() && !"gzip".equals(contentEncoding = requestContext.getHeaders().getFirst((Object)"Content-Encoding"))) {
            requestContext.getHeaders().add((Object)"Content-Encoding", (Object)"gzip");
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Object contentEncoding = responseContext.getHeaders().getFirst((Object)"Content-Encoding");
        if ("gzip".equals(contentEncoding)) {
            responseContext.getHeaders().remove((Object)"Content-Encoding");
        }
    }

    private boolean hasEntity(ClientRequestContext requestContext) {
        return false;
    }

    private boolean isCompressionEnabled() {
        return this.config.shouldEnableReplicatedRequestCompression();
    }
}

