/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsAsgUtil {
    private final Logger logger = LoggerFactory.getLogger(AwsAsgUtil.class);
    private static final String PROP_ADD_TO_LOAD_BALANCER = "AddToLoadBalancer";
    private static final EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final AmazonAutoScaling client = AwsAsgUtil.getAmazonAutoScalingClient();
    private final LoadingCache<String, Boolean> asgCache = CacheBuilder.newBuilder().initialCapacity(500).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Boolean>(){

        public Boolean load(String key) throws Exception {
            return AwsAsgUtil.this.isASGEnabledinAWS(key);
        }
    });
    private final java.util.Timer timer = new java.util.Timer("Eureka-ASGCacheRefresh", true);
    private final Timer loadASGInfoTimer = Monitors.newTimer((String)"Eureka-loadASGInfo");
    private static final AwsAsgUtil awsAsgUtil = new AwsAsgUtil();

    private AwsAsgUtil() {
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        client.setEndpoint("autoscaling." + region + ".amazonaws.com");
        this.timer.schedule(this.getASGUpdateTask(), eurekaConfig.getASGUpdateIntervalMs(), eurekaConfig.getASGUpdateIntervalMs());
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            this.logger.warn("Cannot register the JMX monitor :", e);
        }
    }

    public static AwsAsgUtil getInstance() {
        return awsAsgUtil;
    }

    public boolean isASGEnabled(String asgName) {
        try {
            return (Boolean)this.asgCache.get((Object)asgName);
        }
        catch (ExecutionException e) {
            this.logger.error("Error getting cache value for asg : " + asgName, (Throwable)e);
            return true;
        }
    }

    public void setStatus(String asgName, boolean enabled) {
        this.asgCache.put((Object)asgName, (Object)enabled);
    }

    private boolean isAddToLoadBalancerSuspended(String asgName) {
        AutoScalingGroup asg = this.retrieveAutoScalingGroup(asgName);
        if (asg == null) {
            this.logger.warn("The ASG information for {} could not be found. So returning false.", (Object)asgName);
            return false;
        }
        return this.isAddToLoadBalancerSuspended(asg);
    }

    private boolean isAddToLoadBalancerSuspended(AutoScalingGroup asg) {
        List suspendedProcesses = asg.getSuspendedProcesses();
        for (SuspendedProcess process : suspendedProcesses) {
            if (!PROP_ADD_TO_LOAD_BALANCER.equals(process.getProcessName())) continue;
            return true;
        }
        return false;
    }

    private AutoScalingGroup retrieveAutoScalingGroup(String asgName) {
        DescribeAutoScalingGroupsRequest request = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{asgName});
        DescribeAutoScalingGroupsResult result = client.describeAutoScalingGroups(request);
        List asgs = result.getAutoScalingGroups();
        if (asgs.isEmpty()) {
            return null;
        }
        return (AutoScalingGroup)asgs.get(0);
    }

    private Boolean isASGEnabledinAWS(Object key) {
        String myKey = (String)key;
        try {
            Stopwatch t = this.loadASGInfoTimer.start();
            boolean returnValue = !this.isAddToLoadBalancerSuspended(myKey);
            t.stop();
            return returnValue;
        }
        catch (Throwable e) {
            this.logger.error("Could not get ASG information from AWS: ", e);
            return Boolean.TRUE;
        }
    }

    @Monitor(name="numOfElementsinASGCache", description="Number of elements in the ASG Cache", type=DataSourceType.GAUGE)
    public long getNumberofElementsinASGCache() {
        return this.asgCache.size();
    }

    @Monitor(name="numOfASGQueries", description="Number of queries made to AWS to retrieve ASG information", type=DataSourceType.COUNTER)
    public long getNumberofASGQueries() {
        return this.asgCache.stats().loadCount();
    }

    @Monitor(name="numOfASGQueryFailures", description="Number of queries made to AWS to retrieve ASG information and that failed", type=DataSourceType.COUNTER)
    public long getNumberofASGQueryFailures() {
        return this.asgCache.stats().loadExceptionCount();
    }

    private TimerTask getASGUpdateTask() {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    Set asgNames = AwsAsgUtil.this.getASGNames();
                    AwsAsgUtil.this.logger.debug("Trying to  refresh the keys for {}", (Object)Arrays.toString(asgNames.toArray()));
                    for (String key : asgNames) {
                        try {
                            AwsAsgUtil.this.asgCache.refresh((Object)key);
                        }
                        catch (Throwable e) {
                            AwsAsgUtil.this.logger.error("Error updating the ASG cache for " + key, e);
                        }
                    }
                }
                catch (Throwable e) {
                    AwsAsgUtil.this.logger.error("Error updating the ASG cache", e);
                }
            }
        };
    }

    private Set<String> getASGNames() {
        HashSet<String> asgNames = new HashSet<String>();
        Applications apps = PeerAwareInstanceRegistry.getInstance().getApplications(false);
        for (Application app : apps.getRegisteredApplications()) {
            for (InstanceInfo instanceInfo : app.getInstances()) {
                String asgName = instanceInfo.getASGName();
                if (asgName == null) continue;
                asgNames.add(asgName);
            }
        }
        return asgNames;
    }

    private static AmazonAutoScaling getAmazonAutoScalingClient() {
        String aWSAccessId = eurekaConfig.getAWSAccessId();
        String aWSSecretKey = eurekaConfig.getAWSSecretKey();
        ClientConfiguration clientConfiguration = new ClientConfiguration().withConnectionTimeout(eurekaConfig.getASGQueryTimeoutMs());
        if (null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey)) {
            return new AmazonAutoScalingClient((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey), clientConfiguration);
        }
        return new AmazonAutoScalingClient((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(), clientConfiguration);
    }
}

