/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ApplicationResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
public class InstanceResource {
    private static final Logger logger = LoggerFactory.getLogger(InstanceResource.class);
    private static final PeerAwareInstanceRegistry registry = PeerAwareInstanceRegistry.getInstance();
    String id;
    ApplicationResource app;

    public InstanceResource(ApplicationResource app, String id) {
        this.id = id;
        this.app = app;
    }

    @GET
    public Response getInstanceInfo() {
        InstanceInfo appInfo = registry.getInstanceByAppAndId(this.app.getName(), this.id);
        if (appInfo != null) {
            logger.debug("Found: {} - {}", (Object)this.app.getName(), (Object)this.id);
            return Response.ok((Object)appInfo).build();
        }
        logger.debug("Not Found: {} - {}", (Object)this.app.getName(), (Object)this.id);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    public Response renewLease(@HeaderParam(value="x-netflix-discovery-replication") String isReplication, @QueryParam(value="overriddenstatus") String overriddenStatus, @QueryParam(value="status") String status, @QueryParam(value="lastDirtyTimestamp") String lastDirtyTimestamp) {
        boolean isFromReplicaNode = "true".equals(isReplication);
        boolean isSuccess = registry.renew(this.app.getName(), this.id, isFromReplicaNode);
        if (!isSuccess) {
            logger.warn("Not Found (Renew): {} - {}", (Object)this.app.getName(), (Object)this.id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response response = null;
        if (lastDirtyTimestamp != null && EurekaServerConfigurationManager.getInstance().getConfiguration().shouldSyncWhenTimestampDiffers()) {
            response = this.validateDirtyTimestamp(Long.valueOf(lastDirtyTimestamp), isFromReplicaNode);
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode() && overriddenStatus != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)overriddenStatus) && isFromReplicaNode) {
                registry.storeOverriddenStatusIfRequired(this.id, InstanceInfo.InstanceStatus.valueOf((String)overriddenStatus));
            }
            return response;
        }
        logger.debug("Found (Renew): {} - {}" + this.app.getName(), (Object)this.id);
        return Response.ok().build();
    }

    @PUT
    @Path(value="status")
    public Response statusUpdate(@QueryParam(value="value") String newStatus, @HeaderParam(value="x-netflix-discovery-replication") String isReplication, @QueryParam(value="lastDirtyTimestamp") String lastDirtyTimestamp) {
        try {
            boolean isSuccess = registry.statusUpdate(this.app.getName(), this.id, InstanceInfo.InstanceStatus.valueOf((String)newStatus), lastDirtyTimestamp, "true".equals(isReplication));
            if (isSuccess) {
                logger.info("Status updated: " + this.app.getName() + " - " + this.id + " - " + newStatus);
                return Response.ok().build();
            }
            logger.warn("Unable to update status: " + this.app.getName() + " - " + this.id + " - " + newStatus);
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (Throwable e) {
            logger.error("Error updating instance {} for status {}", (Object)this.id, (Object)newStatus);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="metadata")
    public Response updateMetadata(@Context UriInfo uriInfo) {
        try {
            InstanceInfo instanceInfo = registry.getInstanceByAppAndId(this.app.getName(), this.id);
            if (instanceInfo == null) {
                logger.error("Cannot find instance while updating metadata for instance {}", (Object)this.id);
                return Response.serverError().build();
            }
            MultivaluedMap queryParams = uriInfo.getQueryParameters();
            Set entrySet = queryParams.entrySet();
            ConcurrentHashMap metadataMap = instanceInfo.getMetadata();
            if (Collections.emptyMap().getClass().equals(metadataMap.getClass())) {
                metadataMap = new ConcurrentHashMap();
                InstanceInfo.Builder builder = new InstanceInfo.Builder(instanceInfo);
                builder.setMetadata(metadataMap);
                instanceInfo = builder.build();
            }
            for (Map.Entry entry : entrySet) {
                metadataMap.put(entry.getKey(), ((List)entry.getValue()).get(0));
            }
            registry.register(instanceInfo, false);
            return Response.ok().build();
        }
        catch (Throwable e) {
            logger.error("Error updating metadata for instance " + this.id, e);
            return Response.serverError().build();
        }
    }

    @DELETE
    public Response cancelLease(@HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        boolean isSuccess = registry.cancel(this.app.getName(), this.id, "true".equals(isReplication));
        if (isSuccess) {
            logger.info("Found (Cancel): " + this.app.getName() + " - " + this.id);
            return Response.ok().build();
        }
        logger.info("Not Found (Cancel): " + this.app.getName() + " - " + this.id);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response validateDirtyTimestamp(Long lastDirtyTimestamp, boolean isReplication) {
        InstanceInfo appInfo = registry.getInstanceByAppAndId(this.app.getName(), this.id, false);
        if (appInfo != null && lastDirtyTimestamp != null && !lastDirtyTimestamp.equals(appInfo.getLastDirtyTimestamp())) {
            Object[] args = new Object[]{this.id, appInfo.getLastDirtyTimestamp(), lastDirtyTimestamp, isReplication};
            if (lastDirtyTimestamp > appInfo.getLastDirtyTimestamp()) {
                logger.warn("Time to sync, since the last dirty timestamp differs - ReplicationInstance id : {},Registry : {} Incoming: {} Replication: {}", args);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (appInfo.getLastDirtyTimestamp() > lastDirtyTimestamp) {
                if (isReplication) {
                    logger.warn("Time to sync, since the last dirty timestamp differs - ReplicationInstance id : {},Registry : {} Incoming: {} Replication: {}", args);
                    return Response.ok((Object)appInfo).build();
                }
                return Response.ok().build();
            }
        }
        return Response.ok().build();
    }
}

