/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiter {
    private final AtomicInteger consumedTokens = new AtomicInteger();
    private final AtomicLong lastRefillTime = new AtomicLong(0L);

    public boolean acquire(int burstSize, int averageRate) {
        return this.acquire(burstSize, averageRate, System.currentTimeMillis());
    }

    public boolean acquire(int burstSize, int averageRate, long currentTimeMillis) {
        if (burstSize <= 0 || averageRate <= 0) {
            return true;
        }
        this.refillToken(burstSize, averageRate, currentTimeMillis);
        return this.consumeToken(burstSize);
    }

    private void refillToken(int burstSize, int averageRate, long currentTimeMillis) {
        long newRefillTime;
        long refillTime = this.lastRefillTime.get();
        long timeDelta = currentTimeMillis - refillTime;
        long newTokens = timeDelta * (long)averageRate / 1000L;
        if (newTokens > 0L && this.lastRefillTime.compareAndSet(refillTime, newRefillTime = refillTime + newTokens * 1000L / (long)averageRate)) {
            int adjustedLevel;
            int newLevel;
            int currentLevel;
            while (!this.consumedTokens.compareAndSet(currentLevel = this.consumedTokens.get(), newLevel = (int)Math.max(0L, (long)(adjustedLevel = Math.min(currentLevel, burstSize)) - newTokens))) {
            }
            return;
        }
    }

    private boolean consumeToken(int burstSize) {
        int currentLevel;
        do {
            if ((currentLevel = this.consumedTokens.get()) < burstSize) continue;
            return false;
        } while (!this.consumedTokens.compareAndSet(currentLevel, currentLevel + 1));
        return true;
    }

    public void reset() {
        this.consumedTokens.set(0);
        this.lastRefillTime.set(0L);
    }
}

