/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.discovery.shared.EurekaHttpClient;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ReplicationTask {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationTask.class);
    protected final String peerNodeName;
    protected final PeerAwareInstanceRegistryImpl.Action action;

    ReplicationTask(String peerNodeName, PeerAwareInstanceRegistryImpl.Action action) {
        this.peerNodeName = peerNodeName;
        this.action = action;
    }

    public abstract String getTaskName();

    public PeerAwareInstanceRegistryImpl.Action getAction() {
        return this.action;
    }

    public abstract EurekaHttpClient.HttpResponse<?> execute() throws Throwable;

    public void handleSuccess() {
    }

    public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
        logger.warn("The replication of task {} failed with response code {}", (Object)this.getTaskName(), (Object)statusCode);
    }
}

