/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesResult;
import com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceNetworkInterface;
import com.amazonaws.services.ec2.model.NetworkInterface;
import com.amazonaws.services.ec2.model.Reservation;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Ordering;
import com.google.common.net.InetAddresses;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsBinder;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticNetworkInterfaceBinder
implements AwsBinder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticNetworkInterfaceBinder.class);
    private static final int IP_BIND_SLEEP_TIME_MS = 1000;
    private static final Timer timer = new Timer("Eureka-ElasticNetworkInterfaceBinder", true);
    private final EurekaServerConfig serverConfig;
    private final EurekaClientConfig clientConfig;
    private final PeerAwareInstanceRegistry registry;
    private final ApplicationInfoManager applicationInfoManager;

    @Inject
    public ElasticNetworkInterfaceBinder(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, PeerAwareInstanceRegistry registry, ApplicationInfoManager applicationInfoManager) {
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.registry = registry;
        this.applicationInfoManager = applicationInfoManager;
    }

    @Override
    @PostConstruct
    public void start() {
        int retries = this.serverConfig.getEIPBindRebindRetries();
        for (int i = 0; i < retries; ++i) {
            try {
                if (this.alreadyBound()) break;
                this.bind();
                continue;
            }
            catch (Throwable e) {
                logger.error("Cannot bind to IP", e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        timer.schedule((TimerTask)new IPBindingTask(), this.serverConfig.getEIPBindingRetryIntervalMsWhenUnbound());
    }

    @Override
    @PreDestroy
    public void shutdown() {
        timer.cancel();
        for (int i = 0; i < this.serverConfig.getEIPBindRebindRetries(); ++i) {
            try {
                this.unbind();
                break;
            }
            catch (Exception e) {
                logger.warn("Cannot unbind the IP from the instance");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public boolean alreadyBound() throws MalformedURLException {
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        AmazonEC2 ec2Service = this.getEC2Service();
        List instanceNetworkInterfaces = this.instanceData(myInstanceId, ec2Service).getNetworkInterfaces();
        List<String> candidateIPs = this.getCandidateIps();
        for (String ip : candidateIPs) {
            for (InstanceNetworkInterface ini : instanceNetworkInterfaces) {
                if (!ip.equals(ini.getPrivateIpAddress())) continue;
                logger.info("My instance {} seems to be already associated with the ip {}", (Object)myInstanceId, (Object)ip);
                return true;
            }
        }
        return false;
    }

    public void bind() throws MalformedURLException {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone);
        final List<String> ips = this.getCandidateIps();
        Ordering ipsOrder = Ordering.natural().onResultOf((Function)new Function<NetworkInterface, Integer>(){

            public Integer apply(NetworkInterface networkInterface) {
                return ips.indexOf(networkInterface.getPrivateIpAddress());
            }
        });
        AmazonEC2 ec2Service = this.getEC2Service();
        String subnetId = this.instanceData(myInstanceId, ec2Service).getSubnetId();
        DescribeNetworkInterfacesResult result = ec2Service.describeNetworkInterfaces(new DescribeNetworkInterfacesRequest().withFilters(new Filter[]{new Filter("private-ip-address", ips)}).withFilters(new Filter[]{new Filter("status", Collections.singletonList("available"))}).withFilters(new Filter[]{new Filter("subnet-id", Collections.singletonList(subnetId))}));
        if (result.getNetworkInterfaces().isEmpty()) {
            logger.info("No ip is free to be associated with this instance. Candidate ips are: {} for zone: {}", ips, (Object)myZone);
        } else {
            NetworkInterface selected = (NetworkInterface)ipsOrder.min((Iterable)result.getNetworkInterfaces());
            ec2Service.attachNetworkInterface(new AttachNetworkInterfaceRequest().withNetworkInterfaceId(selected.getNetworkInterfaceId()).withDeviceIndex(Integer.valueOf(1)).withInstanceId(myInstanceId));
        }
    }

    public void unbind() throws Exception {
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        AmazonEC2 ec2 = this.getEC2Service();
        List result = this.instanceData(myInstanceId, ec2).getNetworkInterfaces();
        List<String> ips = this.getCandidateIps();
        for (InstanceNetworkInterface networkInterface : result) {
            if (!ips.contains(networkInterface.getPrivateIpAddress())) continue;
            String attachmentId = networkInterface.getAttachment().getAttachmentId();
            ec2.detachNetworkInterface(new DetachNetworkInterfaceRequest().withAttachmentId(attachmentId));
            break;
        }
    }

    private Instance instanceData(String myInstanceId, AmazonEC2 ec2) {
        return (Instance)((Reservation)ec2.describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{myInstanceId})).getReservations().get(0)).getInstances().get(0);
    }

    public List<String> getCandidateIps() throws MalformedURLException {
        Collection<String> candidates;
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone);
        Collection<String> collection = candidates = this.clientConfig.shouldUseDnsForFetchingServiceUrls() ? this.getIPsForZoneFromDNS(myZone) : this.getIPsForZoneFromConfig(myZone);
        if (candidates == null || candidates.size() == 0) {
            throw new RuntimeException("Could not get any ips from the pool for zone :" + myZone);
        }
        ArrayList<String> ips = new ArrayList<String>();
        for (String candidate : candidates) {
            String host = new URL(candidate).getHost();
            if (InetAddresses.isInetAddress((String)host)) {
                ips.add(host);
                continue;
            }
            String firstPartOfHost = (String)Splitter.on((String)".").splitToList((CharSequence)host).get(0);
            List noIpPrefix = Splitter.on((String)"-").splitToList((CharSequence)firstPartOfHost).subList(1, 5);
            String ip = Joiner.on((String)".").join(noIpPrefix);
            if (InetAddresses.isInetAddress((String)ip)) {
                ips.add(ip);
                continue;
            }
            throw new IllegalArgumentException("Illegal internal hostname " + host + " translated to '" + ip + "'");
        }
        return ips;
    }

    private Collection<String> getIPsForZoneFromConfig(String myZone) {
        return this.clientConfig.getEurekaServerServiceUrls(myZone);
    }

    private Collection<String> getIPsForZoneFromDNS(String myZone) {
        return EndpointUtils.getServiceUrlsFromDNS((EurekaClientConfig)this.clientConfig, (String)myZone, (boolean)true, (EndpointUtils.ServiceUrlRandomizer)new EndpointUtils.InstanceInfoBasedUrlRandomizer(this.applicationInfoManager.getInfo()));
    }

    private AmazonEC2 getEC2Service() {
        String aWSAccessId = this.serverConfig.getAWSAccessId();
        String aWSSecretKey = this.serverConfig.getAWSSecretKey();
        AmazonEC2Client ec2Service = null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey) ? new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey)) : new AmazonEC2Client((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
        String region = this.clientConfig.getRegion();
        region = region.trim().toLowerCase();
        ec2Service.setEndpoint("ec2." + region + ".amazonaws.com");
        return ec2Service;
    }

    private class IPBindingTask
    extends TimerTask {
        private IPBindingTask() {
        }

        @Override
        public void run() {
            boolean alreadyBound = false;
            try {
                alreadyBound = ElasticNetworkInterfaceBinder.this.alreadyBound();
                if (alreadyBound) {
                    return;
                }
                ElasticNetworkInterfaceBinder.this.registry.clearRegistry();
                int count = ElasticNetworkInterfaceBinder.this.registry.syncUp();
                ElasticNetworkInterfaceBinder.this.registry.openForTraffic(ElasticNetworkInterfaceBinder.this.applicationInfoManager, count);
                ElasticNetworkInterfaceBinder.this.bind();
            }
            catch (Throwable e) {
                logger.error("Could not bind to IP", e);
            }
            finally {
                if (alreadyBound) {
                    timer.schedule((TimerTask)new IPBindingTask(), ElasticNetworkInterfaceBinder.this.serverConfig.getEIPBindingRetryIntervalMs());
                } else {
                    timer.schedule((TimerTask)new IPBindingTask(), ElasticNetworkInterfaceBinder.this.serverConfig.getEIPBindingRetryIntervalMsWhenUnbound());
                }
            }
        }
    }
}

