/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixExecutableBase;
import com.netflix.hystrix.HystrixExecutableInfo;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Schedulers;

@ThreadSafe
public abstract class HystrixCommand<R>
implements HystrixExecutable<R>,
HystrixExecutableInfo<R> {
    private final HystrixCommandFromObservableCommand<R> observableCommand;

    protected HystrixCommand(HystrixCommandGroupKey group) {
        this(new Setter(group));
    }

    protected HystrixCommand(Setter setter) {
        this(setter.groupKey, setter.commandKey, setter.threadPoolKey, null, null, setter.commandPropertiesDefaults, setter.threadPoolPropertiesDefaults, null, null, null, null, null);
    }

    HystrixCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, HystrixExecutableBase.TryableSemaphore fallbackSemaphore, HystrixExecutableBase.TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        HystrixCommandKey commandKey = null;
        if (key == null || key.name().trim().equals("")) {
            String keyName = HystrixExecutableBase.getDefaultNameFromClass(this.getClass());
            commandKey = HystrixCommandKey.Factory.asKey(keyName);
        } else {
            commandKey = key;
        }
        this.observableCommand = new HystrixCommandFromObservableCommand(this, group, commandKey, threadPoolKey, circuitBreaker, threadPool, commandPropertiesDefaults, threadPoolPropertiesDefaults, metrics, fallbackSemaphore, executionSemaphore, propertiesStrategy, executionHook);
    }

    protected abstract R run() throws Exception;

    protected R getFallback() {
        throw new UnsupportedOperationException("No fallback available.");
    }

    protected String getCacheKey() {
        return null;
    }

    public Observable<R> toObservable() {
        if (this.observableCommand.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
            return this.toObservable(Schedulers.computation());
        }
        return this.toObservable(Schedulers.immediate());
    }

    public Observable<R> toObservable(Scheduler observeOn) {
        return this.toObservable(observeOn, true);
    }

    private HystrixExecutableBase.ObservableCommand<R> toObservable(Scheduler observeOn, boolean performAsyncTimeout) {
        return this.observableCommand.toObservable(observeOn, performAsyncTimeout);
    }

    @Override
    public HystrixCommandGroupKey getCommandGroup() {
        return this.observableCommand.getCommandGroup();
    }

    @Override
    public HystrixCommandKey getCommandKey() {
        return this.observableCommand.getCommandKey();
    }

    @Override
    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.observableCommand.getThreadPoolKey();
    }

    @Override
    public HystrixCommandMetrics getMetrics() {
        return this.observableCommand.getMetrics();
    }

    @Override
    public HystrixCommandProperties getProperties() {
        return this.observableCommand.getProperties();
    }

    @Override
    public boolean isCircuitBreakerOpen() {
        return this.observableCommand.isCircuitBreakerOpen();
    }

    @Override
    public boolean isExecutionComplete() {
        return this.observableCommand.isExecutionComplete();
    }

    @Override
    public boolean isExecutedInThread() {
        return this.observableCommand.isExecutedInThread();
    }

    @Override
    public boolean isSuccessfulExecution() {
        return this.observableCommand.isSuccessfulExecution();
    }

    @Override
    public boolean isFailedExecution() {
        return this.observableCommand.isFailedExecution();
    }

    @Override
    public Throwable getFailedExecutionException() {
        return this.observableCommand.getFailedExecutionException();
    }

    @Override
    public boolean isResponseFromFallback() {
        return this.observableCommand.isResponseFromFallback();
    }

    @Override
    public boolean isResponseTimedOut() {
        return this.observableCommand.isResponseTimedOut();
    }

    @Override
    public boolean isResponseShortCircuited() {
        return this.observableCommand.isResponseShortCircuited();
    }

    @Override
    public boolean isResponseFromCache() {
        return this.observableCommand.isResponseFromCache();
    }

    @Override
    public boolean isResponseRejected() {
        return this.observableCommand.isResponseRejected();
    }

    @Override
    public List<HystrixEventType> getExecutionEvents() {
        return this.observableCommand.getExecutionEvents();
    }

    @Override
    public int getExecutionTimeInMilliseconds() {
        return this.observableCommand.getExecutionTimeInMilliseconds();
    }

    @Override
    public Future<R> queue() {
        return this.observableCommand.queue();
    }

    @Override
    public R execute() {
        return (R)this.observableCommand.execute();
    }

    @Override
    public Observable<R> observe() {
        return this.observableCommand.observe();
    }

    void markAsCollapsedCommand(int sizeOfBatch) {
        this.observableCommand.markAsCollapsedCommand(sizeOfBatch);
    }

    HystrixCircuitBreaker getCircuitBreaker() {
        return this.observableCommand.getCircuitBreaker();
    }

    static class HystrixCommandFromObservableCommand<R>
    extends HystrixObservableCommand<R> {
        private final HystrixCommand<R> original;

        protected HystrixCommandFromObservableCommand(HystrixCommand<R> o, HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, HystrixExecutableBase.TryableSemaphore fallbackSemaphore, HystrixExecutableBase.TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
            super(group, key, threadPoolKey, circuitBreaker, threadPool, commandPropertiesDefaults, threadPoolPropertiesDefaults, metrics, fallbackSemaphore, executionSemaphore, propertiesStrategy, executionHook);
            this.original = o;
        }

        HystrixCommand<R> getOriginal() {
            return this.original;
        }

        @Override
        protected Observable<R> run() {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> s) {
                    try {
                        s.onNext(HystrixCommandFromObservableCommand.this.original.run());
                        s.onCompleted();
                    }
                    catch (Throwable e) {
                        s.onError(e);
                    }
                }
            });
        }

        @Override
        protected Observable<R> getFallback() {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> s) {
                    try {
                        s.onNext(HystrixCommandFromObservableCommand.this.original.getFallback());
                        s.onCompleted();
                    }
                    catch (Throwable e) {
                        s.onError(e);
                    }
                }
            });
        }

        @Override
        protected String getCacheKey() {
            return this.original.getCacheKey();
        }
    }

    @NotThreadSafe
    public static class Setter {
        protected final HystrixCommandGroupKey groupKey;
        protected HystrixCommandKey commandKey;
        protected HystrixThreadPoolKey threadPoolKey;
        protected HystrixCommandProperties.Setter commandPropertiesDefaults;
        protected HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults;

        protected Setter(HystrixCommandGroupKey groupKey) {
            this.groupKey = groupKey;
        }

        public static Setter withGroupKey(HystrixCommandGroupKey groupKey) {
            return new Setter(groupKey);
        }

        public Setter andCommandKey(HystrixCommandKey commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        public Setter andThreadPoolKey(HystrixThreadPoolKey threadPoolKey) {
            this.threadPoolKey = threadPoolKey;
            return this;
        }

        public Setter andCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            this.commandPropertiesDefaults = commandPropertiesDefaults;
            return this;
        }

        public Setter andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
            this.threadPoolPropertiesDefaults = threadPoolPropertiesDefaults;
            return this;
        }
    }
}

