/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RealCollapserTimer;
import com.netflix.hystrix.collapser.RequestCollapser;
import com.netflix.hystrix.collapser.RequestCollapserFactory;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.schedulers.Schedulers;
import rx.subjects.ReplaySubject;

public abstract class HystrixObservableCollapser<BatchReturnType, ResponseType, RequestArgumentType>
implements HystrixExecutable<ResponseType> {
    static final Logger logger = LoggerFactory.getLogger(HystrixObservableCollapser.class);
    private final RequestCollapserFactory<BatchReturnType, ResponseType, RequestArgumentType> collapserFactory;
    private final HystrixRequestCache requestCache;
    private final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> collapserInstanceWrapper;
    private static ConcurrentHashMap<Class<? extends HystrixObservableCollapser>, String> defaultNameCache = new ConcurrentHashMap();

    protected HystrixObservableCollapser() {
        this(Setter.withCollapserKey(null).andScope(Scope.REQUEST));
    }

    protected HystrixObservableCollapser(HystrixCollapserKey collapserKey) {
        this(Setter.withCollapserKey(collapserKey).andScope(Scope.REQUEST));
    }

    protected HystrixObservableCollapser(Setter setter) {
        this(setter.collapserKey, setter.scope, new RealCollapserTimer(), setter.propertiesSetter);
    }

    HystrixObservableCollapser(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder) {
        if (collapserKey == null || collapserKey.name().trim().equals("")) {
            String defaultKeyName = HystrixObservableCollapser.getDefaultNameFromClass(this.getClass());
            collapserKey = HystrixCollapserKey.Factory.asKey(defaultKeyName);
        }
        this.collapserFactory = new RequestCollapserFactory(collapserKey, scope, timer, propertiesBuilder);
        this.requestCache = HystrixRequestCache.getInstance(collapserKey, HystrixPlugins.getInstance().getConcurrencyStrategy());
        final HystrixObservableCollapser self = this;
        this.collapserInstanceWrapper = new HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType>(){

            @Override
            public Collection<Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                return self.shardRequests(requests);
            }

            @Override
            public Observable<BatchReturnType> createObservableCommand(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                HystrixObservableCommand command = self.createCommand(requests);
                command.markAsCollapsedCommand(requests.size());
                return command.toObservable();
            }

            @Override
            public void mapResponseToRequests(BatchReturnType batchResponse, Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
                self.mapResponseToRequests(batchResponse, requests);
            }

            @Override
            public HystrixCollapserKey getCollapserKey() {
                return self.getCollapserKey();
            }
        };
    }

    private HystrixCollapserProperties getProperties() {
        return this.collapserFactory.getProperties();
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserFactory.getCollapserKey();
    }

    public Scope getScope() {
        return Scope.valueOf(this.collapserFactory.getScope().name());
    }

    public abstract RequestArgumentType getRequestArgument();

    protected abstract HystrixObservableCommand<BatchReturnType> createCommand(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> var1);

    protected Collection<Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>>> shardRequests(Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> requests) {
        return Collections.singletonList(requests);
    }

    protected abstract void mapResponseToRequests(BatchReturnType var1, Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> var2);

    @Override
    public Observable<ResponseType> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe((Observer)subject);
        return subject;
    }

    public Observable<ResponseType> toObservable() {
        return this.toObservable(Schedulers.computation());
    }

    public Observable<ResponseType> toObservable(Scheduler observeOn) {
        Observable fromCache;
        if (this.getProperties().requestCachingEnabled().get().booleanValue() && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            return fromCache;
        }
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> requestCollapser = this.collapserFactory.getRequestCollapser(this.collapserInstanceWrapper);
        Observable response = requestCollapser.submitRequest(this.getRequestArgument());
        if (this.getProperties().requestCachingEnabled().get().booleanValue()) {
            Observable o = response.cache();
            Observable fromCache2 = this.requestCache.putIfAbsent(this.getCacheKey(), o);
            response = fromCache2 == null ? o : fromCache2;
        }
        return response;
    }

    @Override
    public ResponseType execute() {
        try {
            return this.queue().get();
        }
        catch (Throwable e) {
            if (e instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e;
            }
            if (e.getCause() instanceof HystrixRuntimeException) {
                throw (HystrixRuntimeException)e.getCause();
            }
            String message = this.getClass().getSimpleName() + " HystrixCollapser failed while executing.";
            logger.debug(message, e);
            throw new RuntimeException(message, e);
        }
    }

    @Override
    public Future<ResponseType> queue() {
        Observable<ResponseType> o = this.toObservable();
        return o.toBlockingObservable().toFuture();
    }

    protected String getCacheKey() {
        return null;
    }

    static void reset() {
        RequestCollapserFactory.reset();
    }

    private static String getDefaultNameFromClass(Class<? extends HystrixObservableCollapser> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    @NotThreadSafe
    public static class Setter {
        private final HystrixCollapserKey collapserKey;
        private Scope scope = Scope.REQUEST;
        private HystrixCollapserProperties.Setter propertiesSetter;

        private Setter(HystrixCollapserKey collapserKey) {
            this.collapserKey = collapserKey;
        }

        public static Setter withCollapserKey(HystrixCollapserKey collapserKey) {
            return new Setter(collapserKey);
        }

        public Setter andScope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Setter andCollapserPropertiesDefaults(HystrixCollapserProperties.Setter propertiesSetter) {
            this.propertiesSetter = propertiesSetter;
            return this;
        }
    }

    public static enum Scope implements RequestCollapserFactory.Scope
    {
        REQUEST,
        GLOBAL;

    }
}

