/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.exception;

import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.util.ExceptionThreadingUtility;

public class HystrixRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5219160375476046229L;
    private final Class<? extends HystrixExecutable> commandClass;
    private final Throwable fallbackException;
    private final FailureType failureCause;

    public HystrixRuntimeException(FailureType failureCause, Class<? extends HystrixExecutable> commandClass, String message, Exception cause, Throwable fallbackException) {
        super(message, cause);
        this.failureCause = failureCause;
        this.commandClass = commandClass;
        this.fallbackException = fallbackException;
        ExceptionThreadingUtility.attachCallingThreadStack(this);
    }

    public HystrixRuntimeException(FailureType failureCause, Class<? extends HystrixExecutable> commandClass, String message, Throwable cause, Throwable fallbackException) {
        super(message, cause);
        this.failureCause = failureCause;
        this.commandClass = commandClass;
        this.fallbackException = fallbackException;
        ExceptionThreadingUtility.attachCallingThreadStack(this);
    }

    public FailureType getFailureType() {
        return this.failureCause;
    }

    public Class<? extends HystrixExecutable> getImplementingClass() {
        return this.commandClass;
    }

    public Throwable getFallbackException() {
        return this.fallbackException;
    }

    public static enum FailureType {
        COMMAND_EXCEPTION,
        TIMEOUT,
        SHORTCIRCUIT,
        REJECTED_THREAD_EXECUTION,
        REJECTED_SEMAPHORE_EXECUTION,
        REJECTED_SEMAPHORE_FALLBACK;

    }
}

