/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class HystrixRequestVariableDefault<T>
implements HystrixRequestVariable<T> {
    static final Logger logger = LoggerFactory.getLogger(HystrixRequestVariableDefault.class);

    @Override
    public T get() {
        if (HystrixRequestContext.getContextForCurrentThread() == null) {
            throw new IllegalStateException(HystrixRequestContext.class.getSimpleName() + ".initializeContext() must be called at the beginning of each request before RequestVariable functionality can be used.");
        }
        ConcurrentHashMap<HystrixRequestVariableDefault<?>, LazyInitializer<?>> variableMap = HystrixRequestContext.getContextForCurrentThread().state;
        LazyInitializer<?> v = variableMap.get(this);
        if (v != null) {
            return (T)v.get();
        }
        LazyInitializer l = new LazyInitializer(this);
        LazyInitializer existing = variableMap.putIfAbsent(this, l);
        if (existing == null) {
            return l.get();
        }
        return existing.get();
    }

    @Override
    public T initialValue() {
        return null;
    }

    public void set(T value) {
        HystrixRequestContext.getContextForCurrentThread().state.put(this, new LazyInitializer(this, value));
    }

    public void remove() {
        if (HystrixRequestContext.getContextForCurrentThread() != null) {
            HystrixRequestVariableDefault.remove(HystrixRequestContext.getContextForCurrentThread(), this);
        }
    }

    static <T> void remove(HystrixRequestContext context, HystrixRequestVariableDefault<T> v) {
        LazyInitializer<?> o = context.state.remove(v);
        if (o != null) {
            v.shutdown(o.get());
        }
    }

    @Override
    public void shutdown(T value) {
    }

    static final class LazyInitializer<T> {
        @GuardedBy(value="synchronization on get() or construction")
        private T value;
        @GuardedBy(value="synchronization on get() or construction")
        private boolean initialized = false;
        private final HystrixRequestVariableDefault<T> rv;

        private LazyInitializer(HystrixRequestVariableDefault<T> rv) {
            this.rv = rv;
        }

        private LazyInitializer(HystrixRequestVariableDefault<T> rv, T value) {
            this.rv = rv;
            this.value = value;
            this.initialized = true;
        }

        public synchronized T get() {
            if (!this.initialized) {
                this.value = this.rv.initialValue();
                this.initialized = true;
            }
            return this.value;
        }
    }
}

