/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;

public abstract class HystrixCollapserProperties {
    private static final Integer default_maxRequestsInBatch = Integer.MAX_VALUE;
    private static final Integer default_timerDelayInMilliseconds = 10;
    private static final Boolean default_requestCacheEnabled = true;
    static final Integer default_metricsRollingStatisticalWindow = 10000;
    private static final Integer default_metricsRollingStatisticalWindowBuckets = 10;
    private static final Boolean default_metricsRollingPercentileEnabled = true;
    private static final Integer default_metricsRollingPercentileWindow = 60000;
    private static final Integer default_metricsRollingPercentileWindowBuckets = 6;
    private static final Integer default_metricsRollingPercentileBucketSize = 100;
    private final HystrixProperty<Integer> maxRequestsInBatch;
    private final HystrixProperty<Integer> timerDelayInMilliseconds;
    private final HystrixProperty<Boolean> requestCacheEnabled;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets;
    private final HystrixProperty<Boolean> metricsRollingPercentileEnabled;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowInMilliseconds;
    private final HystrixProperty<Integer> metricsRollingPercentileWindowBuckets;
    private final HystrixProperty<Integer> metricsRollingPercentileBucketSize;

    protected HystrixCollapserProperties(HystrixCollapserKey collapserKey) {
        this(collapserKey, new Setter(), "hystrix");
    }

    protected HystrixCollapserProperties(HystrixCollapserKey collapserKey, Setter builder) {
        this(collapserKey, builder, "hystrix");
    }

    protected HystrixCollapserProperties(HystrixCollapserKey key, Setter builder, String propertyPrefix) {
        this.maxRequestsInBatch = HystrixCollapserProperties.getProperty(propertyPrefix, key, "maxRequestsInBatch", builder.getMaxRequestsInBatch(), default_maxRequestsInBatch);
        this.timerDelayInMilliseconds = HystrixCollapserProperties.getProperty(propertyPrefix, key, "timerDelayInMilliseconds", builder.getTimerDelayInMilliseconds(), default_timerDelayInMilliseconds);
        this.requestCacheEnabled = HystrixCollapserProperties.getProperty(propertyPrefix, key, "requestCache.enabled", builder.getRequestCacheEnabled(), default_requestCacheEnabled);
        this.metricsRollingStatisticalWindowInMilliseconds = HystrixCollapserProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.timeInMilliseconds", builder.getMetricsRollingStatisticalWindowInMilliseconds(), default_metricsRollingStatisticalWindow);
        this.metricsRollingStatisticalWindowBuckets = HystrixCollapserProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.numBuckets", builder.getMetricsRollingStatisticalWindowBuckets(), default_metricsRollingStatisticalWindowBuckets);
        this.metricsRollingPercentileEnabled = HystrixCollapserProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.enabled", builder.getMetricsRollingPercentileEnabled(), default_metricsRollingPercentileEnabled);
        this.metricsRollingPercentileWindowInMilliseconds = HystrixCollapserProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.timeInMilliseconds", builder.getMetricsRollingPercentileWindowInMilliseconds(), default_metricsRollingPercentileWindow);
        this.metricsRollingPercentileWindowBuckets = HystrixCollapserProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.numBuckets", builder.getMetricsRollingPercentileWindowBuckets(), default_metricsRollingPercentileWindowBuckets);
        this.metricsRollingPercentileBucketSize = HystrixCollapserProperties.getProperty(propertyPrefix, key, "metrics.rollingPercentile.bucketSize", builder.getMetricsRollingPercentileBucketSize(), default_metricsRollingPercentileBucketSize);
    }

    private static HystrixProperty<Integer> getProperty(String propertyPrefix, HystrixCollapserKey key, String instanceProperty, Integer builderOverrideValue, Integer defaultValue) {
        return HystrixPropertiesChainedProperty.forInteger().add(propertyPrefix + ".collapser." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".collapser.default." + instanceProperty, defaultValue).build();
    }

    private static HystrixProperty<Boolean> getProperty(String propertyPrefix, HystrixCollapserKey key, String instanceProperty, Boolean builderOverrideValue, Boolean defaultValue) {
        return HystrixPropertiesChainedProperty.forBoolean().add(propertyPrefix + ".collapser." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".collapser.default." + instanceProperty, defaultValue).build();
    }

    private static HystrixProperty<String> getProperty(String propertyPrefix, HystrixCollapserKey key, String instanceProperty, String builderOverrideValue, String defaultValue) {
        return HystrixPropertiesChainedProperty.forString().add(propertyPrefix + ".collapser." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".collapser.default." + instanceProperty, defaultValue).build();
    }

    @Deprecated
    public HystrixProperty<Boolean> requestCachingEnabled() {
        return this.requestCacheEnabled;
    }

    public HystrixProperty<Boolean> requestCacheEnabled() {
        return this.requestCacheEnabled;
    }

    public HystrixProperty<Integer> maxRequestsInBatch() {
        return this.maxRequestsInBatch;
    }

    public HystrixProperty<Integer> timerDelayInMilliseconds() {
        return this.timerDelayInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.metricsRollingStatisticalWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.metricsRollingStatisticalWindowBuckets;
    }

    public HystrixProperty<Boolean> metricsRollingPercentileEnabled() {
        return this.metricsRollingPercentileEnabled;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowInMilliseconds() {
        return this.metricsRollingPercentileWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingPercentileWindowBuckets() {
        return this.metricsRollingPercentileWindowBuckets;
    }

    public HystrixProperty<Integer> metricsRollingPercentileBucketSize() {
        return this.metricsRollingPercentileBucketSize;
    }

    public static Setter Setter() {
        return new Setter();
    }

    public static Setter defaultSetter() {
        return HystrixCollapserProperties.Setter();
    }

    public static class Setter {
        private Boolean collapsingEnabled = null;
        private Integer maxRequestsInBatch = null;
        private Integer timerDelayInMilliseconds = null;
        private Boolean requestCacheEnabled = null;
        private Integer metricsRollingStatisticalWindowInMilliseconds = null;
        private Integer metricsRollingStatisticalWindowBuckets = null;
        private Integer metricsRollingPercentileBucketSize = null;
        private Boolean metricsRollingPercentileEnabled = null;
        private Integer metricsRollingPercentileWindowInMilliseconds = null;
        private Integer metricsRollingPercentileWindowBuckets = null;

        private Setter() {
        }

        public Boolean getCollapsingEnabled() {
            return this.collapsingEnabled;
        }

        public Integer getMaxRequestsInBatch() {
            return this.maxRequestsInBatch;
        }

        public Integer getTimerDelayInMilliseconds() {
            return this.timerDelayInMilliseconds;
        }

        public Boolean getRequestCacheEnabled() {
            return this.requestCacheEnabled;
        }

        public Integer getMetricsRollingStatisticalWindowInMilliseconds() {
            return this.metricsRollingStatisticalWindowInMilliseconds;
        }

        public Integer getMetricsRollingStatisticalWindowBuckets() {
            return this.metricsRollingStatisticalWindowBuckets;
        }

        public Integer getMetricsRollingPercentileBucketSize() {
            return this.metricsRollingPercentileBucketSize;
        }

        public Boolean getMetricsRollingPercentileEnabled() {
            return this.metricsRollingPercentileEnabled;
        }

        public Integer getMetricsRollingPercentileWindowInMilliseconds() {
            return this.metricsRollingPercentileWindowInMilliseconds;
        }

        public Integer getMetricsRollingPercentileWindowBuckets() {
            return this.metricsRollingPercentileWindowBuckets;
        }

        public Setter withCollapsingEnabled(boolean value) {
            this.collapsingEnabled = value;
            return this;
        }

        public Setter withMaxRequestsInBatch(int value) {
            this.maxRequestsInBatch = value;
            return this;
        }

        public Setter withTimerDelayInMilliseconds(int value) {
            this.timerDelayInMilliseconds = value;
            return this;
        }

        public Setter withRequestCacheEnabled(boolean value) {
            this.requestCacheEnabled = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowInMilliseconds(int value) {
            this.metricsRollingStatisticalWindowInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowBuckets(int value) {
            this.metricsRollingStatisticalWindowBuckets = value;
            return this;
        }

        public Setter withMetricsRollingPercentileBucketSize(int value) {
            this.metricsRollingPercentileBucketSize = value;
            return this;
        }

        public Setter withMetricsRollingPercentileEnabled(boolean value) {
            this.metricsRollingPercentileEnabled = value;
            return this;
        }

        public Setter withMetricsRollingPercentileWindowInMilliseconds(int value) {
            this.metricsRollingPercentileWindowInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingPercentileWindowBuckets(int value) {
            this.metricsRollingPercentileWindowBuckets = value;
            return this;
        }

        static Setter getUnitTestPropertiesBuilder() {
            return new Setter().withMaxRequestsInBatch(Integer.MAX_VALUE).withTimerDelayInMilliseconds(10).withRequestCacheEnabled(true);
        }

        static HystrixCollapserProperties asMock(final Setter builder) {
            return new HystrixCollapserProperties(TestHystrixCollapserKey.TEST){

                @Override
                public HystrixProperty<Boolean> requestCachingEnabled() {
                    return HystrixProperty.Factory.asProperty(builder.requestCacheEnabled);
                }

                @Override
                public HystrixProperty<Integer> maxRequestsInBatch() {
                    return HystrixProperty.Factory.asProperty(builder.maxRequestsInBatch);
                }

                @Override
                public HystrixProperty<Integer> timerDelayInMilliseconds() {
                    return HystrixProperty.Factory.asProperty(builder.timerDelayInMilliseconds);
                }
            };
        }

        private static enum TestHystrixCollapserKey implements HystrixCollapserKey
        {
            TEST;

        }
    }
}

