/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixThreadEventStream;
import com.netflix.hystrix.metric.consumer.CumulativeCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.HealthCountsStream;
import com.netflix.hystrix.metric.consumer.RollingCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandLatencyDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCommandMaxConcurrencyStream;
import com.netflix.hystrix.metric.consumer.RollingCommandUserLatencyDistributionStream;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;
import rx.functions.Func2;

public class HystrixCommandMetrics
extends HystrixMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HystrixCommandMetrics.class);
    private static final HystrixEventType[] ALL_EVENT_TYPES = HystrixEventType.values();
    public static final Func2<long[], HystrixCommandCompletion, long[]> appendEventToBucket = new Func2<long[], HystrixCommandCompletion, long[]>(){

        public long[] call(long[] initialCountArray, HystrixCommandCompletion execution) {
            ExecutionResult.EventCounts eventCounts = execution.getEventCounts();
            block3: for (HystrixEventType eventType : ALL_EVENT_TYPES) {
                switch (eventType) {
                    case EXCEPTION_THROWN: {
                        continue block3;
                    }
                    default: {
                        int n = eventType.ordinal();
                        initialCountArray[n] = initialCountArray[n] + (long)eventCounts.getCount(eventType);
                    }
                }
            }
            return initialCountArray;
        }
    };
    public static final Func2<long[], long[], long[]> bucketAggregator = new Func2<long[], long[], long[]>(){

        public long[] call(long[] cumulativeEvents, long[] bucketEventCounts) {
            block3: for (HystrixEventType eventType : ALL_EVENT_TYPES) {
                switch (eventType) {
                    case EXCEPTION_THROWN: {
                        for (HystrixEventType exceptionEventType : HystrixEventType.EXCEPTION_PRODUCING_EVENT_TYPES) {
                            int n = eventType.ordinal();
                            cumulativeEvents[n] = cumulativeEvents[n] + bucketEventCounts[exceptionEventType.ordinal()];
                        }
                        continue block3;
                    }
                    default: {
                        int n = eventType.ordinal();
                        cumulativeEvents[n] = cumulativeEvents[n] + bucketEventCounts[eventType.ordinal()];
                    }
                }
            }
            return cumulativeEvents;
        }
    };
    private static final ConcurrentHashMap<String, HystrixCommandMetrics> metrics = new ConcurrentHashMap();
    private final HystrixCommandProperties properties;
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey group;
    private final HystrixThreadPoolKey threadPoolKey;
    private final AtomicInteger concurrentExecutionCount = new AtomicInteger();
    private HealthCountsStream healthCountsStream;
    private final RollingCommandEventCounterStream rollingCommandEventCounterStream;
    private final CumulativeCommandEventCounterStream cumulativeCommandEventCounterStream;
    private final RollingCommandLatencyDistributionStream rollingCommandLatencyDistributionStream;
    private final RollingCommandUserLatencyDistributionStream rollingCommandUserLatencyDistributionStream;
    private final RollingCommandMaxConcurrencyStream rollingCommandMaxConcurrencyStream;

    public static HystrixCommandMetrics getInstance(HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixCommandProperties properties) {
        return HystrixCommandMetrics.getInstance(key, commandGroup, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixCommandMetrics getInstance(HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixThreadPoolKey threadPoolKey, HystrixCommandProperties properties) {
        HystrixCommandMetrics commandMetrics = metrics.get(key.name());
        if (commandMetrics != null) {
            return commandMetrics;
        }
        Class<HystrixCommandMetrics> clazz = HystrixCommandMetrics.class;
        synchronized (HystrixCommandMetrics.class) {
            HystrixCommandMetrics existingMetrics = metrics.get(key.name());
            if (existingMetrics != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return existingMetrics;
            }
            HystrixThreadPoolKey nonNullThreadPoolKey = threadPoolKey == null ? HystrixThreadPoolKey.Factory.asKey(commandGroup.name()) : threadPoolKey;
            HystrixCommandMetrics newCommandMetrics = new HystrixCommandMetrics(key, commandGroup, nonNullThreadPoolKey, properties, HystrixPlugins.getInstance().getEventNotifier());
            metrics.putIfAbsent(key.name(), newCommandMetrics);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return newCommandMetrics;
        }
    }

    public static HystrixCommandMetrics getInstance(HystrixCommandKey key) {
        return metrics.get(key.name());
    }

    public static Collection<HystrixCommandMetrics> getInstances() {
        return Collections.unmodifiableCollection(metrics.values());
    }

    static void reset() {
        for (HystrixCommandMetrics metricsInstance : HystrixCommandMetrics.getInstances()) {
            metricsInstance.unsubscribeAll();
        }
        metrics.clear();
    }

    HystrixCommandMetrics(final HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixThreadPoolKey threadPoolKey, HystrixCommandProperties properties, HystrixEventNotifier eventNotifier) {
        super(null);
        this.key = key;
        this.group = commandGroup;
        this.threadPoolKey = threadPoolKey;
        this.properties = properties;
        Func0<Integer> concurrentExecutionThunk = new Func0<Integer>(){

            public Integer call() {
                return HystrixCommandMetrics.getInstance(key).concurrentExecutionCount.get();
            }
        };
        this.healthCountsStream = HealthCountsStream.getInstance(key, properties);
        this.rollingCommandEventCounterStream = RollingCommandEventCounterStream.getInstance(key, properties);
        this.cumulativeCommandEventCounterStream = CumulativeCommandEventCounterStream.getInstance(key, properties);
        this.rollingCommandLatencyDistributionStream = RollingCommandLatencyDistributionStream.getInstance(key, properties);
        this.rollingCommandUserLatencyDistributionStream = RollingCommandUserLatencyDistributionStream.getInstance(key, properties);
        this.rollingCommandMaxConcurrencyStream = RollingCommandMaxConcurrencyStream.getInstance(key, properties);
    }

    synchronized void resetStream() {
        this.healthCountsStream.unsubscribe();
        HealthCountsStream.removeByKey(this.key);
        this.healthCountsStream = HealthCountsStream.getInstance(this.key, this.properties);
    }

    public HystrixCommandKey getCommandKey() {
        return this.key;
    }

    public HystrixCommandGroupKey getCommandGroup() {
        return this.group;
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public HystrixCommandProperties getProperties() {
        return this.properties;
    }

    public long getRollingCount(HystrixEventType eventType) {
        return this.rollingCommandEventCounterStream.getLatest(eventType);
    }

    public long getCumulativeCount(HystrixEventType eventType) {
        return this.cumulativeCommandEventCounterStream.getLatest(eventType);
    }

    @Override
    public long getCumulativeCount(HystrixRollingNumberEvent event) {
        return this.getCumulativeCount(HystrixEventType.from(event));
    }

    @Override
    public long getRollingCount(HystrixRollingNumberEvent event) {
        return this.getRollingCount(HystrixEventType.from(event));
    }

    public int getExecutionTimePercentile(double percentile) {
        return this.rollingCommandLatencyDistributionStream.getLatestPercentile(percentile);
    }

    public int getExecutionTimeMean() {
        return this.rollingCommandLatencyDistributionStream.getLatestMean();
    }

    @Deprecated
    public int getTotalTimePercentile(double percentile) {
        return this.rollingCommandUserLatencyDistributionStream.getLatestPercentile(percentile);
    }

    @Deprecated
    public int getTotalTimeMean() {
        return this.rollingCommandUserLatencyDistributionStream.getLatestMean();
    }

    public long getRollingMaxConcurrentExecutions() {
        return this.rollingCommandMaxConcurrencyStream.getLatestRollingMax();
    }

    public int getCurrentConcurrentExecutionCount() {
        return this.concurrentExecutionCount.get();
    }

    void markCommandStart(HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy) {
        int currentCount = this.concurrentExecutionCount.incrementAndGet();
        HystrixThreadEventStream.getInstance().commandExecutionStarted(commandKey, threadPoolKey, isolationStrategy, currentCount);
    }

    void markCommandDone(ExecutionResult executionResult, HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey) {
        HystrixThreadEventStream.getInstance().executionDone(executionResult, commandKey, threadPoolKey);
        if (executionResult.executionOccurred()) {
            this.concurrentExecutionCount.decrementAndGet();
        }
    }

    public HealthCounts getHealthCounts() {
        return (HealthCounts)this.healthCountsStream.getLatest();
    }

    private void unsubscribeAll() {
        this.healthCountsStream.unsubscribe();
        this.rollingCommandEventCounterStream.unsubscribe();
        this.cumulativeCommandEventCounterStream.unsubscribe();
        this.rollingCommandLatencyDistributionStream.unsubscribe();
        this.rollingCommandUserLatencyDistributionStream.unsubscribe();
        this.rollingCommandMaxConcurrencyStream.unsubscribe();
    }

    public static class HealthCounts {
        private final long totalCount;
        private final long errorCount;
        private final int errorPercentage;
        private static final HealthCounts EMPTY = new HealthCounts(0L, 0L);

        HealthCounts(long total, long error) {
            this.totalCount = total;
            this.errorCount = error;
            this.errorPercentage = this.totalCount > 0L ? (int)((double)this.errorCount / (double)this.totalCount * 100.0) : 0;
        }

        public long getTotalRequests() {
            return this.totalCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public int getErrorPercentage() {
            return this.errorPercentage;
        }

        public HealthCounts plus(long[] eventTypeCounts) {
            long updatedTotalCount = this.totalCount;
            long updatedErrorCount = this.errorCount;
            long successCount = eventTypeCounts[HystrixEventType.SUCCESS.ordinal()];
            long failureCount = eventTypeCounts[HystrixEventType.FAILURE.ordinal()];
            long timeoutCount = eventTypeCounts[HystrixEventType.TIMEOUT.ordinal()];
            long threadPoolRejectedCount = eventTypeCounts[HystrixEventType.THREAD_POOL_REJECTED.ordinal()];
            long semaphoreRejectedCount = eventTypeCounts[HystrixEventType.SEMAPHORE_REJECTED.ordinal()];
            return new HealthCounts(updatedTotalCount += successCount + failureCount + timeoutCount + threadPoolRejectedCount + semaphoreRejectedCount, updatedErrorCount += failureCount + timeoutCount + threadPoolRejectedCount + semaphoreRejectedCount);
        }

        public static HealthCounts empty() {
            return EMPTY;
        }

        public String toString() {
            return "HealthCounts[" + this.errorCount + " / " + this.totalCount + " : " + this.getErrorPercentage() + "%]";
        }
    }
}

