/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import org.HdrHistogram.Histogram;

public class CachedValuesHistogram {
    private final Histogram underlying;
    private final int mean;
    private final int p0;
    private final int p5;
    private final int p10;
    private final int p15;
    private final int p20;
    private final int p25;
    private final int p30;
    private final int p35;
    private final int p40;
    private final int p45;
    private final int p50;
    private final int p55;
    private final int p60;
    private final int p65;
    private final int p70;
    private final int p75;
    private final int p80;
    private final int p85;
    private final int p90;
    private final int p95;
    private final int p99;
    private final int p99_5;
    private final int p99_9;
    private final int p99_95;
    private final int p99_99;
    private final int p100;

    public static CachedValuesHistogram backedBy(Histogram underlying) {
        return new CachedValuesHistogram(underlying);
    }

    private CachedValuesHistogram(Histogram underlying) {
        this.underlying = underlying;
        this.mean = (int)underlying.getMean();
        this.p0 = (int)underlying.getValueAtPercentile(0.0);
        this.p5 = (int)underlying.getValueAtPercentile(5.0);
        this.p10 = (int)underlying.getValueAtPercentile(10.0);
        this.p15 = (int)underlying.getValueAtPercentile(15.0);
        this.p20 = (int)underlying.getValueAtPercentile(20.0);
        this.p25 = (int)underlying.getValueAtPercentile(25.0);
        this.p30 = (int)underlying.getValueAtPercentile(30.0);
        this.p35 = (int)underlying.getValueAtPercentile(35.0);
        this.p40 = (int)underlying.getValueAtPercentile(40.0);
        this.p45 = (int)underlying.getValueAtPercentile(45.0);
        this.p50 = (int)underlying.getValueAtPercentile(50.0);
        this.p55 = (int)underlying.getValueAtPercentile(55.0);
        this.p60 = (int)underlying.getValueAtPercentile(60.0);
        this.p65 = (int)underlying.getValueAtPercentile(65.0);
        this.p70 = (int)underlying.getValueAtPercentile(70.0);
        this.p75 = (int)underlying.getValueAtPercentile(75.0);
        this.p80 = (int)underlying.getValueAtPercentile(80.0);
        this.p85 = (int)underlying.getValueAtPercentile(85.0);
        this.p90 = (int)underlying.getValueAtPercentile(90.0);
        this.p95 = (int)underlying.getValueAtPercentile(95.0);
        this.p99 = (int)underlying.getValueAtPercentile(99.0);
        this.p99_5 = (int)underlying.getValueAtPercentile(99.5);
        this.p99_9 = (int)underlying.getValueAtPercentile(99.9);
        this.p99_95 = (int)underlying.getValueAtPercentile(99.95);
        this.p99_99 = (int)underlying.getValueAtPercentile(99.99);
        this.p100 = (int)underlying.getValueAtPercentile(100.0);
    }

    public Histogram getUnderlying() {
        return this.underlying;
    }

    public int getMean() {
        return this.mean;
    }

    public int getValueAtPercentile(double percentile) {
        int permyriad = (int)percentile * 100;
        switch (permyriad) {
            case 0: {
                return this.p0;
            }
            case 500: {
                return this.p5;
            }
            case 1000: {
                return this.p10;
            }
            case 1500: {
                return this.p15;
            }
            case 2000: {
                return this.p20;
            }
            case 2500: {
                return this.p25;
            }
            case 3000: {
                return this.p30;
            }
            case 3500: {
                return this.p35;
            }
            case 4000: {
                return this.p40;
            }
            case 4500: {
                return this.p45;
            }
            case 5000: {
                return this.p50;
            }
            case 5500: {
                return this.p55;
            }
            case 6000: {
                return this.p60;
            }
            case 6500: {
                return this.p65;
            }
            case 7000: {
                return this.p70;
            }
            case 7500: {
                return this.p75;
            }
            case 8000: {
                return this.p80;
            }
            case 8500: {
                return this.p85;
            }
            case 9000: {
                return this.p90;
            }
            case 9500: {
                return this.p95;
            }
            case 9900: {
                return this.p99;
            }
            case 9950: {
                return this.p99_5;
            }
            case 9990: {
                return this.p99_9;
            }
            case 9995: {
                return this.p99_95;
            }
            case 9999: {
                return this.p99_99;
            }
            case 10000: {
                return this.p100;
            }
        }
        return this.getArbitraryPercentile(percentile);
    }

    private synchronized int getArbitraryPercentile(double percentile) {
        return (int)this.underlying.getValueAtPercentile(percentile);
    }

    public synchronized long getTotalCount() {
        return this.underlying.getTotalCount();
    }
}

