/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.util.concurrent;

import com.netflix.util.UUIDFactory;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Singleton;

@Singleton
public class ConcurrentUUIDFactory
implements UUIDFactory {
    @Override
    public UUID generateRandomUuid() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long mostSig = ((Random)rnd).nextLong();
        long leastSig = ((Random)rnd).nextLong();
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSig |= 0x4000L, leastSig |= Long.MIN_VALUE);
    }
}

